/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.management;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.fcrepo.server.Context;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.management.ManagementDelegate;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.fcrepo.server.storage.types.Validation;

public class MockManagementDelegate
implements ManagementDelegate {
    private final List<Call> calls = new ArrayList<Call>();

    public void reset() {
        this.calls.clear();
    }

    public int getCallCount() {
        return this.calls.size();
    }

    public List<Call> getCalls() {
        return new ArrayList<Call>(this.calls);
    }

    public String addDatastream(Context context, String pid, String dsID, String[] altIDs, String dsLabel, boolean versionable, String MIMEType, String formatURI, String location, String controlGroup, String dsState, String checksumType, String checksum, String logMessage) throws ServerException {
        this.calls.add(new Call("addDatastream", context, pid, dsID, altIDs, dsLabel, versionable, MIMEType, formatURI, location, controlGroup, dsState, checksumType, checksum, logMessage));
        return dsID;
    }

    public boolean adminPing(Context context) throws ServerException {
        this.calls.add(new Call("adminPing", context));
        return true;
    }

    public boolean addRelationship(Context context, String subject, String relationship, String object, boolean isLiteral, String datatype) throws ServerException {
        this.calls.add(new Call("addRelationship", context, subject, relationship, object, isLiteral, datatype));
        return true;
    }

    public String compareDatastreamChecksum(Context context, String pid, String dsID, Date asOfDateTime) throws ServerException {
        this.calls.add(new Call("compareDatastreamChecksum", context, pid, dsID, asOfDateTime));
        return "bogusChecksum";
    }

    public InputStream export(Context context, String pid, String format, String exportContext, String encoding) throws ServerException {
        this.calls.add(new Call("export", context, pid, format, exportContext, encoding));
        return new ByteArrayInputStream(new byte[0]);
    }

    public Datastream getDatastream(Context context, String pid, String datastreamID, Date asOfDateTime) throws ServerException {
        this.calls.add(new Call("getDatastream", context, pid, datastreamID, asOfDateTime));
        return null;
    }

    public Datastream[] getDatastreamHistory(Context context, String pid, String datastreamID) throws ServerException {
        this.calls.add(new Call("getDatastreamHistory", context, pid, datastreamID));
        return new Datastream[0];
    }

    public Datastream[] getDatastreams(Context context, String pid, Date asOfDateTime, String dsState) throws ServerException {
        this.calls.add(new Call("getDatastreams", context, pid, asOfDateTime, dsState));
        return new Datastream[0];
    }

    public String[] getNextPID(Context context, int numPIDs, String namespace) throws ServerException {
        this.calls.add(new Call("getNextPID", context, numPIDs, namespace));
        String[] result = new String[numPIDs];
        for (int i = 0; i < result.length; ++i) {
            result[i] = "sillyPID_" + i;
        }
        return result;
    }

    public InputStream getObjectXML(Context context, String pid, String encoding) {
        this.calls.add(new Call("getObjectXML", context, pid, encoding));
        return new ByteArrayInputStream(new byte[0]);
    }

    public RelationshipTuple[] getRelationships(Context context, String subject, String relationship) throws ServerException {
        this.calls.add(new Call("getRelationships", context, subject, relationship));
        return new RelationshipTuple[0];
    }

    public InputStream getTempStream(String id) throws ServerException {
        this.calls.add(new Call("getTempStream", id));
        return new ByteArrayInputStream(new byte[0]);
    }

    public String ingest(Context context, InputStream serialization, String logMessage, String format, String encoding, String pid) throws ServerException {
        this.calls.add(new Call("ingest", context, serialization, logMessage, format, encoding, pid));
        return "Ingest:" + this.getCallCount();
    }

    public Date modifyDatastreamByReference(Context context, String pid, String datastreamID, String[] altIDs, String dsLabel, String mimeType, String formatURI, String dsLocation, String checksumType, String checksum, String logMessage, Date lastModifiedDate) throws ServerException {
        this.calls.add(new Call("modifyDatastreamByReference", context, pid, datastreamID, altIDs, dsLabel, mimeType, formatURI, dsLocation, checksumType, checksum, logMessage, lastModifiedDate));
        return new Date(111111L);
    }

    public Date modifyDatastreamByValue(Context context, String pid, String datastreamID, String[] altIDs, String dsLabel, String mimeType, String formatURI, InputStream dsContent, String checksumType, String checksum, String logMessage, Date lastModifiedDate) throws ServerException {
        this.calls.add(new Call("modifyDatastreamByValue", context, pid, datastreamID, altIDs, dsLabel, mimeType, formatURI, dsContent, checksumType, checksum, logMessage, lastModifiedDate));
        return new Date(222222L);
    }

    public Date modifyObject(Context context, String pid, String state, String label, String ownerId, String logMessage, Date lastModifiedDate) throws ServerException {
        this.calls.add(new Call("modifyObject", context, pid, state, label, ownerId, logMessage, lastModifiedDate));
        return new Date(10000L);
    }

    public Date[] purgeDatastream(Context context, String pid, String datastreamID, Date startDT, Date endDT, String logMessage) throws ServerException {
        this.calls.add(new Call("purgeDatastream", context, pid, datastreamID, startDT, endDT, logMessage));
        return new Date[0];
    }

    public Date purgeObject(Context context, String pid, String logMessage) throws ServerException {
        this.calls.add(new Call("purgeObject", context, pid, logMessage));
        return new Date(654L);
    }

    public boolean purgeRelationship(Context context, String subject, String relationship, String object, boolean isLiteral, String datatype) throws ServerException {
        this.calls.add(new Call("purgeRelationship", context, subject, relationship, object, isLiteral, datatype));
        return false;
    }

    public Validation validate(Context context, String pid, Date asOfDateTime) throws ServerException {
        return null;
    }

    public String putTempStream(Context context, InputStream in) throws ServerException {
        this.calls.add(new Call("putTempStream", context, in));
        return "tempStreamId";
    }

    public Date setDatastreamState(Context context, String pid, String dsID, String dsState, String logMessage) throws ServerException {
        this.calls.add(new Call("setDatastreamState", context, pid, dsID, dsState, logMessage));
        return new Date(3000000L);
    }

    public Date setDatastreamVersionable(Context context, String pid, String dsID, boolean versionable, String logMessage) throws ServerException {
        this.calls.add(new Call("setDatastreamVersionable", context, pid, dsID, versionable, logMessage));
        return new Date(234234L);
    }

    public static class Call {
        private final String methodName;
        private final Object[] methodArgs;

        public Call(String methodName, Object ... methodArgs) {
            this.methodName = methodName;
            this.methodArgs = methodArgs;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Object[] getMethodArgs() {
            return this.methodArgs;
        }

        public String toString() {
            return "Call[" + this.methodName + ", " + Arrays.deepToString(this.methodArgs) + "]";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!Call.class.equals(obj.getClass())) {
                return false;
            }
            Call that = (Call)obj;
            return this.methodName.equals(that.methodName) && this.equalArgs(this.methodArgs, that.methodArgs);
        }

        private boolean equalArgs(Object[] args1, Object[] args2) {
            if (args1.length != args2.length) {
                return false;
            }
            for (int i = 0; i < args1.length; ++i) {
                if (args1[i] instanceof InputStream && args2[i] instanceof InputStream || (args1[i] instanceof Object[] && args2[i] instanceof Object[] ? Arrays.deepEquals((Object[])args1[i], (Object[])args2[i]) : args1[i].equals(args2[i]))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.methodName.hashCode() ^ Arrays.asList(this.methodArgs).hashCode();
        }
    }
}

