/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.resourceIndex;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import org.fcrepo.server.resourceIndex.ParamDomain;
import org.fcrepo.server.storage.types.MethodParmDef;

public class ParamDomainMap
extends TreeMap<String, ParamDomain> {
    private static final long serialVersionUID = 1L;
    private final String _methodName;

    public ParamDomainMap(String methodName) {
        this._methodName = methodName;
    }

    public ParamDomainMap(String methodName, MethodParmDef[] parmDefs, boolean userInputOnly) {
        this._methodName = methodName;
        for (MethodParmDef element : parmDefs) {
            if (userInputOnly && !element.parmType.equals("fedora:userInputType")) continue;
            ParamDomain domain = new ParamDomain(element.parmName, element.parmRequired, element.parmDomainValues);
            this.put(element.parmName, domain);
        }
    }

    public String getMethodName() {
        return this._methodName;
    }

    public Set<String> getPermutations() {
        HashSet<String> set = new HashSet<String>();
        ParamDomainMap.addPermutations(this._methodName, this.getValues(), 0, '?', set);
        return set;
    }

    private static void addPermutations(String prefix, ParamDomain[] domains, int index, char delimiter, Set<String> set) {
        if (index + 1 > domains.length) {
            set.add(prefix);
            return;
        }
        ParamDomain domain = domains[index];
        if (domain.size() > 0) {
            for (String domainValue : domain) {
                String newPrefix = prefix + delimiter + domain.getParameterName() + "=" + domainValue;
                ParamDomainMap.addPermutations(newPrefix, domains, index + 1, '&', set);
            }
        }
        if (!domain.isRequired()) {
            ParamDomainMap.addPermutations(prefix, domains, index + 1, delimiter, set);
        }
    }

    private ParamDomain[] getValues() {
        ParamDomain[] values = new ParamDomain[this.size()];
        int i = 0;
        for (String key : this.keySet()) {
            values[i++] = (ParamDomain)this.get(key);
        }
        return values;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            ParamDomainMap m = (ParamDomainMap)obj;
            return this._methodName.equals(m.getMethodName());
        }
        return false;
    }
}

