/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.resourceIndex;

import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.server.resourceIndex.ResourceIndexIntegrationTest;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.ObjectBuilder;

public class ResourceIndexAddDelDSIntegrationTest
extends ResourceIndexIntegrationTest {
    @org.junit.Test
    public void testAddDelObjNoDatastreams() throws Exception {
        this.doAddDelTest(1, ResourceIndexAddDelDSIntegrationTest.getTestObject("test:1", "test"));
    }

    @org.junit.Test
    public void testAddDelObjExternalDS() throws Exception {
        DigitalObject obj = ResourceIndexAddDelDSIntegrationTest.getTestObject("test:1", "test");
        ResourceIndexAddDelDSIntegrationTest.addEDatastream(obj, "DS1");
        this.doAddDelTest(1, obj);
    }

    @org.junit.Test
    public void testAddDelObjManagedDS() throws Exception {
        DigitalObject obj = ResourceIndexAddDelDSIntegrationTest.getTestObject("test:1", "test");
        ResourceIndexAddDelDSIntegrationTest.addMDatastream(obj, "DS1");
        this.doAddDelTest(1, obj);
    }

    @org.junit.Test
    public void testAddDelObjRedirectDS() throws Exception {
        DigitalObject obj = ResourceIndexAddDelDSIntegrationTest.getTestObject("test:1", "test");
        ResourceIndexAddDelDSIntegrationTest.addRDatastream(obj, "DS1");
        this.doAddDelTest(1, obj);
    }

    @org.junit.Test
    public void testAddDelObjInlineXMLDS() throws Exception {
        DigitalObject obj = ResourceIndexAddDelDSIntegrationTest.getTestObject("test:1", "test");
        ResourceIndexAddDelDSIntegrationTest.addXDatastream(obj, "DS1", "<xmldoc/>");
        this.doAddDelTest(1, obj);
    }

    @org.junit.Test
    public void testAddDelObjDCDS() throws Exception {
        DigitalObject obj = ResourceIndexAddDelDSIntegrationTest.getTestObject("test:1", "test");
        ResourceIndexAddDelDSIntegrationTest.addXDatastream(obj, "DC", this.getDC("<dc:title>test</dc:title>"));
        this.doAddDelTest(1, obj);
    }

    @org.junit.Test
    public void testAddDelObjRELSEXTDS() throws Exception {
        DigitalObject obj = ResourceIndexAddDelDSIntegrationTest.getTestObject("test:1", "test");
        String rel = "<foo:bar rdf:resource=\"http://example.org/baz\"/>";
        ResourceIndexAddDelDSIntegrationTest.addXDatastream(obj, "RELS-EXT", ObjectBuilder.getRELSEXT("test:1", rel));
        this.doAddDelTest(1, obj);
    }

    @org.junit.Test
    public void testAddDelObjRELSINTDS() throws Exception {
        DigitalObject obj = ResourceIndexAddDelDSIntegrationTest.getTestObject("test:1", "test");
        String rel1 = "<foo:bar rdf:resource=\"http://example.org/baz\"/>";
        String rel2 = "<foo:baz>qux</foo:baz>";
        ResourceIndexAddDelDSIntegrationTest.addXDatastream(obj, "RELS-INT", ObjectBuilder.getRELSINT("test:1", rel1, rel2));
        this.doAddDelTest(1, obj);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ResourceIndexAddDelDSIntegrationTest.class);
    }
}

