/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.resourceIndex;

import java.util.Date;
import java.util.TimeZone;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.common.Constants;
import org.fcrepo.server.resourceIndex.ResourceIndexIntegrationTest;
import org.fcrepo.server.storage.types.DigitalObject;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.jrdf.graph.Literal;
import org.jrdf.graph.ObjectNode;
import org.junit.Assert;
import org.trippi.TripleIterator;

public class ResourceIndexDatePrecisionIntegrationTest
extends ResourceIndexIntegrationTest {
    private static TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final DateTimeFormatter _millisFormat = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(DateTimeZone.UTC);

    @org.junit.Test
    public void testMillisecondDatePrecision() throws Exception {
        String[] DT = new String[]{"1970-01-01T00:00:00.001Z", "1970-01-01T00:00:00.010Z", "1970-01-01T00:00:00.100Z"};
        String[] DT_XSD = new String[]{"1970-01-01T00:00:00.001Z", "1970-01-01T00:00:00.01Z", "1970-01-01T00:00:00.1Z"};
        Date[] date = new Date[]{new Date(1L), new Date(10L), new Date(100L)};
        this.initRI(1);
        for (int i = 0; i < DT.length; ++i) {
            this.testDates(DT[i], date[i], "test:" + i, DT_XSD[i]);
        }
    }

    @org.junit.Test
    public void testBoundaryDates() throws Exception {
        Date EPOCH = new Date(0L);
        Date ONE_CE = new Date(-62135596800000L);
        Date ONE_BCE = new Date(-62198755200000L);
        Date TWO_BCE = new Date(-62230291200000L);
        String EPOCH_DT = "1970-01-01T00:00:00.000Z";
        String ONE_CE_DT = "0001-01-01T00:00:00.000Z";
        String ONE_BCE_DT = "-0001-01-01T00:00:00.000Z";
        String TWO_BCE_DT = "-0002-01-01T00:00:00.000Z";
        String EPOCH_XSD = "1970-01-01T00:00:00Z";
        String ONE_CE_XSD = "0001-01-01T00:00:00Z";
        String ONE_BCE_XSD = "0000-01-01T00:00:00Z";
        String TWO_BCE_XSD = "-0001-01-01T00:00:00Z";
        this.initRI(1);
        this.testDates(EPOCH_DT, EPOCH, "test:epoch", EPOCH_XSD);
        this.testDates(ONE_CE_DT, ONE_CE, "test:one_ce", ONE_CE_XSD);
        this.testDates(ONE_BCE_DT, ONE_BCE, "test:one_bce", ONE_BCE_XSD);
        this.testDates(TWO_BCE_DT, TWO_BCE, "test:two_bce", TWO_BCE_XSD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDates(String dateTime, Date date, String pid, String xsdDateTime) throws Exception {
        Date createDate = this._millisFormat.parseDateTime(dateTime).toDate();
        Assert.assertEquals((Object)date, (Object)createDate);
        DigitalObject obj = ResourceIndexDatePrecisionIntegrationTest.getTestObject(pid, pid);
        obj.setCreateDate(createDate);
        this.addObj(obj, true);
        String query = String.format("<info:fedora/%s> <%s> *", pid, Constants.MODEL.CREATED_DATE.uri);
        TripleIterator results = this.spo(query);
        try {
            Assert.assertTrue((boolean)results.hasNext());
            ObjectNode dateNode = results.next().getObject();
            Assert.assertTrue((boolean)(dateNode instanceof Literal));
            Literal dateLiteral = (Literal)dateNode;
            Assert.assertEquals((Object)dateLiteral.getDatatypeURI().toString(), (Object)Constants.RDF_XSD.DATE_TIME.uri);
            Assert.assertEquals((Object)xsdDateTime, (Object)dateLiteral.getLexicalForm());
        }
        finally {
            results.close();
        }
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ResourceIndexDatePrecisionIntegrationTest.class);
    }
}

