/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.resourceIndex;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.fcrepo.common.Models;
import org.fcrepo.server.resourceIndex.ModelBasedTripleGenerator;
import org.fcrepo.server.resourceIndex.ParamDomain;
import org.fcrepo.server.resourceIndex.ParamDomainMap;
import org.fcrepo.server.resourceIndex.ResourceIndex;
import org.fcrepo.server.resourceIndex.ResourceIndexImpl;
import org.fcrepo.server.resourceIndex.TripleGenerator;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.MockRepositoryReader;
import org.fcrepo.server.storage.ServiceDefinitionReader;
import org.fcrepo.server.storage.ServiceDeploymentReader;
import org.fcrepo.server.storage.SimpleDOReader;
import org.fcrepo.server.storage.SimpleServiceDefinitionReader;
import org.fcrepo.server.storage.SimpleServiceDeploymentReader;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.ObjectBuilder;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.jrdf.graph.URIReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trippi.RDFFormat;
import org.trippi.RDFUtil;
import org.trippi.TripleIterator;
import org.trippi.TriplestoreConnector;
import org.trippi.io.TripleIteratorFactory;

public abstract class ResourceIndexIntegrationTest {
    private static final Logger logger = LoggerFactory.getLogger((String)ResourceIndexIntegrationTest.class.getName());
    private static final String TEST_DIR = "target";
    private static final String DB_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String DB_URL = "jdbc:derby:test;create=true";
    private static final String DB_USERNAME = "test";
    private static final String DB_PASSWORD = "test";
    private ResourceIndex _ri;
    private TripleIteratorFactory _factory;
    private Flusher _flusher;

    protected void initRI(int indexLevel) throws Exception {
        if (this._ri != null) {
            try {
                this._ri.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        TriplestoreConnector connector = ResourceIndexIntegrationTest.getConnector();
        ModelBasedTripleGenerator generator = new ModelBasedTripleGenerator();
        this._ri = new ResourceIndexImpl(connector, (TripleGenerator)generator, indexLevel, false);
    }

    private static TriplestoreConnector getConnector() throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("backslashIsEscape", "false");
        config.put("ddlGenerator", "org.nsdl.mptstore.impl.derby.DerbyDDLGenerator");
        config.put("autoFlushBufferSize", "1000");
        config.put("autoFlushDormantSeconds", "5");
        config.put("bufferFlushBatchSize", "1000");
        config.put("bufferSafeCapacity", "1000");
        config.put("fetchSize", "1000");
        config.put("jdbcDriver", DB_DRIVER);
        config.put("jdbcURL", DB_URL);
        config.put("username", "test");
        config.put("password", "test");
        config.put("poolInitialSize", "5");
        config.put("poolMaxSize", "10");
        return TriplestoreConnector.init((String)"org.trippi.impl.mpt.MPTConnector", config);
    }

    @Before
    public void setupTest() throws Exception {
        this._factory = new TripleIteratorFactory();
    }

    @After
    public void tearDownTest() throws Exception {
        if (this._ri != null) {
            this.tearDownTriplestore();
        }
        this._factory.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tearDownTriplestore() throws Exception {
        File dump = new File("target/all-triples.txt");
        FileOutputStream out = null;
        try {
            TripleIterator triples = this._ri.findTriples(null, null, null, -1);
            out = new FileOutputStream(dump);
            triples.toStream((OutputStream)out, RDFFormat.TURTLE);
            try {
                out.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            out = null;
            triples = this._factory.fromStream((InputStream)new FileInputStream(dump), RDFFormat.TURTLE);
            this._ri.delete(triples, true);
        }
        finally {
            if (out != null) {
                out.close();
            }
            dump.delete();
        }
        this._ri.close();
    }

    protected void doAddDelTest(int riLevel, DigitalObject obj) throws Exception {
        HashSet<DigitalObject> set = new HashSet<DigitalObject>();
        set.add(obj);
        this.doAddDelTest(riLevel, set);
    }

    protected void doAddDelTest(int riLevel, Set<DigitalObject> objects) throws Exception {
        this.initRI(riLevel);
        this.addAll(objects, true);
        Assert.assertTrue((String)"Did not get expected triples after add", (boolean)this.sameTriples(this.getExpectedTriples(riLevel, objects), this.getActualTriples(), true));
        this.deleteAll(objects, true);
        Assert.assertEquals((String)"Some triples remained after delete", (long)0L, (long)this.getActualTriples().size());
    }

    protected void doModifyTest(int riLevel, DigitalObject origObject, DigitalObject modifiedObject) throws Exception {
        HashSet<DigitalObject> origObjects = new HashSet<DigitalObject>();
        origObjects.add(origObject);
        this.doModifyTest(riLevel, origObjects, modifiedObject);
    }

    protected void doModifyTest(int riLevel, Set<DigitalObject> origObjects, DigitalObject modifiedObject) throws Exception {
        if (riLevel > -1) {
            this.initRI(riLevel);
            this.addAll(origObjects, true);
        }
        DigitalObject origObject = null;
        HashSet<DigitalObject> newObjects = new HashSet<DigitalObject>();
        for (DigitalObject orig : origObjects) {
            if (orig.getPid().equals(modifiedObject.getPid())) {
                origObject = orig;
                continue;
            }
            newObjects.add(orig);
        }
        newObjects.add(modifiedObject);
        this.modify(origObject, modifiedObject, true);
        Assert.assertTrue((String)"Did not get expected triples after modify", (boolean)this.sameTriples(this.getExpectedTriples(riLevel, newObjects), this.getActualTriples(), true));
    }

    protected void modify(DigitalObject origObject, DigitalObject modifiedObject, boolean flush) throws Exception {
        this._ri.modifyObject(this.getDOReader(origObject), this.getDOReader(modifiedObject));
        if (flush) {
            this._ri.flushBuffer();
        }
    }

    protected ServiceDefinitionReader getServiceDefinitionReader(DigitalObject obj) throws Exception {
        return new SimpleServiceDefinitionReader(null, null, null, null, null, obj);
    }

    protected ServiceDeploymentReader getServiceDeploymentReader(DigitalObject obj) throws Exception {
        return new SimpleServiceDeploymentReader(null, null, null, null, null, obj);
    }

    protected DOReader getDOReader(DigitalObject obj) throws Exception {
        return new SimpleDOReader(null, null, null, null, null, obj);
    }

    protected void addObj(DigitalObject obj, boolean flush) throws Exception {
        HashSet<DigitalObject> set = new HashSet<DigitalObject>();
        set.add(obj);
        this.addAll(set, flush);
    }

    protected void addAll(Set<DigitalObject> objects, boolean flush) throws Exception {
        this.addOrDelAll(objects, flush, true);
    }

    protected void deleteAll(Set<DigitalObject> objects, boolean flush) throws Exception {
        this.addOrDelAll(objects, flush, false);
    }

    private void addOrDelAll(Set<DigitalObject> objects, boolean flush, boolean add) throws Exception {
        for (DigitalObject obj : objects) {
            if (add) {
                this._ri.addObject(this.getDOReader(obj));
                continue;
            }
            this._ri.deleteObject(this.getDOReader(obj));
        }
        if (flush) {
            this._ri.flushBuffer();
        }
    }

    protected Set<Triple> getExpectedTriples(int riLevel, Set<DigitalObject> objects) throws Exception {
        if (riLevel == 0) {
            return new HashSet<Triple>();
        }
        MockRepositoryReader repo = new MockRepositoryReader();
        for (DigitalObject obj : objects) {
            repo.putObject(obj);
        }
        ModelBasedTripleGenerator generator = new ModelBasedTripleGenerator();
        HashSet<Triple> expected = new HashSet<Triple>();
        for (DigitalObject obj : objects) {
            expected.addAll(generator.getTriplesForObject(this.getDOReader(obj)));
        }
        return expected;
    }

    protected boolean sameTriples(Set<Triple> expected, Set<Triple> actual, boolean logDiffs) {
        TreeSet<String> eStrings = new TreeSet<String>();
        for (Triple triple : expected) {
            eStrings.add(RDFUtil.toString((Triple)triple));
        }
        TreeSet<String> aStrings = new TreeSet<String>();
        for (Triple triple : actual) {
            aStrings.add(RDFUtil.toString((Triple)triple));
        }
        if (eStrings.equals(aStrings)) {
            return true;
        }
        if (logDiffs) {
            StringBuffer out = new StringBuffer();
            out.append("Triple sets differ.\n");
            out.append("Expected set has " + expected.size() + " triples.\n");
            out.append("Actual set has " + actual.size() + " triples.\n\n");
            out.append("Expected triples:\n");
            for (String t : eStrings) {
                out.append("  " + t + "\n");
            }
            out.append("\nActual triples:\n");
            for (String t : aStrings) {
                out.append("  " + t + "\n");
            }
            logger.warn(out.toString());
        }
        return false;
    }

    protected Set<Triple> getActualTriples() throws Exception {
        return this.getActualTriples(null, null, null);
    }

    protected Set<Triple> getActualTriples(SubjectNode subject, PredicateNode predicate, ObjectNode object) throws Exception {
        HashSet<Triple> set = new HashSet<Triple>();
        TripleIterator iter = this._ri.findTriples(subject, predicate, object, -1);
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        iter.close();
        return set;
    }

    protected String getDC(String content) {
        StringBuffer x = new StringBuffer();
        x.append("<oai_dc:dc xmlns:dc=\"http://purl.org/dc/elements/1.1/\"");
        x.append(" xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\">\n");
        x.append(content + "\n");
        x.append("</oai_dc:dc>");
        return x.toString();
    }

    protected static String getMethodMap(Set<ParamDomainMap> methodDefs) {
        return ResourceIndexIntegrationTest.getMethodMap(methodDefs, null, false);
    }

    protected static String getMethodMap(Set<ParamDomainMap> methodDefs, Map<String, Set<String>> inputKeys, boolean forSDef) {
        StringBuffer xml = new StringBuffer();
        xml.append("<MethodMap name=\"MethodMap\" xmlns=\"http://fedora.comm.nsdlib.org/service/methodmap\">\n");
        for (ParamDomainMap methodDef : methodDefs) {
            String method = methodDef.getMethodName();
            xml.append("  <Method operationName=\"" + method + "\"");
            if (forSDef) {
                xml.append(" wsdlMsgName=\"" + method + "Request\"");
                xml.append(" wsdlMsgOutput=\"dissemResponse\"");
            }
            xml.append(">\n");
            for (String paramName : methodDef.keySet()) {
                ParamDomain domain = (ParamDomain)methodDef.get(paramName);
                xml.append("    <UserInputParm parmName=\"" + paramName + "\" passBy=\"VALUE\" defaultValue=\"\" required=\"" + domain.isRequired() + "\">\n");
                if (domain.size() > 0) {
                    xml.append("      <ValidParmValues>\n");
                    for (String value : domain) {
                        xml.append("        <ValidParm value=\"" + value + "\"/>\n");
                    }
                    xml.append("      </ValidParmValues>\n");
                }
                xml.append("    </UserInputParm>\n");
            }
            if (forSDef) {
                Set<String> keys = inputKeys.get(method);
                if (keys != null) {
                    for (String key : keys) {
                        xml.append("    <DatastreamInputParm parmName=\"" + key + "\" passBy=\"URL_REF\"/>\n");
                    }
                }
                xml.append("    <MethodReturnType wsdlMsgName=\"dissemResponse\" wsdlMsgTOMIME=\"application/octet-stream\"/>\n");
            }
            xml.append("  </Method>\n");
        }
        xml.append("</MethodMap>");
        return xml.toString();
    }

    protected static String getInputSpec(String sDefPID, Map<String, Set<String>> inputTypes) {
        StringBuffer xml = new StringBuffer();
        xml.append("<DSInputSpec xmlns=\"http://fedora.comm.nsdlib.org/service/bindspec\" label=\"InputSpec\">\n");
        for (String key : inputTypes.keySet()) {
            xml.append("  <DSInput DSMin=\"1\" DSMax=\"1\" DSOrdinality=\"false\" wsdlMsgPartName=\"" + key + "\">\n");
            xml.append("    <DSInputLabel>label</DSInputLabel>\n");
            for (String mimeType : inputTypes.get(key)) {
                xml.append("    <DSMIME>" + mimeType + "</DSMIME>\n");
            }
            xml.append("    <DSInputInstruction>inst</DSInputInstruction>\n");
            xml.append("  </DSInput>\n");
        }
        xml.append("</DSInputSpec>\n");
        return xml.toString();
    }

    private static void addXSDType(String name, StringBuffer xml) {
        xml.append("      <xsd:simpleType name=\"" + name + "\">\n");
        xml.append("        <xsd:restriction base=\"xsd:string\"/>\n");
        xml.append("      </xsd:simpleType>\n");
    }

    protected static String getWSDL(Set<ParamDomainMap> methodDefs, Map<String, Set<String>> inputKeys, Map<String, Set<String>> outputTypes) {
        String method;
        StringBuffer xml = new StringBuffer();
        xml.append("<definitions xmlns=\"http://schemas.xmlsoap.org/wsdl/\" xmlns:http=\"http://schemas.xmlsoap.org/wsdl/http/\" xmlns:mime=\"http://schemas.xmlsoap.org/wsdl/mime/\" xmlns:this=\"MyService\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" name=\"Name\" targetNamespace=\"MyService\">\n");
        xml.append("  <types>\n");
        xml.append("    <xsd:schema targetNamespace=\"MyService\">\n");
        HashSet<String> addedTypes = new HashSet<String>();
        for (ParamDomainMap methodDef : methodDefs) {
            for (String name : methodDef.keySet()) {
                if (!addedTypes.add(name + "Type")) continue;
                ResourceIndexIntegrationTest.addXSDType(name + "Type", xml);
            }
            for (String key : inputKeys.get(methodDef.getMethodName())) {
                if (!addedTypes.add(key + "Type")) continue;
                ResourceIndexIntegrationTest.addXSDType(key + "Type", xml);
            }
        }
        xml.append("    </xsd:schema>\n");
        xml.append("  </types>\n");
        for (ParamDomainMap methodDef : methodDefs) {
            method = methodDef.getMethodName();
            xml.append("  <message name=\"" + method + "Request\">\n");
            for (String name : methodDef.keySet()) {
                xml.append("    <part name=\"" + name + "\" type=\"this:" + name + "Type\"/>\n");
            }
            for (String key : inputKeys.get(method)) {
                xml.append("    <part name=\"" + key + "\" type=\"this:" + key + "Type\"/>\n");
            }
            xml.append("  </message>\n");
        }
        xml.append("  <message name=\"dissemResponse\">\n");
        xml.append("    <part name=\"response\" type=\"xsd:base64Binary\"/>\n");
        xml.append("  </message>\n");
        xml.append("  <portType name=\"MyServicePortType\">\n");
        for (ParamDomainMap methodDef : methodDefs) {
            method = methodDef.getMethodName();
            xml.append("    <operation name=\"" + method + "\">\n");
            xml.append("      <input message=\"this:" + method + "Request\"/>\n");
            xml.append("      <output message=\"this:dissemResponse\"/>\n");
            xml.append("    </operation>\n");
        }
        xml.append("  </portType>\n");
        xml.append("  <service name=\"MyService\">\n");
        xml.append("    <port binding=\"this:MyService_http\" name=\"MyService_port\">\n");
        xml.append("      <http:address location=\"http://example.org/MyService/\"/>\n");
        xml.append("    </port>\n");
        xml.append("  </service>\n");
        xml.append("  <binding name=\"MyService_http\" type=\"this:MyServicePortType\">\n");
        xml.append("    <http:binding verb=\"GET\"/>\n");
        for (ParamDomainMap methodDef : methodDefs) {
            method = methodDef.getMethodName();
            xml.append("    <operation name=\"" + method + "\">\n");
            StringBuffer location = new StringBuffer();
            location.append(method + "?");
            boolean first = true;
            for (String name : methodDef.keySet()) {
                if (!first) {
                    location.append("&amp;");
                }
                location.append(name + "=(" + name + ")");
                first = false;
            }
            for (String key : inputKeys.get(method)) {
                if (!first) {
                    location.append("&amp;");
                }
                location.append(key.toLowerCase() + "=(" + key + ")");
                first = false;
            }
            xml.append("      <http:operation location=\"" + location.toString() + "\"/>\n");
            xml.append("      <input><http:urlReplacement/></input>\n");
            xml.append("      <output>\n");
            for (String mimeType : outputTypes.get(method)) {
                xml.append("        <mime:content type=\"" + mimeType + "\"/>\n");
            }
            xml.append("      </output>\n");
            xml.append("    </operation>\n");
        }
        xml.append("  </binding>\n");
        xml.append("</definitions>\n");
        return xml.toString();
    }

    protected static Set<DigitalObject> getTestObjects(int num, int datastreamsPerObject) {
        HashSet<DigitalObject> set = new HashSet<DigitalObject>(num);
        for (int i = 0; i < num; ++i) {
            DigitalObject obj = ResourceIndexIntegrationTest.getTestObject("test:" + i, "label" + i);
            for (int j = 0; j < datastreamsPerObject; ++j) {
                ResourceIndexIntegrationTest.addEDatastream(obj, "DS" + j);
            }
            set.add(obj);
        }
        return set;
    }

    protected TripleIterator spo(String query) throws Exception {
        return this._ri.findTriples("spo", query, -1, false);
    }

    protected static void addEDatastream(DigitalObject obj, String id) {
        ObjectBuilder.addEDatastream(obj, id);
    }

    protected static void addRDatastream(DigitalObject obj, String id) {
        ObjectBuilder.addRDatastream(obj, id);
    }

    protected static void addXDatastream(DigitalObject obj, String id, String xml) {
        ObjectBuilder.addXDatastream(obj, id, xml);
    }

    protected static void addMDatastream(DigitalObject obj, String id) {
        ObjectBuilder.addMDatastream(obj, id);
    }

    protected static DigitalObject getTestObject(String pid, String label) {
        return ObjectBuilder.getTestObject(pid, label);
    }

    protected static DigitalObject getTestSDef(String pid, String label, Set<ParamDomainMap> methodDefs) {
        Date now = new Date();
        URIReference[] models = new URIReference[]{Models.SERVICE_DEFINITION_3_0};
        DigitalObject obj = ObjectBuilder.getTestObject(pid, models, "A", "someOwnerId", label, now, now);
        ResourceIndexIntegrationTest.addXDatastream(obj, "METHODMAP", ResourceIndexIntegrationTest.getMethodMap(methodDefs));
        return obj;
    }

    protected static DigitalObject getTestSDep(String pid, String label, String sDefPID, Set<ParamDomainMap> methodDefs, Map<String, Set<String>> inputKeys, Map<String, Set<String>> inputTypes, Map<String, Set<String>> outputTypes) {
        Date now = new Date();
        URIReference[] models = new URIReference[]{Models.SERVICE_DEPLOYMENT_3_0};
        DigitalObject obj = ObjectBuilder.getTestObject(pid, models, "A", "someOwnerId", label, now, now);
        String methodMapXML = ResourceIndexIntegrationTest.getMethodMap(methodDefs, inputKeys, true);
        ResourceIndexIntegrationTest.addXDatastream(obj, "METHODMAP", methodMapXML);
        String inputSpecXML = ResourceIndexIntegrationTest.getInputSpec(sDefPID, inputTypes);
        ResourceIndexIntegrationTest.addXDatastream(obj, "DSINPUTSPEC", inputSpecXML);
        String wsdlXML = ResourceIndexIntegrationTest.getWSDL(methodDefs, inputKeys, outputTypes);
        ResourceIndexIntegrationTest.addXDatastream(obj, "WSDL", wsdlXML);
        return obj;
    }

    protected static DigitalObject getSDefOne() {
        HashSet<ParamDomainMap> methodDefs = new HashSet<ParamDomainMap>();
        ParamDomainMap methodOne = new ParamDomainMap("methodOne");
        methodDefs.add(methodOne);
        return ResourceIndexIntegrationTest.getTestSDef("test:sdef1", "sdef1", methodDefs);
    }

    protected static DigitalObject getSDefOneB() {
        HashSet<ParamDomainMap> methodDefs = new HashSet<ParamDomainMap>();
        ParamDomainMap methodOne = new ParamDomainMap("methodOne");
        methodDefs.add(methodOne);
        ParamDomainMap methodTwo = new ParamDomainMap("methodTwo");
        methodDefs.add(methodTwo);
        return ResourceIndexIntegrationTest.getTestSDef("test:sdef1b", "sdef1b", methodDefs);
    }

    protected static DigitalObject getSDefOneC() {
        HashSet<ParamDomainMap> methodDefs = new HashSet<ParamDomainMap>();
        ParamDomainMap methodOne = new ParamDomainMap("methodOne");
        methodDefs.add(methodOne);
        return ResourceIndexIntegrationTest.getTestSDef("test:sdef1c", "sdef1c", methodDefs);
    }

    protected static DigitalObject getSDefTwo() {
        HashSet<ParamDomainMap> methodDefs = new HashSet<ParamDomainMap>();
        ParamDomainMap methodOne = new ParamDomainMap("methodOne");
        ParamDomain argOneDomain = new ParamDomain("argOne", true);
        argOneDomain.add("val1");
        argOneDomain.add("val2");
        methodOne.put("argOne", argOneDomain);
        methodDefs.add(methodOne);
        return ResourceIndexIntegrationTest.getTestSDef("test:sdef2", "sdef2", methodDefs);
    }

    protected static DigitalObject getSDefTwoB() {
        HashSet<ParamDomainMap> methodDefs = new HashSet<ParamDomainMap>();
        ParamDomainMap methodOne = new ParamDomainMap("methodOne");
        ParamDomain argOneDomain = new ParamDomain("argOne", true);
        argOneDomain.add("val1");
        argOneDomain.add("val2");
        methodOne.put("argOne", argOneDomain);
        methodDefs.add(methodOne);
        ParamDomainMap methodTwo = new ParamDomainMap("methodTwo");
        methodTwo.put("argOne", argOneDomain);
        methodDefs.add(methodTwo);
        return ResourceIndexIntegrationTest.getTestSDef("test:sdef2b", "sdef2b", methodDefs);
    }

    protected static DigitalObject getSDefThree() {
        HashSet<ParamDomainMap> methodDefs = new HashSet<ParamDomainMap>();
        ParamDomainMap methodOne = new ParamDomainMap("methodOne");
        ParamDomain argOneDomain = new ParamDomain("argOne", false);
        methodOne.put("argOne", argOneDomain);
        methodDefs.add(methodOne);
        return ResourceIndexIntegrationTest.getTestSDef("test:sdef3", "sdef3", methodDefs);
    }

    protected static DigitalObject getSDefThreeB() {
        HashSet<ParamDomainMap> methodDefs = new HashSet<ParamDomainMap>();
        ParamDomainMap methodOne = new ParamDomainMap("methodOne");
        ParamDomain argOneDomain = new ParamDomain("argOne", false);
        methodOne.put("argOne", argOneDomain);
        methodDefs.add(methodOne);
        ParamDomainMap methodTwo = new ParamDomainMap("methodTwo");
        methodTwo.put("argOne", argOneDomain);
        methodDefs.add(methodTwo);
        return ResourceIndexIntegrationTest.getTestSDef("test:sdef3b", "sdef3b", methodDefs);
    }

    protected static DigitalObject getSDefFour() {
        HashSet<ParamDomainMap> methodDefs = new HashSet<ParamDomainMap>();
        ParamDomainMap methodOne = new ParamDomainMap("methodOne");
        ParamDomain argOneDomain = new ParamDomain("argOne", true);
        argOneDomain.add("val1");
        argOneDomain.add("val2");
        methodOne.put("argOne", argOneDomain);
        methodDefs.add(methodOne);
        ParamDomainMap methodTwo = new ParamDomainMap("methodTwo");
        argOneDomain = new ParamDomain("argOne", false);
        methodTwo.put("argOne", argOneDomain);
        methodDefs.add(methodTwo);
        return ResourceIndexIntegrationTest.getTestSDef("test:sdef4", "sdef4", methodDefs);
    }

    protected static Map<String, Set<String>> getMap(String key1, String[] values1, String key2, String[] values2) {
        HashSet<String> valueSet1 = new HashSet<String>();
        for (String value : values1) {
            valueSet1.add(value);
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        map.put(key1, valueSet1);
        if (key2 != null) {
            HashSet<String> valueSet2 = new HashSet<String>();
            for (String value : values2) {
                valueSet2.add(value);
            }
            map.put(key2, valueSet2);
        }
        return map;
    }

    protected static DigitalObject getSDepOne() {
        HashSet<ParamDomainMap> methodDefs = new HashSet<ParamDomainMap>();
        ParamDomainMap methodOne = new ParamDomainMap("methodOne");
        methodDefs.add(methodOne);
        return ResourceIndexIntegrationTest.getTestSDep("test:sdep1", "sdep1", "test:sdef1", methodDefs, ResourceIndexIntegrationTest.getMap("methodOne", new String[]{"KEY1"}, null, null), ResourceIndexIntegrationTest.getMap("KEY1", new String[]{"text/xml"}, null, null), ResourceIndexIntegrationTest.getMap("methodOne", new String[]{"text/xml"}, null, null));
    }

    protected static DigitalObject getSDepOneB() {
        HashSet<ParamDomainMap> methodDefs = new HashSet<ParamDomainMap>();
        ParamDomainMap methodOne = new ParamDomainMap("methodOne");
        methodDefs.add(methodOne);
        ParamDomainMap methodTwo = new ParamDomainMap("methodTwo");
        methodDefs.add(methodTwo);
        return ResourceIndexIntegrationTest.getTestSDep("test:sdep1b", "sdep1b", "test:sdef1b", methodDefs, ResourceIndexIntegrationTest.getMap("methodOne", new String[]{"KEY1"}, "methodTwo", new String[]{"KEY2"}), ResourceIndexIntegrationTest.getMap("KEY1", new String[]{"text/xml"}, "KEY2", new String[]{"text/xml"}), ResourceIndexIntegrationTest.getMap("methodOne", new String[]{"text/xml"}, "methodTwo", new String[]{"text/xml"}));
    }

    protected static DigitalObject getSDepOneC() {
        HashSet<ParamDomainMap> methodDefs = new HashSet<ParamDomainMap>();
        ParamDomainMap methodOne = new ParamDomainMap("methodOne");
        methodDefs.add(methodOne);
        return ResourceIndexIntegrationTest.getTestSDep("test:sdep1c", "sdep1c", "test:sdef1c", methodDefs, ResourceIndexIntegrationTest.getMap("methodOne", new String[]{"KEY1"}, null, null), ResourceIndexIntegrationTest.getMap("KEY1", new String[]{"text/xml"}, null, null), ResourceIndexIntegrationTest.getMap("methodOne", new String[]{"text/xml"}, null, null));
    }

    protected static DigitalObject getSDepOneD() {
        HashSet<ParamDomainMap> methodDefs = new HashSet<ParamDomainMap>();
        ParamDomainMap methodOne = new ParamDomainMap("methodOne");
        methodDefs.add(methodOne);
        return ResourceIndexIntegrationTest.getTestSDep("test:sdep1d", "sdep1d", "test:sdef1", methodDefs, ResourceIndexIntegrationTest.getMap("methodOne", new String[]{"KEY1", "KEY2"}, null, null), ResourceIndexIntegrationTest.getMap("KEY1", new String[]{"text/xml"}, "KEY2", new String[]{"text/xml"}), ResourceIndexIntegrationTest.getMap("methodOne", new String[]{"text/xml"}, null, null));
    }

    protected static DigitalObject getSDepTwo() {
        HashSet<ParamDomainMap> methodDefs = new HashSet<ParamDomainMap>();
        ParamDomainMap methodOne = new ParamDomainMap("methodOne");
        ParamDomain argOneDomain = new ParamDomain("argOne", true);
        argOneDomain.add("val1");
        argOneDomain.add("val2");
        methodOne.put("argOne", argOneDomain);
        methodDefs.add(methodOne);
        return ResourceIndexIntegrationTest.getTestSDep("test:sdep2", "sdep2", "test:sdef2", methodDefs, ResourceIndexIntegrationTest.getMap("methodOne", new String[]{"KEY1"}, null, null), ResourceIndexIntegrationTest.getMap("KEY1", new String[]{"text/xml"}, null, null), ResourceIndexIntegrationTest.getMap("methodOne", new String[]{"text/xml"}, null, null));
    }

    protected static DigitalObject getSDepTwoB() {
        HashSet<ParamDomainMap> methodDefs = new HashSet<ParamDomainMap>();
        ParamDomainMap methodOne = new ParamDomainMap("methodOne");
        ParamDomain argOneDomain = new ParamDomain("argOne", true);
        argOneDomain.add("val1");
        argOneDomain.add("val2");
        methodOne.put("argOne", argOneDomain);
        methodDefs.add(methodOne);
        ParamDomainMap methodTwo = new ParamDomainMap("methodTwo");
        methodTwo.put("argOne", argOneDomain);
        methodDefs.add(methodTwo);
        return ResourceIndexIntegrationTest.getTestSDep("test:sdep2b", "sdep2b", "test:zdef2b", methodDefs, ResourceIndexIntegrationTest.getMap("methodOne", new String[]{"KEY1"}, "methodTwo", new String[]{"KEY2"}), ResourceIndexIntegrationTest.getMap("KEY1", new String[]{"text/xml"}, "KEY2", new String[]{"text/xml"}), ResourceIndexIntegrationTest.getMap("methodOne", new String[]{"text/xml"}, "methodTwo", new String[]{"text/xml"}));
    }

    protected static DigitalObject getSDepThree() {
        HashSet<ParamDomainMap> methodDefs = new HashSet<ParamDomainMap>();
        ParamDomainMap methodOne = new ParamDomainMap("methodOne");
        ParamDomain argOneDomain = new ParamDomain("argOne", false);
        methodOne.put("argOne", argOneDomain);
        methodDefs.add(methodOne);
        return ResourceIndexIntegrationTest.getTestSDep("test:sdep3", "sdep3", "test:sdef3", methodDefs, ResourceIndexIntegrationTest.getMap("methodOne", new String[]{"KEY1"}, null, null), ResourceIndexIntegrationTest.getMap("KEY1", new String[]{"text/xml"}, null, null), ResourceIndexIntegrationTest.getMap("methodOne", new String[]{"text/xml"}, null, null));
    }

    protected static DigitalObject getSDepThreeB() {
        HashSet<ParamDomainMap> methodDefs = new HashSet<ParamDomainMap>();
        ParamDomainMap methodOne = new ParamDomainMap("methodOne");
        ParamDomain argOneDomain = new ParamDomain("argOne", false);
        methodOne.put("argOne", argOneDomain);
        methodDefs.add(methodOne);
        ParamDomainMap methodTwo = new ParamDomainMap("methodTwo");
        methodTwo.put("argOne", argOneDomain);
        methodDefs.add(methodTwo);
        return ResourceIndexIntegrationTest.getTestSDep("test:sdep3b", "sdep3b", "test:sdef3b", methodDefs, ResourceIndexIntegrationTest.getMap("methodOne", new String[]{"KEY1"}, "methodTwo", new String[]{"KEY2"}), ResourceIndexIntegrationTest.getMap("KEY1", new String[]{"text/xml"}, "KEY2", new String[]{"text/xml"}), ResourceIndexIntegrationTest.getMap("methodOne", new String[]{"text/xml"}, "methodTwo", new String[]{"text/xml"}));
    }

    protected static DigitalObject getSDepFour() {
        HashSet<ParamDomainMap> methodDefs = new HashSet<ParamDomainMap>();
        ParamDomainMap methodOne = new ParamDomainMap("methodOne");
        ParamDomain argOneDomain = new ParamDomain("argOne", true);
        argOneDomain.add("val1");
        argOneDomain.add("val2");
        methodOne.put("argOne", argOneDomain);
        methodDefs.add(methodOne);
        ParamDomainMap methodTwo = new ParamDomainMap("methodTwo");
        argOneDomain = new ParamDomain("argOne", false);
        methodTwo.put("argOne", argOneDomain);
        methodDefs.add(methodTwo);
        return ResourceIndexIntegrationTest.getTestSDep("test:sdep4", "sdep4", "test:sdef4", methodDefs, ResourceIndexIntegrationTest.getMap("methodOne", new String[]{"KEY1"}, "methodTwo", new String[]{"KEY2"}), ResourceIndexIntegrationTest.getMap("KEY1", new String[]{"text/xml"}, "KEY2", new String[]{"text/xml"}), ResourceIndexIntegrationTest.getMap("methodOne", new String[]{"text/xml"}, "methodTwo", new String[]{"text/xml"}));
    }

    protected Map<String, String> getBindings(int numKeys) {
        HashMap<String, String> bindings = new HashMap<String, String>();
        for (int i = 1; i <= numKeys; ++i) {
            bindings.put("KEY" + i, "DS1");
        }
        return bindings;
    }

    protected Set<DigitalObject> getObjectSet(DigitalObject o1, DigitalObject o2, DigitalObject o3) {
        HashSet<DigitalObject> set = new HashSet<DigitalObject>();
        set.add(o1);
        set.add(o2);
        set.add(o3);
        return set;
    }

    public void startFlushing(int sleepMS) throws Exception {
        if (this._flusher != null) {
            try {
                this.finishFlushing();
            }
            catch (Exception e) {
                System.err.println("Error stopping old flusher!!");
                e.printStackTrace();
            }
            throw new Exception("Flusher was already running!");
        }
        this._flusher = new Flusher(this._ri, sleepMS);
        this._flusher.start();
    }

    public void finishFlushing() throws Exception {
        this._flusher.finish();
        this._ri.flushBuffer();
        this._flusher = null;
    }

    static {
        Datastream.defaultChecksumType = "DISABLED";
    }

    public class Flusher
    extends Thread {
        private final ResourceIndex _ri;
        private final int _sleepMS;
        private boolean _shouldFinish = false;
        private Exception _error;

        public Flusher(ResourceIndex ri, int sleepMS) {
            this._ri = ri;
            this._sleepMS = sleepMS;
        }

        public void finish() throws Exception {
            this._shouldFinish = true;
            while (this.isAlive()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this._error != null) {
                throw this._error;
            }
        }

        @Override
        public void run() {
            try {
                while (!this._shouldFinish) {
                    if (this._sleepMS > 0) {
                        try {
                            Thread.sleep(this._sleepMS);
                        }
                        catch (InterruptedException e) {}
                    } else {
                        Thread.yield();
                    }
                    this._ri.flushBuffer();
                }
            }
            catch (Exception e) {
                this._error = e;
            }
        }
    }
}

