/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.search;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Date;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.server.search.Condition;
import org.fcrepo.server.search.FieldSearchQuery;
import org.fcrepo.server.search.FieldSearchResult;
import org.fcrepo.server.search.FieldSearchSQLImpl;
import org.fcrepo.server.storage.ConnectionPool;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.MockRepositoryReader;
import org.fcrepo.server.storage.RepositoryReader;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.ObjectBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;

public class FieldSearchSQLImplIntegrationTest {
    private static final String driver = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String url = "jdbc:derby:test;create=true";
    private static final String username = "test";
    private static final String password = "test";
    private static final int maxActive = 4;
    private static final int maxIdle = 4;
    private static final int maxWait = -1;
    private static final int minIdle = 0;
    private static final long minEvictableIdleTimeMillis = 1800000L;
    private static final int numTestsPerEvictionRun = 3;
    private static final long timeBetweenEvictionRuns = -1L;
    private static final String validationQuery = "values(1)";
    private static final boolean testOnBorrow = true;
    private static final boolean testOnReturn = true;
    private static final boolean testWhileIdle = true;
    private static final byte whenExhaustedAction = 1;
    private static final int maxResultsDefault = 100;
    private static final int maxSecondsPerSessionDefault = 600;
    private static ConnectionPool cPool;
    private MockRepositoryReader m_repo;
    private FieldSearchSQLImpl m_impl;

    @Before
    public void setUpTest() throws Exception {
        if (cPool == null) {
            cPool = new ConnectionPool(driver, url, "test", "test", 4, 4, -1L, 0, 1800000L, 3, -1L, validationQuery, true, true, true, 1);
        }
        Connection conn = cPool.getReadWriteConnection();
        FieldSearchSQLImplIntegrationTest.executeUpdate(conn, "DROP TABLE doFields", true);
        FieldSearchSQLImplIntegrationTest.executeUpdate(conn, "DROP TABLE dcDates", true);
        FieldSearchSQLImplIntegrationTest.executeUpdate(conn, "CREATE TABLE doFields (\npid VARCHAR(64) NOT NULL,\nlabel VARCHAR(255) NOT NULL,\nstate VARCHAR(1) NOT NULL,\nownerId VARCHAR(64),\ncDate BIGINT NOT NULL,\nmDate BIGINT NOT NULL,\ndcmDate BIGINT,\ndcTitle CLOB,\ndcCreator CLOB,\ndcSubject CLOB,\ndcDescription CLOB,\ndcPublisher CLOB,\ndcContributor CLOB,\ndcDate CLOB,\ndcType CLOB,\ndcFormat CLOB,\ndcIdentifier CLOB,\ndcSource CLOB,\ndcLanguage CLOB,\ndcRelation CLOB,\ndcCoverage CLOB,\ndcRights CLOB)", false);
        FieldSearchSQLImplIntegrationTest.executeUpdate(conn, "CREATE INDEX doFields_pid ON doFields (pid)", false);
        FieldSearchSQLImplIntegrationTest.executeUpdate(conn, "CREATE TABLE dcDates (\npid VARCHAR(64) NOT NULL,dcDate BIGINT NOT NULL)", false);
        FieldSearchSQLImplIntegrationTest.executeUpdate(conn, "CREATE INDEX dcDates_pid ON dcDates (pid)", false);
        cPool.free(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeUpdate(Connection conn, String sql, boolean ignoreError) throws Exception {
        Statement st = conn.createStatement();
        try {
            st.executeUpdate(sql);
        }
        catch (Exception e) {
            if (!ignoreError) {
                throw e;
            }
        }
        finally {
            try {
                st.close();
            }
            catch (Exception e) {}
        }
    }

    @AfterClass
    public static void tearDownTest() throws Exception {
    }

    private void init(int maxResults, int maxSecondsPerSession, boolean indexDCFields) throws Exception {
        this.m_repo = new MockRepositoryReader();
        this.m_impl = new FieldSearchSQLImpl(cPool, (RepositoryReader)this.m_repo, maxResults, maxSecondsPerSession, indexDCFields);
    }

    @org.junit.Test
    public void testFindOneSeveralTimesNoDC() throws Exception {
        this.init(100, 600, true);
        String pid1 = "test:1";
        DigitalObject obj1 = ObjectBuilder.getTestObject(pid1, pid1);
        ObjectBuilder.setDates(obj1, new Date());
        this.m_repo.putObject(obj1);
        DOReader reader1 = this.m_repo.getReader(false, null, pid1);
        this.m_impl.update(reader1);
        FieldSearchQuery query = new FieldSearchQuery("*");
        int[] expected = new int[]{1, 1};
        for (int i = 0; i < 20; ++i) {
            FieldSearchSQLImplIntegrationTest.checkResults(expected, this.countResults(query, 10));
        }
    }

    @org.junit.Test
    public void testIndexAndFindByDCIdentifier() throws Exception {
        this.init(100, 600, true);
        String pid1 = "test:1";
        DigitalObject obj1 = ObjectBuilder.getTestObject(pid1, pid1);
        String dcContent = "<dc:identifier>" + pid1 + "</dc:identifier>";
        ObjectBuilder.addXDatastream(obj1, "DC", ObjectBuilder.getDC(dcContent));
        ObjectBuilder.setDates(obj1, new Date());
        this.m_repo.putObject(obj1);
        DOReader reader1 = this.m_repo.getReader(false, null, pid1);
        this.m_impl.update(reader1);
        FieldSearchQuery query = new FieldSearchQuery(Condition.getConditions((String)("identifier~" + pid1)));
        int[] expected = new int[]{1, 1};
        FieldSearchSQLImplIntegrationTest.checkResults(expected, this.countResults(query, 10));
        FieldSearchSQLImplIntegrationTest.checkResults(expected, this.countResults(query, 1));
    }

    private int[] countResults(FieldSearchQuery query, int maxResultsPerPage) throws Exception {
        int pageCount = 0;
        int resultCount = 0;
        FieldSearchResult page = this.m_impl.findObjects(new String[]{"pid"}, maxResultsPerPage, query);
        while (page != null) {
            ++pageCount;
            resultCount += page.objectFieldsList().size();
            if (page.getToken() != null) {
                this.m_impl.resumeFindObjects(page.getToken());
                continue;
            }
            page = null;
        }
        return new int[]{pageCount, resultCount};
    }

    private static void checkResults(int[] expected, int[] got) throws Exception {
        Assert.assertEquals((String)"Unexpected page count", (long)expected[0], (long)got[0]);
        Assert.assertEquals((String)"Unexpected result count", (long)expected[1], (long)got[1]);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(FieldSearchSQLImplIntegrationTest.class);
    }

    static {
        Datastream.defaultChecksumType = "DISABLED";
    }
}

