/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.search;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import org.fcrepo.mock.sql.MockConnection;
import org.fcrepo.mock.sql.MockDriver;
import org.fcrepo.mock.sql.MockPreparedStatement;
import org.fcrepo.mock.sql.MockStatement;
import org.fcrepo.server.Context;
import org.fcrepo.server.config.DatastoreConfiguration;
import org.fcrepo.server.errors.InconsistentTableSpecException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.search.FieldSearchSQLImpl;
import org.fcrepo.server.storage.ConnectionPool;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.MockDOReader;
import org.fcrepo.server.storage.MockRepositoryReader;
import org.fcrepo.server.storage.MockServiceDeploymentReader;
import org.fcrepo.server.storage.RepositoryReader;
import org.fcrepo.server.storage.ServiceDeploymentReader;
import org.fcrepo.server.storage.types.BasicDigitalObject;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.DeploymentDSBindSpec;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.utilities.SQLUtility;
import org.fcrepo.server.utilities.TableCreatingConnection;
import org.fcrepo.server.utilities.TableSpec;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFieldSearchSQLImpl {
    private static final String[] SHORT_FIELDS = FieldSearchSQLImpl.DB_COLUMN_NAMES_NODC;
    private static final String[] LONG_FIELDS = FieldSearchSQLImpl.DB_COLUMN_NAMES;
    private static final String DC_PAYLOAD_NO_DATES = "<oai_dc:dc     xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\"     xmlns:dc=\"http://purl.org/dc/elements/1.1/\">\n  <dc:title>Sandy's Reference Object</dc:title>\n  <dc:creator>Sandy Payette</dc:creator>\n  <dc:subject>FOXML Testing</dc:subject>\n  <dc:description>Object depicts all types of datastreams</dc:description>\n  <dc:publisher>Cornell CIS</dc:publisher>\n  <dc:identifier>test:100</dc:identifier>\n</oai_dc:dc>\n";
    private static final String DC_PAYLOAD_WITH_DATES = "<oai_dc:dc     xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\"     xmlns:dc=\"http://purl.org/dc/elements/1.1/\">\n  <dc:title>Sandy's Reference Object</dc:title>\n  <dc:creator>Sandy Payette</dc:creator>\n  <dc:subject>FOXML Testing</dc:subject>\n  <dc:description>Object depicts all types of datastreams</dc:description>\n  <dc:publisher>Cornell CIS</dc:publisher>\n  <dc:identifier>test:100</dc:identifier>\n  <dc:date>2006-10-15</dc:date>\n</oai_dc:dc>\n";
    private static final ObjectData OBJECT_WITH_NO_DC = new ObjectData("somePid", "myLabel", "A", "theOwner", new Date(12345L), new Date(67890L), new Date(0L), null);
    private static final ObjectData OBJECT_WITH_DC = new ObjectData("somePid", "myLabel", "A", "theOwner", new Date(12345L), new Date(67890L), new Date(10000L), "<oai_dc:dc     xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\"     xmlns:dc=\"http://purl.org/dc/elements/1.1/\">\n  <dc:title>Sandy's Reference Object</dc:title>\n  <dc:creator>Sandy Payette</dc:creator>\n  <dc:subject>FOXML Testing</dc:subject>\n  <dc:description>Object depicts all types of datastreams</dc:description>\n  <dc:publisher>Cornell CIS</dc:publisher>\n  <dc:identifier>test:100</dc:identifier>\n</oai_dc:dc>\n");
    private static final ObjectData OBJECT_WITH_DC_AND_DATES = new ObjectData("somePid", "myLabel", "A", "theOwner", new Date(12345L), new Date(67890L), new Date(10000L), "<oai_dc:dc     xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\"     xmlns:dc=\"http://purl.org/dc/elements/1.1/\">\n  <dc:title>Sandy's Reference Object</dc:title>\n  <dc:creator>Sandy Payette</dc:creator>\n  <dc:subject>FOXML Testing</dc:subject>\n  <dc:description>Object depicts all types of datastreams</dc:description>\n  <dc:publisher>Cornell CIS</dc:publisher>\n  <dc:identifier>test:100</dc:identifier>\n  <dc:date>2006-10-15</dc:date>\n</oai_dc:dc>\n");
    private static SQLUtility saveSqlUtility;
    private MockRepositoryReader mockRepositoryReader;
    private ConnectionPool connectionPool;
    private MyMockDriver mockDriver;
    private int expectedDateInserts;
    private int expectedDateDeletes;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestFieldSearchSQLImpl.class);
    }

    @BeforeClass
    public static void saveSqlUtilityImpl() {
        saveSqlUtility = TestFieldSearchSQLImpl.getSqlUtilityInstance();
    }

    @AfterClass
    public static void restoreSqlUtilityImpl() {
        TestFieldSearchSQLImpl.setSqlUtilityInstance(saveSqlUtility);
    }

    @Before
    public void registerMockDriver() {
        try {
            this.mockDriver = new MyMockDriver();
            DriverManager.registerDriver(this.mockDriver);
        }
        catch (SQLException e) {
            Assert.fail((String)("Failed to register mock JDBC driver: " + e));
        }
    }

    @After
    public void deregisterMockDriver() {
        try {
            this.mockDriver.resetLog();
            DriverManager.deregisterDriver(this.mockDriver);
        }
        catch (SQLException e) {
            Assert.fail((String)("Failed to deregister mock JDBC driver: " + e));
        }
    }

    @Before
    public void createConnectionPool() throws SQLException {
        this.connectionPool = new ConnectionPool(MockDriver.class.getName(), "mock://bogus.url", "bogusUsername", "bogusPassword", 5, 5, 5L, 0, 0L, 2, 300L, null, false, false, false, 0);
    }

    @Before
    public void clearExpectedValues() {
        this.expectedDateInserts = 0;
        this.expectedDateDeletes = 0;
    }

    @Test
    public void noDC() throws ServerException {
        TestFieldSearchSQLImpl.setSqlUtilityInstance(new UpdatingMockSqlUtility(SHORT_FIELDS, OBJECT_WITH_NO_DC.getShortFieldValueList()));
        this.mockRepositoryReader = new UnusedMockRepositoryReader();
        this.updateRecord(OBJECT_WITH_NO_DC, false);
        this.checkExpectations();
    }

    @Test
    public void dcNoDatesShortFields() throws ServerException {
        TestFieldSearchSQLImpl.setSqlUtilityInstance(new UpdatingMockSqlUtility(SHORT_FIELDS, OBJECT_WITH_DC.getShortFieldValueList()));
        this.mockRepositoryReader = new UnusedMockRepositoryReader();
        this.updateRecord(OBJECT_WITH_DC, false);
        this.checkExpectations();
    }

    @Test
    public void dcNoDatesLongFields() throws ServerException {
        TestFieldSearchSQLImpl.setSqlUtilityInstance(new UpdatingMockSqlUtility(LONG_FIELDS, OBJECT_WITH_DC.getLongFieldValueList()));
        this.expectedDateDeletes = 1;
        this.expectedDateInserts = 0;
        this.mockRepositoryReader = new UnusedMockRepositoryReader();
        this.updateRecord(OBJECT_WITH_DC, true);
        this.checkExpectations();
    }

    @Test
    public void dcDatesShortFields() throws ServerException {
        TestFieldSearchSQLImpl.setSqlUtilityInstance(new UpdatingMockSqlUtility(SHORT_FIELDS, OBJECT_WITH_DC_AND_DATES.getShortFieldValueList()));
        this.mockRepositoryReader = new UnusedMockRepositoryReader();
        this.updateRecord(OBJECT_WITH_DC_AND_DATES, false);
        this.checkExpectations();
    }

    @Test
    public void dcDatesLongFields() throws ServerException {
        TestFieldSearchSQLImpl.setSqlUtilityInstance(new UpdatingMockSqlUtility(LONG_FIELDS, OBJECT_WITH_DC_AND_DATES.getLongFieldValueList()));
        this.expectedDateDeletes = 1;
        this.expectedDateInserts = 1;
        this.mockRepositoryReader = new UnusedMockRepositoryReader();
        this.updateRecord(OBJECT_WITH_DC_AND_DATES, true);
        this.checkExpectations();
    }

    private void updateRecord(ObjectData objectData, boolean longFields) throws ServerException {
        DatastreamXMLMetadata dcmd = null;
        if (objectData.getDcPayload() != null) {
            dcmd = new DatastreamXMLMetadata();
            dcmd.DatastreamID = "DC";
            dcmd.DSCreateDT = objectData.getDcModifiedDate();
            dcmd.xmlContent = objectData.getDcPayload().getBytes();
        }
        BasicDigitalObject theObject = new BasicDigitalObject();
        theObject.setPid(objectData.getPid());
        theObject.setLabel(objectData.getLabel());
        theObject.setState(objectData.getState());
        theObject.setOwnerId(objectData.getOwnerId());
        theObject.setCreateDate(objectData.getCreateDate());
        theObject.setLastModDate(objectData.getLastModDate());
        if (dcmd != null) {
            theObject.addDatastreamVersion((Datastream)dcmd, false);
        }
        FieldSearchSQLImpl fssi = new FieldSearchSQLImpl(this.connectionPool, (RepositoryReader)this.mockRepositoryReader, 50, 50, longFields);
        fssi.update((DOReader)new MockDOReader((DigitalObject)theObject));
    }

    private void checkExpectations() {
        ((MockSqlUtility)TestFieldSearchSQLImpl.getSqlUtilityInstance()).checkExpectations();
        if (this.mockDriver instanceof MyMockDriver) {
            this.mockDriver.checkExpectations(this.expectedDateDeletes, this.expectedDateInserts);
        }
        if (this.mockRepositoryReader instanceof SDepMockRepositoryReader) {
            ((SDepMockRepositoryReader)this.mockRepositoryReader).checkExpectations();
        }
    }

    private void assertEqualArrays(String label, Object[] expected, Object[] actual) {
        if (!Arrays.equals(expected, actual)) {
            Assert.fail((String)(label + ", expected: " + Arrays.deepToString(expected) + ", actual: " + Arrays.deepToString(actual)));
        }
    }

    private void assertEqualValues(String[] columns, Object[] expected, Object[] actual) {
        if (Arrays.equals(expected, actual)) {
            return;
        }
        String noValue = "_NO_VALUE_";
        String message = "";
        ArrayList<String> badColumns = new ArrayList<String>();
        for (int i = 0; i < columns.length; ++i) {
            String expectedString;
            String actualValue;
            String expectedValue = i < expected.length ? expected[i] : noValue;
            String string = actualValue = i < actual.length ? actual[i] : noValue;
            if (!this.equivalent(expectedValue, actualValue)) {
                badColumns.add(columns[i]);
            }
            String string2 = expectedValue == noValue ? noValue : (expectedString = expectedValue == null ? "null" : expected[i].getClass().getName() + "[" + expected[i] + "]");
            String actualString = actualValue == noValue ? noValue : (actualValue == null ? "null" : actual[i].getClass().getName() + "[" + actual[i] + "]");
            message = message + String.format("column '%s', expected=%s, actual=%s\n", columns[i], expectedString, actualString);
        }
        if (!badColumns.isEmpty()) {
            message = "bad columns: " + badColumns + "\n" + message;
        }
        Assert.fail((String)message);
    }

    private boolean equivalent(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static SQLUtility getSqlUtilityInstance() {
        try {
            Field instanceField = SQLUtility.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            return (SQLUtility)instanceField.get(null);
        }
        catch (SecurityException e) {
            Assert.fail((String)("Failed to set SqlUtility instance: " + e));
        }
        catch (NoSuchFieldException e) {
            Assert.fail((String)("Failed to set SqlUtility instance: " + e));
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)("Failed to set SqlUtility instance: " + e));
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)("Failed to set SqlUtility instance: " + e));
        }
        return null;
    }

    private static void setSqlUtilityInstance(SQLUtility instance) {
        try {
            Field instanceField = SQLUtility.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            instanceField.set(null, instance);
        }
        catch (SecurityException e) {
            Assert.fail((String)("Failed to set SqlUtility instance: " + e));
        }
        catch (NoSuchFieldException e) {
            Assert.fail((String)("Failed to set SqlUtility instance: " + e));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to set SqlUtility instance: " + e));
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)("Failed to set SqlUtility instance: " + e));
        }
    }

    private static class ObjectData {
        private final String pid;
        private final String label;
        private final String state;
        private final String ownerId;
        private final Date createDate;
        private final Date lastModDate;
        private final Date dcModifiedDate;
        private final String dcPayload;

        public ObjectData(String pid, String label, String state, String ownerId, Date createDate, Date lastModDate, Date dcModifiedDate, String dcPayload) {
            this.pid = pid;
            this.label = label;
            this.state = state;
            this.ownerId = ownerId;
            this.createDate = createDate;
            this.lastModDate = lastModDate;
            this.dcModifiedDate = dcModifiedDate;
            this.dcPayload = dcPayload;
        }

        public List<String> getShortFieldValueList() {
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.pid);
            result.add(this.lowerCase(this.label));
            result.add(this.lowerCase(this.state));
            result.add(this.lowerCase(this.ownerId));
            result.add(this.dateStamp(this.createDate));
            result.add(this.dateStamp(this.lastModDate));
            result.add(this.dateStamp(this.dcModifiedDate));
            return result;
        }

        public List<String> getLongFieldValueList() {
            ArrayList<String> result = new ArrayList<String>();
            result.addAll(this.getShortFieldValueList());
            result.add(this.lowerCase(this.getDcFields("dc:title")));
            result.add(this.lowerCase(this.getDcFields("dc:creator")));
            result.add(this.lowerCase(this.getDcFields("dc:subject")));
            result.add(this.lowerCase(this.getDcFields("dc:description")));
            result.add(this.lowerCase(this.getDcFields("dc:publisher")));
            result.add(this.lowerCase(this.getDcFields("dc:contributor")));
            result.add(this.lowerCase(this.getDcFields("dc:date")));
            result.add(this.lowerCase(this.getDcFields("dc:type")));
            result.add(this.lowerCase(this.getDcFields("dc:format")));
            result.add(this.lowerCase(this.getDcFields("dc:identifier")));
            result.add(this.lowerCase(this.getDcFields("dc:source")));
            result.add(this.lowerCase(this.getDcFields("dc:language")));
            result.add(this.lowerCase(this.getDcFields("dc:relation")));
            result.add(this.lowerCase(this.getDcFields("dc:coverage")));
            result.add(this.lowerCase(this.getDcFields("dc:rights")));
            return result;
        }

        public String getPid() {
            return this.pid;
        }

        public String getLabel() {
            return this.label;
        }

        public String getState() {
            return this.state;
        }

        public String getOwnerId() {
            return this.ownerId;
        }

        public Date getCreateDate() {
            return this.createDate;
        }

        public Date getLastModDate() {
            return this.lastModDate;
        }

        public Date getDcModifiedDate() {
            return this.dcModifiedDate;
        }

        public String getDcPayload() {
            return this.dcPayload;
        }

        private String lowerCase(String raw) {
            return raw == null ? null : raw.toLowerCase();
        }

        private String dateStamp(Date date) {
            return date == null ? null : String.valueOf(date.getTime());
        }

        private String getDcFields(String fieldName) {
            String pString = String.format("<%1$s>\\s*([^<]*)\\s*</%1$s>", fieldName);
            Pattern p = Pattern.compile(pString);
            Matcher m = p.matcher(this.dcPayload);
            ArrayList<String> values = new ArrayList<String>();
            int start = 0;
            while (m.find(start)) {
                values.add(m.group(1));
                start = m.end();
            }
            return this.joinStrings(values);
        }

        private String joinStrings(Collection<String> strings) {
            if (strings == null || strings.isEmpty()) {
                return null;
            }
            StringBuffer result = new StringBuffer();
            for (String string : strings) {
                result.append(" ").append(string).append(" .");
            }
            return result.toString();
        }
    }

    private class MyMockDriver
    extends MockDriver {
        private int deleteCalls = 0;
        private int insertCalls = 0;

        private MyMockDriver() {
        }

        public void logInsert() {
            ++this.insertCalls;
        }

        public void logDelete() {
            ++this.deleteCalls;
        }

        public void resetLog() {
            this.deleteCalls = 0;
            this.insertCalls = 0;
        }

        @Override
        public Connection connect(String url, Properties info) throws SQLException {
            return new UpdatingMockConnection(this);
        }

        public void checkExpectations(int expectedDeletes, int expectedInserts) {
            Assert.assertEquals((String)"delete calls", (int)expectedDeletes, (int)this.deleteCalls);
            Assert.assertEquals((String)"insert calls", (int)expectedInserts, (int)this.insertCalls);
        }
    }

    private static class SDepMockRepositoryReader
    extends MockRepositoryReader {
        private int calls;

        public void checkExpectations() {
            Assert.assertEquals((String)"sDep reader calls", (int)1, (int)this.calls);
        }

        @Override
        public synchronized ServiceDeploymentReader getServiceDeploymentReader(boolean cachedObjectRequired, Context context, String pid) throws ServerException {
            ++this.calls;
            return new MockServiceDeploymentReader(null){

                @Override
                public DeploymentDSBindSpec getServiceDSInputSpec(Date versDateTime) throws ServerException {
                    DeploymentDSBindSpec spec = new DeploymentDSBindSpec();
                    return spec;
                }
            };
        }
    }

    private static class UnusedMockRepositoryReader
    extends MockRepositoryReader {
        private UnusedMockRepositoryReader() {
        }

        @Override
        public synchronized ServiceDeploymentReader getServiceDeploymentReader(boolean cachedObjectRequired, Context context, String pid) throws ServerException {
            Assert.fail((String)"Unexpected call to UnusedMockRepositoryReader.getServiceDeploymentReader");
            return null;
        }
    }

    private static class UpdatingMockConnection
    extends MockConnection {
        private MyMockDriver driver;

        UpdatingMockConnection(MyMockDriver driver) {
            this.driver = driver;
        }

        @Override
        public Statement createStatement() throws SQLException {
            return new MockStatement(){

                @Override
                public int executeUpdate(String sql) throws SQLException {
                    if (sql.trim().toLowerCase().startsWith("insert")) {
                        UpdatingMockConnection.this.driver.logInsert();
                    }
                    if (sql.trim().toLowerCase().startsWith("delete")) {
                        UpdatingMockConnection.this.driver.logDelete();
                    }
                    return 1;
                }
            };
        }

        @Override
        public PreparedStatement prepareStatement(final String sql) throws SQLException {
            return new MockPreparedStatement(sql){

                @Override
                public int executeUpdate() throws SQLException {
                    if (sql.trim().toLowerCase().startsWith("insert")) {
                        UpdatingMockConnection.this.driver.logInsert();
                    }
                    if (sql.trim().toLowerCase().startsWith("delete")) {
                        UpdatingMockConnection.this.driver.logDelete();
                    }
                    return 1;
                }
            };
        }
    }

    private class UpdatingMockSqlUtility
    extends MockSqlUtility {
        private final String[] expectedColumns;
        private final String[] expectedValues;
        private String[] actualColumns;
        private String[] actualValues;

        public UpdatingMockSqlUtility(String[] expectedColumns, List<String> expectedValues) {
            this.expectedColumns = expectedColumns;
            this.expectedValues = expectedValues.toArray(new String[expectedValues.size()]);
        }

        @Override
        protected void i_replaceInto(Connection conn, String table, String[] columns, String[] values, String uniqueColumn, boolean[] numeric) throws SQLException {
            this.actualColumns = columns;
            this.actualValues = values;
        }

        @Override
        public void checkExpectations() {
            TestFieldSearchSQLImpl.this.assertEqualArrays("column names", this.expectedColumns, this.actualColumns);
            TestFieldSearchSQLImpl.this.assertEqualValues(this.expectedColumns, this.expectedValues, this.actualValues);
        }
    }

    public static class UnusedMockSqlUtility
    extends MockSqlUtility {
        @Override
        public void checkExpectations() {
        }
    }

    public static abstract class MockSqlUtility
    extends SQLUtility {
        public abstract void checkExpectations();

        protected void i_addRow(Connection conn, String table, String[] columns, String[] values, boolean[] numeric) throws SQLException {
            Assert.fail((String)"Unexpected call to MockSqlUtility.i_addRow");
        }

        protected void i_createNonExistingTables(ConnectionPool pool, InputStream dbSpec) throws IOException, InconsistentTableSpecException, SQLException {
            Assert.fail((String)"Unexpected call to MockSqlUtility.i_createNonExistingTables");
        }

        protected void i_createTables(TableCreatingConnection tcConn, List<TableSpec> specs) throws SQLException {
            Assert.fail((String)"Unexpected call to MockSqlUtility.i_addRow");
        }

        protected ConnectionPool i_getConnectionPool(DatastoreConfiguration cpDC) throws SQLException {
            Assert.fail((String)"Unexpected call to MockSqlUtility.i_addRow");
            return null;
        }

        protected String i_getLongString(ResultSet rs, int pos) throws SQLException {
            Assert.fail((String)"Unexpected call to MockSqlUtility.i_addRow");
            return null;
        }

        protected List<TableSpec> i_getNonExistingTables(Connection conn, List<TableSpec> specs) throws SQLException {
            Assert.fail((String)"Unexpected call to MockSqlUtility.i_addRow");
            return null;
        }

        protected void i_replaceInto(Connection conn, String table, String[] columns, String[] values, String uniqueColumn, boolean[] numeric) throws SQLException {
            Assert.fail((String)"Unexpected call to MockSqlUtility.i_addRow");
        }

        protected boolean i_updateRow(Connection conn, String table, String[] columns, String[] values, String uniqueColumn, boolean[] numeric) throws SQLException {
            Assert.fail((String)"Unexpected call to MockSqlUtility.i_addRow");
            return false;
        }

        protected long i_getMostRecentRebuild(Connection conn) throws SQLException {
            Assert.fail((String)"Unexpected call to MockSqlUtility.i_getMostRecentRebuild");
            return 0L;
        }

        protected boolean i_getRebuildStatus(Connection conn, long rebuildDate) throws SQLException {
            Assert.fail((String)"Unexpected call to MockSqlUtility.i_getRebuildStatus");
            return false;
        }

        protected void i_recordSuccessfulRebuild(Connection conn, long rebuildDate) throws SQLException {
            Assert.fail((String)"Unexpected call to MockSqlUtility.i_recordSuccessfulRebuild");
        }
    }
}

