/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.fcrepo.common.PID;
import org.fcrepo.server.Context;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ObjectExistsException;
import org.fcrepo.server.errors.ObjectLockedException;
import org.fcrepo.server.management.BasicPIDGenerator;
import org.fcrepo.server.management.ManagementModule;
import org.fcrepo.server.resourceIndex.ResourceIndexModule;
import org.fcrepo.server.search.FieldSearch;
import org.fcrepo.server.storage.ConnectionPool;
import org.fcrepo.server.storage.ConnectionPoolManagerImpl;
import org.fcrepo.server.storage.DOWriter;
import org.fcrepo.server.storage.DefaultDOManager;
import org.fcrepo.server.storage.DefaultExternalContentManager;
import org.fcrepo.server.storage.FedoraStorageHintProvider;
import org.fcrepo.server.storage.NullStorageHintsProvider;
import org.fcrepo.server.storage.lowlevel.DefaultLowlevelStorageModule;
import org.fcrepo.server.storage.translation.DOTranslatorModule;
import org.fcrepo.server.storage.types.XMLDatastreamProcessor;
import org.fcrepo.server.utilities.SQLUtility;
import org.fcrepo.server.validation.DOObjectValidatorModule;
import org.fcrepo.server.validation.DOValidatorModule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "org.apache.xerces.*", "javax.xml.*", "org.xml.sax.*", "javax.management.*"})
@PrepareForTest(value={Server.class})
public class DefaultDOManagerTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDOManagerTest.class);
    private final String FORMAT = "info:fedora/fedora-system:FOXML-1.1";
    private final String ENCODING = "UTF-8";
    private static final String DUMMY_PID = "obj:1";
    private static final PID DUMMY_PID_OBJECT = PID.getInstance((String)"obj:1");
    private static final FedoraStorageHintProvider DUMMY_HINTS = new NullStorageHintsProvider();
    @Mock
    private Server mockServer;
    @Mock
    private Context mockContext;
    @Mock
    private ManagementModule mockManagement;
    @Mock
    private DefaultExternalContentManager mockExternalContent;
    @Mock
    private BasicPIDGenerator mockPidGenerator;
    @Mock
    private DOTranslatorModule mockTranslatorModule;
    @Mock
    private DOValidatorModule mockValidatorModule;
    @Mock
    private DOObjectValidatorModule mockObjectValidatorModule;
    @Mock
    private ResourceIndexModule mockResourceIndexModule;
    @Mock
    private ConnectionPoolManagerImpl mockConnectionPoolManager;
    @Mock
    private ConnectionPool mockPool;
    @Mock
    private Connection mockROConnection;
    @Mock
    private DefaultLowlevelStorageModule mockLowLevelStorage;
    @Mock
    private SQLUtility mockSqlUtility;
    @Mock
    private ResultSet pidExists;
    @Mock
    private FieldSearch mockFieldSearch;
    private DefaultDOManager testObj;

    private static void setStaticMember(Class<?> clazz, String name, Object instance) {
        try {
            Field instanceField = clazz.getDeclaredField(name);
            instanceField.setAccessible(true);
            instanceField.set(null, instance);
        }
        catch (SecurityException e) {
            junit.framework.Assert.fail((String)("Failed to set static member: " + e));
        }
        catch (NoSuchFieldException e) {
            junit.framework.Assert.fail((String)("Failed to set static member: " + e));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            junit.framework.Assert.fail((String)("Failed to set static member: " + e));
        }
        catch (IllegalAccessException e) {
            junit.framework.Assert.fail((String)("Failed to set static member: " + e));
        }
    }

    @Before
    public void setUp() throws Exception {
        DefaultDOManagerTest.setStaticMember(XMLDatastreamProcessor.class, "initialized", true);
        DefaultDOManagerTest.setStaticMember(XMLDatastreamProcessor.class, "DC_DEFAULT_CONTROLGROUP", "X");
        DefaultDOManagerTest.setStaticMember(XMLDatastreamProcessor.class, "RELS_DEFAULT_CONTROLGROUP", "X");
        PowerMockito.mockStatic(Server.class, (Class[])new Class[0]);
        Mockito.when((Object)Server.getPID((String)((String)Matchers.any(String.class)))).thenReturn((Object)DUMMY_PID_OBJECT);
        this.testObj = this.getInstance();
    }

    DefaultDOManager getInstance() throws Exception {
        HashMap<String, String> dummyParams = new HashMap<String, String>();
        dummyParams.put("pidNamespace", "changeme");
        dummyParams.put("defaultExportFormat", "info:fedora/fedora-system:FOXML-1.1");
        DefaultDOManager instance = new DefaultDOManager(dummyParams, this.mockServer, "DOManager");
        instance.initModule();
        Mockito.when((Object)this.mockServer.getModule("org.fcrepo.server.management.Management")).thenReturn((Object)this.mockManagement);
        Mockito.when((Object)this.mockServer.getModule("org.fcrepo.server.storage.ExternalContentManager")).thenReturn((Object)this.mockExternalContent);
        Mockito.when((Object)this.mockServer.getModule("org.fcrepo.server.management.PIDGenerator")).thenReturn((Object)this.mockPidGenerator);
        Mockito.when((Object)this.mockServer.getModule("org.fcrepo.server.storage.translation.DOTranslator")).thenReturn((Object)this.mockTranslatorModule);
        Mockito.when((Object)this.mockServer.getModule("org.fcrepo.server.validation.DOValidator")).thenReturn((Object)this.mockValidatorModule);
        Mockito.when((Object)this.mockServer.getModule("org.fcrepo.server.validation.DOObjectValidator")).thenReturn((Object)this.mockObjectValidatorModule);
        Mockito.when((Object)this.mockServer.getModule("org.fcrepo.server.resourceIndex.ResourceIndex")).thenReturn((Object)this.mockResourceIndexModule);
        Mockito.when((Object)this.mockServer.getModule("org.fcrepo.server.storage.ConnectionPoolManager")).thenReturn((Object)this.mockConnectionPoolManager);
        Mockito.when((Object)this.mockServer.getModule("org.fcrepo.server.storage.lowlevel.ILowlevelStorage")).thenReturn((Object)this.mockLowLevelStorage);
        Mockito.when((Object)this.mockServer.getBean("org.fcrepo.server.search.FieldSearch", FieldSearch.class)).thenReturn((Object)this.mockFieldSearch);
        Mockito.when((Object)this.mockServer.getBean("fedoraStorageHintProvider")).thenReturn((Object)DUMMY_HINTS);
        Mockito.when((Object)this.mockConnectionPoolManager.getPool()).thenReturn((Object)this.mockPool);
        Mockito.when((Object)this.mockConnectionPoolManager.getPool(Matchers.anyString())).thenReturn((Object)this.mockPool);
        Mockito.when((Object)this.mockPool.getReadOnlyConnection()).thenReturn((Object)this.mockROConnection);
        DefaultDOManagerTest.setStaticMember(SQLUtility.class, "instance", this.mockSqlUtility);
        Mockito.when((Object)this.mockServer.getModule("org.fcrepo.server.storage.DOManager")).thenReturn((Object)instance);
        PreparedStatement mockStmt = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        ResultSet mockResult = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)mockStmt.executeQuery()).thenReturn((Object)mockResult);
        Mockito.when((Object)this.mockROConnection.prepareStatement((String)Matchers.eq((Object)DefaultDOManager.CMODEL_QUERY), Matchers.eq((int)1003), Matchers.eq((int)1007))).thenReturn((Object)mockStmt);
        PreparedStatement mockExistsStmt = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)mockExistsStmt.executeQuery()).thenReturn((Object)this.pidExists);
        Mockito.when((Object)this.mockROConnection.prepareStatement((String)Matchers.eq((Object)DefaultDOManager.REGISTERED_PID_QUERY))).thenReturn((Object)mockExistsStmt);
        instance.postInitModule();
        return instance;
    }

    @Test
    public void testGetIngestWriterSucceeds() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream("".getBytes("UTF-8"));
        Mockito.when((Object)this.pidExists.next()).thenReturn((Object)false).thenReturn((Object)true);
        Connection mockRWConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.mockPool.getReadWriteConnection()).thenReturn((Object)mockRWConnection);
        PreparedStatement mockInsert = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)mockRWConnection.prepareStatement((String)Matchers.eq((Object)DefaultDOManager.INSERT_PID_QUERY))).thenReturn((Object)mockInsert);
        this.testObj.getIngestWriter(false, this.mockContext, (InputStream)in, "info:fedora/fedora-system:FOXML-1.1", "UTF-8", DUMMY_PID);
        ((PreparedStatement)Mockito.verify((Object)mockInsert)).executeUpdate();
    }

    @Test(expected=ObjectExistsException.class)
    public void testGetIngestWriterThrowsIfPidAlreadyRegistered() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream("".getBytes("UTF-8"));
        Mockito.when((Object)this.pidExists.next()).thenReturn((Object)true);
        this.testObj.getIngestWriter(false, this.mockContext, (InputStream)in, "info:fedora/fedora-system:FOXML-1.1", "UTF-8", DUMMY_PID);
    }

    @Test(expected=ObjectExistsException.class)
    public void testGetIngestWriterThrowsIfObjectAlreadyExists() throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream("".getBytes("UTF-8"));
        Mockito.when((Object)this.pidExists.next()).thenReturn((Object)false);
        Mockito.when((Object)this.mockLowLevelStorage.objectExists(DUMMY_PID)).thenReturn((Object)true);
        this.testObj.getIngestWriter(false, this.mockContext, (InputStream)in, "info:fedora/fedora-system:FOXML-1.1", "UTF-8", DUMMY_PID);
    }

    @Test
    public void testMultithreadedThreadSwitchesBetweenCheckAndRegisterObject() throws Throwable {
        final AtomicBoolean registered = new AtomicBoolean(false);
        final CountDownLatch latch = new CountDownLatch(1);
        Mockito.when((Object)this.pidExists.next()).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                boolean result = registered.get();
                LOGGER.debug("pidExists returning {}, waiting...", (Object)result);
                return result;
            }
        });
        Connection mockRWConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.mockPool.getReadWriteConnection()).thenReturn((Object)mockRWConnection);
        final PreparedStatement mockInsert = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)mockRWConnection.prepareStatement((String)Matchers.eq((Object)DefaultDOManager.INSERT_PID_QUERY))).thenAnswer((Answer)new Answer<PreparedStatement>(){

            public PreparedStatement answer(InvocationOnMock invocation) throws Throwable {
                latch.await();
                if (registered.getAndSet(true)) {
                    throw new SQLException("object already exists!");
                }
                return mockInsert;
            }
        });
        PreparedStatement mockVersionQuery = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)mockRWConnection.prepareStatement(DefaultDOManager.PID_VERSION_QUERY)).thenReturn((Object)mockVersionQuery);
        ResultSet versionResults = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)versionResults.next()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)mockVersionQuery.executeQuery()).thenReturn((Object)versionResults);
        PreparedStatement mockVersionUpdate = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)mockRWConnection.prepareStatement(DefaultDOManager.PID_VERSION_UPDATE)).thenReturn((Object)mockVersionUpdate);
        ThreadSwitchRunnable t1 = new ThreadSwitchRunnable(this.testObj);
        ThreadSwitchRunnable t2 = new ThreadSwitchRunnable(this.testObj);
        Thread t1t = new Thread(t1);
        Thread t2t = new Thread(t2);
        t1t.start();
        t2t.start();
        latch.countDown();
        t1t.join();
        t2t.join();
        int successes = t1.successes.get() + t2.successes.get();
        int expectedFailures = t1.expectedFailures.get() + t2.expectedFailures.get();
        int unexpectedFailures = t1.unexpectedFailures.get() + t2.unexpectedFailures.get();
        Assert.assertEquals((long)1L, (long)successes);
        Assert.assertEquals((long)1L, (long)expectedFailures);
        Assert.assertEquals((long)0L, (long)unexpectedFailures);
        Assert.assertTrue((boolean)(t1.successes.get() == 1 ^ t1.expectedFailures.get() == 1));
        Assert.assertTrue((boolean)(t2.successes.get() == 1 ^ t2.expectedFailures.get() == 1));
    }

    class ThreadSwitchRunnable
    implements Runnable {
        DefaultDOManager manager;
        AtomicInteger successes = new AtomicInteger();
        AtomicInteger expectedFailures = new AtomicInteger();
        AtomicInteger unexpectedFailures = new AtomicInteger();

        ThreadSwitchRunnable(DefaultDOManager manager) {
            this.manager = manager;
        }

        @Override
        public void run() {
            ByteArrayInputStream in = null;
            try {
                in = new ByteArrayInputStream("".getBytes("UTF-8"));
                DOWriter ingestWriter = this.manager.getIngestWriter(false, DefaultDOManagerTest.this.mockContext, (InputStream)in, "info:fedora/fedora-system:FOXML-1.1", "UTF-8", DefaultDOManagerTest.DUMMY_PID);
                ingestWriter.commit("");
                this.manager.releaseWriter(ingestWriter);
                this.successes.incrementAndGet();
                LOGGER.info("{} - thread task completed", (Object)Thread.currentThread().getName());
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            catch (ObjectLockedException ole) {
                LOGGER.info("{} - thread caught expected exception: {}", (Object)Thread.currentThread().getName(), (Object)ole);
                this.expectedFailures.incrementAndGet();
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ioe) {
                    ole.printStackTrace();
                }
            }
            catch (ObjectExistsException oee) {
                LOGGER.info("{} - thread caught expected exception: {}", (Object)Thread.currentThread().getName(), (Object)oee);
                this.expectedFailures.incrementAndGet();
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ioe) {
                    oee.printStackTrace();
                }
            }
            catch (Exception ex) {
                LOGGER.error(Thread.currentThread().getName() + " - Exception", (Throwable)ex);
                this.unexpectedFailures.incrementAndGet();
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ioe) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

