/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.storage.translation.DODeserializer;
import org.fcrepo.server.storage.types.DigitalObject;

public class MockDODeserializer
implements DODeserializer {
    private final String m_format;

    public MockDODeserializer() {
        this.m_format = new String();
    }

    public MockDODeserializer(String format) {
        this.m_format = format;
    }

    public DODeserializer getInstance() {
        return new MockDODeserializer(this.m_format);
    }

    public void deserialize(InputStream in, DigitalObject obj, String encoding, int transContext) throws ObjectIntegrityException, StreamIOException, UnsupportedEncodingException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, encoding));
        try {
            obj.setLabel(reader.readLine());
            obj.setPid(reader.readLine());
        }
        catch (IOException e) {
            throw new StreamIOException("Error reading stream", (Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new StreamIOException("Error closing reader", (Throwable)e);
            }
        }
    }
}

