/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.util.Iterator;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.server.storage.translation.DODeserializer;
import org.fcrepo.server.storage.translation.DOSerializer;
import org.fcrepo.server.storage.translation.FOXML1_0DODeserializer;
import org.fcrepo.server.storage.translation.FOXML1_0DOSerializer;
import org.fcrepo.server.storage.translation.TestFOXMLDODeserializer;
import org.fcrepo.server.storage.types.BasicDigitalObject;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DigitalObject;

public class TestFOXML1_0DODeserializer
extends TestFOXMLDODeserializer {
    public TestFOXML1_0DODeserializer() {
        super((DODeserializer)new FOXML1_0DODeserializer(), (DOSerializer)new FOXML1_0DOSerializer());
    }

    @org.junit.Test
    public void testTwoDisseminators() {
        this.doTestTwoDisseminators();
    }

    @org.junit.Test
    public void testDeserializeWithAutoChecksum() throws Exception {
        Datastream.defaultChecksumType = "MD5";
        Datastream.autoChecksum = true;
        BasicDigitalObject obj = new BasicDigitalObject();
        obj.setNew(true);
        this.m_deserializer.deserialize(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("ecm/dataobject1.xml"), (DigitalObject)obj, "UTF-8", 0);
        Iterator streams = obj.datastreamIdIterator();
        while (streams.hasNext()) {
            String id = (String)streams.next();
            for (Datastream version : obj.datastreams(id)) {
                TestFOXML1_0DODeserializer.assertEquals((String)Datastream.getDefaultChecksumType(), (String)version.DSChecksumType);
                TestFOXML1_0DODeserializer.assertEquals((int)32, (int)version.getChecksum().length());
            }
        }
    }

    @org.junit.Test
    public void testDeserializeWithoutAutoChecksum() throws Exception {
        Datastream.defaultChecksumType = "DISABLED";
        Datastream.autoChecksum = false;
        BasicDigitalObject obj = new BasicDigitalObject();
        obj.setNew(true);
        this.m_deserializer.deserialize(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("ecm/dataobject1.xml"), (DigitalObject)obj, "UTF-8", 0);
        Iterator streams = obj.datastreamIdIterator();
        while (streams.hasNext()) {
            String id = (String)streams.next();
            for (Datastream version : obj.datastreams(id)) {
                TestFOXML1_0DODeserializer.assertEquals((String)version.DatastreamID, (String)"DISABLED", (String)version.DSChecksumType);
                TestFOXML1_0DODeserializer.assertEquals((String)version.DatastreamID, (String)"none", (String)version.DSChecksum);
            }
        }
    }

    public static Test suite() {
        return new JUnit4TestAdapter(TestFOXML1_0DODeserializer.class);
    }
}

