/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.util.Iterator;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.common.Models;
import org.fcrepo.server.storage.translation.DODeserializer;
import org.fcrepo.server.storage.translation.DOSerializer;
import org.fcrepo.server.storage.translation.FOXML1_1DODeserializer;
import org.fcrepo.server.storage.translation.FOXML1_1DOSerializer;
import org.fcrepo.server.storage.translation.TestFOXMLDODeserializer;
import org.fcrepo.server.storage.types.BasicDigitalObject;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DigitalObject;
import org.jrdf.graph.URIReference;

public class TestFOXML1_1DODeserializer
extends TestFOXMLDODeserializer {
    public TestFOXML1_1DODeserializer() {
        super((DODeserializer)new FOXML1_1DODeserializer(), (DOSerializer)new FOXML1_1DOSerializer());
    }

    @org.junit.Test
    public void testDeserializeSimpleCModelObject() {
        this.doSimpleTest(new URIReference[]{Models.CONTENT_MODEL_3_0});
    }

    @org.junit.Test
    public void testDeserializeWithAutoChecksum() throws Exception {
        Datastream.defaultChecksumType = "MD5";
        Datastream.autoChecksum = true;
        BasicDigitalObject obj = new BasicDigitalObject();
        obj.setNew(true);
        this.m_deserializer.deserialize(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("ecm/dataobject1.xml"), (DigitalObject)obj, "UTF-8", 0);
        Iterator streams = obj.datastreamIdIterator();
        while (streams.hasNext()) {
            String id = (String)streams.next();
            for (Datastream version : obj.datastreams(id)) {
                TestFOXML1_1DODeserializer.assertEquals((String)Datastream.getDefaultChecksumType(), (String)version.DSChecksumType);
                TestFOXML1_1DODeserializer.assertEquals((int)32, (int)version.getChecksum().length());
            }
        }
    }

    @org.junit.Test
    public void testDeserializeWithoutAutoChecksum() throws Exception {
        Datastream.defaultChecksumType = "DISABLED";
        Datastream.autoChecksum = false;
        BasicDigitalObject obj = new BasicDigitalObject();
        obj.setNew(true);
        this.m_deserializer.deserialize(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("ecm/dataobject1.xml"), (DigitalObject)obj, "UTF-8", 0);
        Iterator streams = obj.datastreamIdIterator();
        while (streams.hasNext()) {
            String id = (String)streams.next();
            for (Datastream version : obj.datastreams(id)) {
                TestFOXML1_1DODeserializer.assertEquals((String)version.DatastreamID, (String)"DISABLED", (String)version.DSChecksumType);
                TestFOXML1_1DODeserializer.assertEquals((String)version.DatastreamID, (String)"none", (String)version.DSChecksum);
            }
        }
    }

    public static Test suite() {
        return new JUnit4TestAdapter(TestFOXML1_1DODeserializer.class);
    }
}

