/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.TransformerException;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.common.rdf.RDFName;
import org.fcrepo.server.storage.RDFRelationshipReader;
import org.fcrepo.server.storage.translation.DOSerializer;
import org.fcrepo.server.storage.translation.TestXMLDOSerializer;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.jrdf.graph.Literal;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.URIReference;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class TestFOXMLDOSerializer
extends TestXMLDOSerializer {
    protected static final String ROOT_PATH = "/" + Constants.FOXML.DIGITAL_OBJECT.qName;
    protected static final String PROPERTIES_PATH = ROOT_PATH + "/" + Constants.FOXML.OBJECT_PROPERTIES.qName;
    protected static final String PROPERTY_PATH = PROPERTIES_PATH + "/" + Constants.FOXML.PROPERTY.qName;
    protected static final String DATASTREAM_PATH = ROOT_PATH + "/" + Constants.FOXML.DATASTREAM.qName;

    TestFOXMLDOSerializer(DOSerializer serializer) {
        super(serializer);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put(Constants.FOXML.prefix, Constants.FOXML.uri);
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
    }

    @After
    public void tearDown() {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
    }

    @Test
    public void testPIDAttribute() throws TransformerException, XpathException {
        DigitalObject obj = TestFOXMLDOSerializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        Document xml = this.doSerializeOrFail(obj);
        this.assertXpathExists(ROOT_PATH + "[@PID='" + "test:pid" + "']", xml);
    }

    @Test
    public void testCommonFedoraObjectTypes() throws TransformerException {
        DigitalObject obj = TestFOXMLDOSerializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        Document xml = this.doSerializeOrFail(obj);
        this.checkRelationships(xml, (PredicateNode)Constants.MODEL.HAS_MODEL, new ObjectNode[]{Models.FEDORA_OBJECT_3_0});
        obj = TestFOXMLDOSerializer.createTestObject(new URIReference[]{Models.CONTENT_MODEL_3_0});
        xml = this.doSerializeOrFail(obj);
        this.checkRelationships(xml, (PredicateNode)Constants.MODEL.HAS_MODEL, new ObjectNode[]{Models.CONTENT_MODEL_3_0});
        obj = TestFOXMLDOSerializer.createTestObject(new URIReference[]{Models.SERVICE_DEFINITION_3_0});
        xml = this.doSerializeOrFail(obj);
        this.checkRelationships(xml, (PredicateNode)Constants.MODEL.HAS_MODEL, new ObjectNode[]{Models.SERVICE_DEFINITION_3_0});
        obj = TestFOXMLDOSerializer.createTestObject(new URIReference[]{Models.SERVICE_DEPLOYMENT_3_0});
        xml = this.doSerializeOrFail(obj);
        this.checkRelationships(xml, (PredicateNode)Constants.MODEL.HAS_MODEL, new ObjectNode[]{Models.SERVICE_DEPLOYMENT_3_0});
    }

    @Test
    public void testTwoInlineDatastreams() throws TransformerException, XpathException {
        DigitalObject obj = TestFOXMLDOSerializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        String dsID1 = "DS1";
        DatastreamXMLMetadata ds1 = TestFOXMLDOSerializer.createXDatastream("DS1");
        String dsID2 = "DS2";
        DatastreamXMLMetadata ds2 = TestFOXMLDOSerializer.createXDatastream("DS2");
        obj.addDatastreamVersion((Datastream)ds1, true);
        obj.addDatastreamVersion((Datastream)ds2, true);
        Document xml = this.doSerializeOrFail(obj);
        this.assertXpathEvaluatesTo("3", "count(" + DATASTREAM_PATH + ")", xml);
    }

    protected void checkProperty(Document xml, RDFName name, String value) throws TransformerException, XpathException {
        this.assertXpathExists(PROPERTY_PATH + "[@NAME='" + name.uri + "'" + " and @VALUE='" + value + "']", xml);
    }

    protected void checkRelationships(Document xml, PredicateNode pred, ObjectNode ... nodes) {
        NodeList streams = xml.getElementsByTagNameNS(Constants.FOXML.DATASTREAM.namespace.uri, Constants.FOXML.DATASTREAM_VERSION.localName);
        if (streams.getLength() == 0) {
            TestFOXMLDOSerializer.fail((String)("No relationships found.  Serializer " + this.m_serializer.getClass().getName()));
        }
        Element lastDS = null;
        String maxId = "";
        for (int i = 0; i < streams.getLength(); ++i) {
            Element ds = (Element)streams.item(i);
            String id = ds.getAttribute("ID");
            if (!id.startsWith("RELS-EXT") || id.compareTo(maxId) <= 0) continue;
            maxId = id;
            lastDS = ds;
        }
        NodeList rdf = lastDS.getElementsByTagNameNS(Constants.RDF.uri, "RDF");
        if (rdf.getLength() != 1) {
            TestFOXMLDOSerializer.fail((String)"Could not locate valid RDF");
        }
        Element rdfRels = (Element)rdf.item(0);
        Set rels = new HashSet();
        try {
            StringWriter sout = new StringWriter();
            OutputFormat formatter = new OutputFormat();
            formatter.setEncoding("UTF-8");
            XMLSerializer serializer = new XMLSerializer(sout, formatter);
            serializer.serialize(rdfRels);
            rels = RDFRelationshipReader.readRelationships((InputStream)new ByteArrayInputStream(sout.toString().getBytes()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (ObjectNode value : nodes) {
            boolean found = false;
            for (RelationshipTuple rel : rels) {
                if (!rel.predicate.equals(pred.toString()) || !rel.object.equals(value.toString())) continue;
                if (value instanceof Literal != rel.isLiteral) break;
                found = true;
                break;
            }
            if (found) continue;
            TestFOXMLDOSerializer.fail((String)("Failed to find relationship " + pred + " = " + value));
        }
    }
}

