/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.server.storage.translation.DOSerializer;
import org.fcrepo.server.storage.translation.METSFedoraExtDOSerializer;
import org.fcrepo.server.storage.translation.TestXMLDOSerializer;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamManagedContent;
import org.fcrepo.server.storage.types.DatastreamReferencedContent;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.utilities.TestBase64;
import org.jrdf.graph.URIReference;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public abstract class TestMETSFedoraExtDOSerializer
extends TestXMLDOSerializer {
    protected static final String ROOT_PATH = "/" + Constants.METS.METS.qName;
    protected static final String AMDSEC_PATH = ROOT_PATH + "/" + Constants.METS.AMD_SEC.qName;
    protected static final String SERIALIZED_DS_CONTENT = "<" + Constants.METS.prefix + ":FContent> \n              " + "Zm9v" + "\n</" + Constants.METS.prefix + ":FContent>\n";

    TestMETSFedoraExtDOSerializer(DOSerializer serializer) {
        super(serializer);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put(Constants.METS.prefix, Constants.METS.uri);
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
    }

    @After
    public void tearDown() {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
    }

    @Test
    public void testOBJIDAttribute() throws TransformerException, XpathException {
        DigitalObject obj = TestMETSFedoraExtDOSerializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        Document xml = this.doSerializeOrFail(obj);
        this.assertXpathExists(ROOT_PATH + "[@OBJID='" + "test:pid" + "']", xml);
    }

    @Test
    public void testNoDatastreams() throws TransformerException, XpathException {
        DigitalObject obj = TestMETSFedoraExtDOSerializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        Document xml = this.doSerializeOrFail(obj);
        this.assertXpathEvaluatesTo("1", "count(" + AMDSEC_PATH + ")", xml);
    }

    @Test
    public void testTwoInlineDatastreams() throws TransformerException, XpathException, XPathExpressionException {
        DigitalObject obj = TestMETSFedoraExtDOSerializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        String dsID1 = "DS1";
        DatastreamXMLMetadata ds1 = TestMETSFedoraExtDOSerializer.createXDatastream("DS1");
        String dsID2 = "DS2";
        DatastreamXMLMetadata ds2 = TestMETSFedoraExtDOSerializer.createXDatastream("DS2");
        obj.addDatastreamVersion((Datastream)ds1, true);
        obj.addDatastreamVersion((Datastream)ds2, true);
        Document xml = this.doSerializeOrFail(obj);
        this.assertXpathEvaluatesTo("3", "count(" + AMDSEC_PATH + ")", xml);
    }

    @Test
    public void testTwoDataStreamsVersion() throws TransformerException, XpathException, XPathExpressionException {
        DigitalObject obj = TestMETSFedoraExtDOSerializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        String dsID1 = "DS1";
        String dsID2 = "DS2";
        DatastreamManagedContent ds1 = TestMETSFedoraExtDOSerializer.createMDatastream("DS1", "a\u00f6lksdiudshfljdsfnalj mdscmjlfja\u00f6 nsa\u00f6lkjfs\u00f6lkjfs\u00f6ldkjfa\u00f6slfjas\u00f6dfla\u00f6l".getBytes());
        DatastreamManagedContent ds2 = TestMETSFedoraExtDOSerializer.createMDatastream("DS2", "\u00e4lkfdd\u00f6slfjs\u00f6lkfj\u00e4aoiam,yj\u00f6oicnc\u00e4askc\u00e4a\u00e4\u00f6l kf,jvdhfkjh".getBytes());
        obj.addDatastreamVersion((Datastream)ds1, true);
        obj.addDatastreamVersion((Datastream)ds2, true);
        Document xml = this.doSerializeOrFail(obj);
        XPath xp = XPathFactory.newInstance().newXPath();
        xp.setNamespaceContext(new javax.xml.namespace.NamespaceContext(){

            public Iterator getPrefixes(String namespaceURI) {
                return null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return "METS";
            }

            @Override
            public String getNamespaceURI(String prefix) {
                return "http://www.loc.gov/METS/";
            }
        });
        XPathExpression expr = xp.compile("//METS:fileGrp[@ID='DS1']/METS:file");
        NodeList list = (NodeList)expr.evaluate(xml, XPathConstants.NODESET);
        String checksum1 = list.item(0).getAttributes().getNamedItem("CHECKSUM").toString();
        expr = xp.compile("//METS:fileGrp[@ID='DS2']/METS:file");
        list = (NodeList)expr.evaluate(xml, XPathConstants.NODESET);
        String checkSum2 = list.item(0).getAttributes().getNamedItem("CHECKSUM").toString();
        TestMETSFedoraExtDOSerializer.assertFalse((boolean)checksum1.equals(checkSum2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDatastreamContentSerialization() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        DatastreamManagedContent dsc = TestMETSFedoraExtDOSerializer.createMDatastream("DS1", TestBase64.FOO_BYTES);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        Method testMethod = METSFedoraExtDOSerializer.class.getDeclaredMethod("serializeDatastreamContent", Datastream.class, PrintWriter.class);
        boolean accessible = testMethod.isAccessible();
        if (!accessible) {
            testMethod.setAccessible(true);
        }
        try {
            testMethod.invoke((Object)this.m_serializer, dsc, pw);
        }
        finally {
            if (!accessible) {
                testMethod.setAccessible(accessible);
            }
        }
        pw.flush();
        String actual = bos.toString();
        TestMETSFedoraExtDOSerializer.assertEquals((String)SERIALIZED_DS_CONTENT, (String)actual);
    }

    protected void doTestXLinkNamespace() throws TransformerException, XpathException {
        DigitalObject obj = TestMETSFedoraExtDOSerializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        String url = "http://example.org/DS1";
        DatastreamReferencedContent ds = TestMETSFedoraExtDOSerializer.createRDatastream("DS1", "http://example.org/DS1");
        obj.addDatastreamVersion((Datastream)ds, true);
        Document xml = this.doSerializeOrFail(obj);
        String xpath = ROOT_PATH + "/" + Constants.METS.FILE_SEC.qName + "/" + Constants.METS.FILE_GRP.qName + "[@ID='DATASTREAMS']" + "/" + Constants.METS.FILE_GRP.qName + "[@ID='DS1']" + "/" + Constants.METS.FILE.qName + "/" + Constants.METS.FLOCAT.qName + "[@" + Constants.XLINK.HREF.qName + "='" + "http://example.org/DS1" + "']";
        this.assertXpathExists(xpath, xml);
    }
}

