/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.fcrepo.common.Models;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.storage.translation.DODeserializer;
import org.fcrepo.server.storage.translation.DOSerializer;
import org.fcrepo.server.storage.translation.TranslationTest;
import org.fcrepo.server.storage.types.AuditRecord;
import org.fcrepo.server.storage.types.BasicDigitalObject;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.Disseminator;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.URIReference;
import org.junit.Test;

public abstract class TestXMLDODeserializer
extends TranslationTest {
    protected final DODeserializer m_deserializer;
    protected final DOSerializer m_serializer;

    TestXMLDODeserializer(DODeserializer deserializer, DOSerializer serializer) {
        this.m_deserializer = deserializer;
        this.m_serializer = serializer;
        if (System.getProperty("fedora.hostname") == null) {
            System.setProperty("fedora.hostname", "localhost");
        }
        if (System.getProperty("fedora.port") == null) {
            System.setProperty("fedora.port", "1024");
        }
        if (System.getProperty("fedora.appServerContext") == null) {
            System.setProperty("fedora.appServerContext", "fedora");
        }
    }

    @Test
    public void testDeserializeSimpleDataObject() {
        this.doSimpleTest(new URIReference[]{Models.FEDORA_OBJECT_3_0});
    }

    @Test
    public void testDeserializeSimpleSDepObject() {
        this.doSimpleTest(new URIReference[]{Models.SERVICE_DEPLOYMENT_3_0});
    }

    @Test
    public void testDeserializeSimpleSDefObject() {
        this.doSimpleTest(new URIReference[]{Models.SERVICE_DEFINITION_3_0});
    }

    @Test
    public void testTwoInlineDatastreams() {
        DigitalObject obj = TestXMLDODeserializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        String dsID1 = "DS1";
        DatastreamXMLMetadata ds1 = TestXMLDODeserializer.createXDatastream("DS1");
        String dsID2 = "DS2";
        DatastreamXMLMetadata ds2 = TestXMLDODeserializer.createXDatastream("DS2");
        obj.addDatastreamVersion((Datastream)ds1, true);
        obj.addDatastreamVersion((Datastream)ds2, true);
        DigitalObject result = this.doDeserializeOrFail(obj);
        int numDatastreams = 0;
        Iterator iter = result.datastreamIdIterator();
        while (iter.hasNext()) {
            iter.next();
            ++numDatastreams;
        }
        TestXMLDODeserializer.assertEquals((int)3, (int)numDatastreams);
        TestXMLDODeserializer.assertTrue((boolean)result.datastreams("DS1").iterator().hasNext());
        TestXMLDODeserializer.assertTrue((boolean)result.datastreams("DS2").iterator().hasNext());
    }

    @Test
    public void testInlineXMLCopyIntegrity() throws Exception {
        DigitalObject original = TestXMLDODeserializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        String dsID1 = "DS1";
        DatastreamXMLMetadata ds1 = TestXMLDODeserializer.createXDatastream("DS1");
        original.addDatastreamVersion((Datastream)ds1, true);
        DigitalObject copy = this.translatedCopy(original);
        DigitalObject copyOfCopy = this.translatedCopy(copy);
        DatastreamXMLMetadata ds1copy = (DatastreamXMLMetadata)copy.datastreams("DS1").iterator().next();
        DatastreamXMLMetadata ds1copyOfCopy = (DatastreamXMLMetadata)copyOfCopy.datastreams("DS1").iterator().next();
        TestXMLDODeserializer.assertEquals((String)"Length of XML datastream copies is not deterministic!", (int)ds1copy.xmlContent.length, (int)ds1copyOfCopy.xmlContent.length);
    }

    @Test
    public void testAuditDatastream() throws Exception {
        AuditRecord record = new AuditRecord();
        record.action = "modifyDatastreamByReference";
        record.componentID = "DRAWING-ICON";
        record.date = new Date(0L);
        record.id = "AUDREC1";
        record.justification = "malice";
        record.processType = "Fedora API-M";
        record.responsibility = "fedoraAdmin";
        DigitalObject original = TestXMLDODeserializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        original.getAuditRecords().add(record);
        File temp = File.createTempFile("audit", ".xml");
        FileOutputStream out = new FileOutputStream(temp);
        this.m_serializer.serialize(original, (OutputStream)out, "utf-8", 1);
        ((OutputStream)out).close();
        BasicDigitalObject candidate = new BasicDigitalObject();
        FileInputStream in = new FileInputStream(temp);
        this.m_deserializer.deserialize((InputStream)in, (DigitalObject)candidate, "utf-8", 0);
        List a1 = original.getAuditRecords();
        List a2 = candidate.getAuditRecords();
        TestXMLDODeserializer.assertEquals((int)a1.size(), (int)a2.size());
        for (int i = 0; i < a1.size(); ++i) {
            TestXMLDODeserializer.assertEquals((String)((AuditRecord)a1.get((int)i)).action, (String)((AuditRecord)a2.get((int)i)).action);
            TestXMLDODeserializer.assertEquals((String)((AuditRecord)a1.get((int)i)).componentID, (String)((AuditRecord)a2.get((int)i)).componentID);
            TestXMLDODeserializer.assertEquals((Object)((AuditRecord)a1.get((int)i)).date, (Object)((AuditRecord)a2.get((int)i)).date);
            TestXMLDODeserializer.assertEquals((String)((AuditRecord)a1.get((int)i)).id, (String)((AuditRecord)a2.get((int)i)).id);
            TestXMLDODeserializer.assertEquals((String)((AuditRecord)a1.get((int)i)).justification, (String)((AuditRecord)a2.get((int)i)).justification);
            TestXMLDODeserializer.assertEquals((String)((AuditRecord)a1.get((int)i)).processType, (String)((AuditRecord)a2.get((int)i)).processType);
            TestXMLDODeserializer.assertEquals((String)((AuditRecord)a1.get((int)i)).responsibility, (String)((AuditRecord)a2.get((int)i)).responsibility);
        }
        temp.delete();
    }

    @Test
    public void testNullObjectProperties() {
        String EXT_PROP = "http://example.org/test";
        DigitalObject input = TestXMLDODeserializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        input.setCreateDate(null);
        input.setLastModDate(null);
        input.setLabel(null);
        input.setOwnerId(null);
        input.setState(null);
        input.setExtProperty("http://example.org/test", null);
        DigitalObject obj = this.doDeserializeOrFail(input);
        TestXMLDODeserializer.assertNull((String)"Create date should be null", (Object)obj.getCreateDate());
        TestXMLDODeserializer.assertNull((String)"LastMod date should be null", (Object)obj.getLastModDate());
        TestXMLDODeserializer.assertEquals((String)"Null label should be interpreted as empty string", (String)"", (String)obj.getLabel());
        TestXMLDODeserializer.assertEquals((String)"Null ownerid should be interpreted as empty string", (String)"", (String)obj.getOwnerId());
        TestXMLDODeserializer.assertEquals((String)"Null state should be interpreted as active", (String)"A", (String)obj.getState());
        TestXMLDODeserializer.assertNull((String)"Ext property should be null", (Object)obj.getExtProperty("http://example.org/test"));
    }

    @Test
    public void testEmptyObjectProperties() {
        String EXT_PROP_SUPPORTED = "http://example.org/ext-supported";
        String EXT_PROP = "http://example.org/test";
        DigitalObject input = TestXMLDODeserializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        input.setLabel("");
        input.setOwnerId("");
        input.setExtProperty("http://example.org/ext-supported", "true");
        input.setExtProperty("http://example.org/test", "");
        DigitalObject obj = this.doDeserializeOrFail(input);
        TestXMLDODeserializer.assertEquals((String)"Empty label should remain empty", (String)"", (String)obj.getLabel());
        TestXMLDODeserializer.assertEquals((String)"Empty Ownerid should remain empty", (String)"", (String)obj.getOwnerId());
        TestXMLDODeserializer.assertEquals((String)"Empty State should be interpreted as active", (String)"A", (String)obj.getState());
        if ("true".equals(obj.getExtProperty("http://example.org/ext-supported"))) {
            TestXMLDODeserializer.assertEquals((String)"Empty Ext property should remain empty", (String)"", (String)obj.getExtProperty("http://example.org/test"));
        }
    }

    @Test
    public void testFedoraLocalServerSubstitution() {
        DigitalObject o = TestXMLDODeserializer.createTestObject(new URIReference[]{Models.SERVICE_DEPLOYMENT_3_0});
        DatastreamXMLMetadata ds1 = TestXMLDODeserializer.createXDatastream("WSDL");
        ds1.xmlContent = "<test>http://local.fedora.server/</test>".getBytes();
        o.addDatastreamVersion((Datastream)ds1, false);
        DigitalObject processed = this.doDeserializeOrFail(o);
        DatastreamXMLMetadata ds1proc = (DatastreamXMLMetadata)processed.datastreams("WSDL").iterator().next();
        Iterator ids = processed.datastreamIdIterator();
        String content = new String(ds1proc.xmlContent);
        TestXMLDODeserializer.assertFalse((boolean)content.contains("local.fedora.server"));
        TestXMLDODeserializer.assertTrue((boolean)content.contains("http"));
    }

    private DigitalObject translatedCopy(DigitalObject original) throws UnsupportedEncodingException, ObjectIntegrityException, StreamIOException {
        BasicDigitalObject copy = new BasicDigitalObject();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.m_serializer.serialize(original, (OutputStream)out, "UTF-8", 3);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        this.m_deserializer.deserialize((InputStream)in, (DigitalObject)copy, "UTF-8", 3);
        return copy;
    }

    protected void doSimpleTest(URIReference ... models) {
        DigitalObject input = TestXMLDODeserializer.createTestObject(models);
        DigitalObject obj = this.doDeserializeOrFail(input);
        for (URIReference model : models) {
            TestXMLDODeserializer.assertTrue((String)("Did not detect that object had model " + model), (boolean)obj.hasContentModel((ObjectNode)model));
        }
        TestXMLDODeserializer.assertEquals((String)"test:pid", (String)obj.getPid());
    }

    protected DigitalObject doDeserializeOrFail(DigitalObject obj) {
        DigitalObject result = null;
        try {
            result = this.doDeserialize(obj);
        }
        catch (ObjectIntegrityException e) {
            e.printStackTrace();
            TestXMLDODeserializer.fail((String)"Deserializer threw ObjectIntegrityException");
        }
        catch (StreamIOException e) {
            e.printStackTrace();
            TestXMLDODeserializer.fail((String)"Deserializer threw StreamIOException");
        }
        return result;
    }

    protected DigitalObject doDeserialize(DigitalObject obj) throws ObjectIntegrityException, StreamIOException {
        try {
            Field dsField = BasicDigitalObject.class.getDeclaredField("m_datastreams");
            dsField.setAccessible(true);
            LinkedHashMap nativelyOrdered = (LinkedHashMap)dsField.get(obj);
            LinkedHashMap speciallyOrdered = new LinkedHashMap();
            Iterator di = obj.datastreamIdIterator();
            while (di.hasNext()) {
                String id = (String)di.next();
                if (id.equals("RELS-EXT")) continue;
                speciallyOrdered.put(id, nativelyOrdered.get(id));
            }
            List rels = (List)nativelyOrdered.get("RELS-EXT");
            if (rels != null) {
                speciallyOrdered.put("RELS-EXT", rels);
            }
            dsField.set(obj, speciallyOrdered);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.doDeserialize(this.getStream(obj));
    }

    protected DigitalObject doDeserialize(InputStream in) throws ObjectIntegrityException, StreamIOException {
        BasicDigitalObject obj = new BasicDigitalObject();
        try {
            this.m_deserializer.deserialize(in, (DigitalObject)obj, "UTF-8", 0);
        }
        catch (UnsupportedEncodingException wontHappen) {
            TestXMLDODeserializer.fail((String)"Deserializer doesn't support UTF-8?!");
        }
        return obj;
    }

    protected InputStream getStream(DigitalObject obj) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.m_serializer.serialize(obj, (OutputStream)out, "UTF-8", 3);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestXMLDODeserializer.fail((String)"Failed to serialize test object for deserialization test");
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    protected void doTestTwoDisseminators() {
        DigitalObject obj = TestXMLDODeserializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        String dissID1 = "DISS1";
        Disseminator diss1 = TestXMLDODeserializer.createDisseminator("DISS1", 1);
        String dissID2 = "DISS2";
        Disseminator diss2 = TestXMLDODeserializer.createDisseminator("DISS2", 1);
        obj.disseminators("DISS1").add(diss1);
        obj.disseminators("DISS2").add(diss2);
        DigitalObject result = this.doDeserializeOrFail(obj);
        int numDisseminators = 0;
        Iterator iter = result.disseminatorIdIterator();
        while (iter.hasNext()) {
            iter.next();
            ++numDisseminators;
        }
        TestXMLDODeserializer.assertEquals((int)2, (int)numDisseminators);
        TestXMLDODeserializer.assertEquals((int)1, (int)result.disseminators("DISS1").size());
        TestXMLDODeserializer.assertEquals((int)1, (int)result.disseminators("DISS2").size());
    }
}

