/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities.rebuild;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import org.fcrepo.server.Server;
import org.fcrepo.server.config.ServerConfiguration;
import org.fcrepo.server.storage.ConnectionPool;
import org.fcrepo.server.storage.ConnectionPoolManagerImpl;
import org.fcrepo.server.storage.lowlevel.DefaultLowlevelStorageModule;
import org.fcrepo.server.utilities.SQLUtility;
import org.fcrepo.server.utilities.rebuild.Rebuild;
import org.fcrepo.server.utilities.rebuild.SQLRebuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "org.apache.xerces.*", "javax.xml.*", "org.xml.sax.*", "javax.management.*"})
@PrepareForTest(value={Rebuild.class, SQLUtility.class})
public class SQLRebuilderTest {
    @Mock
    private Connection mockDefaultConnection;
    @Mock
    private Connection mockRWConnection;
    @Mock
    private ConnectionPool mockPool;
    @Mock
    private ConnectionPoolManagerImpl mockCPM;
    @Mock
    private DatabaseMetaData mockDBM;
    @Mock
    private DefaultLowlevelStorageModule mockLLS;
    @Mock
    private PreparedStatement mockCreateStmt;
    @Mock
    private PreparedStatement mockUpdateStmt;
    @Mock
    private ResultSet mockResults;
    @Mock
    private Server mockServer;
    @Mock
    private ServerConfiguration mockConfig;
    private SQLRebuilder test = new SQLRebuilder();

    @Before
    public void setUp() throws Exception {
        PowerMockito.mockStatic(Rebuild.class, (Class[])new Class[0]);
        Mockito.when((Object)Rebuild.getServer()).thenReturn((Object)this.mockServer);
        Mockito.when((Object)this.mockServer.getModule("org.fcrepo.server.storage.lowlevel.ILowlevelStorage")).thenReturn((Object)this.mockLLS);
        Mockito.when((Object)this.mockServer.getModule("org.fcrepo.server.storage.ConnectionPoolManager")).thenReturn((Object)this.mockCPM);
        Mockito.when((Object)this.mockCPM.getPool()).thenReturn((Object)this.mockPool);
        Mockito.when((Object)this.mockPool.getReadWriteConnection()).thenReturn((Object)this.mockRWConnection);
        PowerMockito.mockStatic(SQLUtility.class, (Class[])new Class[0]);
        Mockito.when((Object)SQLUtility.getDefaultConnection((ServerConfiguration)((ServerConfiguration)Matchers.any(ServerConfiguration.class)))).thenReturn((Object)this.mockDefaultConnection);
        Mockito.when((Object)this.mockDefaultConnection.getMetaData()).thenReturn((Object)this.mockDBM);
        Mockito.when((Object)this.mockDBM.getTables(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String[])Matchers.any(String[].class))).thenReturn((Object)this.mockResults);
        Mockito.when((Object)this.mockRWConnection.prepareStatement("INSERT INTO fcrepoRebuildStatus (complete, rebuildDate) VALUES (?, ?)")).thenReturn((Object)this.mockCreateStmt);
        Mockito.when((Object)this.mockRWConnection.prepareStatement("UPDATE fcrepoRebuildStatus SET complete=? WHERE rebuildDate=?")).thenReturn((Object)this.mockUpdateStmt);
        this.test.setServerConfiguration(this.mockConfig);
    }

    @Test
    public void testGoodRebuild() throws Exception {
        this.test.start(new HashMap());
        ((PreparedStatement)Mockito.verify((Object)this.mockCreateStmt)).setBoolean(1, false);
        ((PreparedStatement)Mockito.verify((Object)this.mockCreateStmt)).execute();
        this.test.finish();
        ((PreparedStatement)Mockito.verify((Object)this.mockUpdateStmt)).setBoolean(1, true);
        ((PreparedStatement)Mockito.verify((Object)this.mockUpdateStmt)).execute();
    }

    @Test
    public void testBadRebuild() throws Exception {
        this.test.start(new HashMap());
        ((PreparedStatement)Mockito.verify((Object)this.mockCreateStmt)).setBoolean(1, false);
        ((PreparedStatement)Mockito.verify((Object)this.mockCreateStmt)).execute();
        ((PreparedStatement)Mockito.verify((Object)this.mockUpdateStmt, (VerificationMode)Mockito.never())).setBoolean(1, true);
        ((PreparedStatement)Mockito.verify((Object)this.mockUpdateStmt, (VerificationMode)Mockito.never())).execute();
    }
}

