/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.stats.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.stats.api.MimeTypeStatsResult;
import org.fcrepo.stats.api.RdfTypeStatsResult;
import org.fcrepo.stats.api.RepositoryStats;
import org.fcrepo.stats.api.RepositoryStatsByMimeTypeResults;
import org.fcrepo.stats.api.RepositoryStatsByRdfTypeResults;
import org.fcrepo.stats.api.RepositoryStatsParameters;
import org.fcrepo.stats.api.RepositoryStatsResult;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="stats")
public class DbRepositoryStatsImpl
implements RepositoryStats {
    private static final String SELECT_COUNT_FROM_SIMPLE_SEARCH = "select count(*) from simple_search";
    @Inject
    private DataSource dataSource;
    private NamedParameterJdbcTemplate jdbcTemplate;

    @PostConstruct
    public void setup() {
        this.jdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
    }

    public RepositoryStatsResult getResourceCount(RepositoryStatsParameters statsParams) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        SqlRowSet results = this.jdbcTemplate.queryForRowSet(SELECT_COUNT_FROM_SIMPLE_SEARCH, (SqlParameterSource)parameterSource);
        results.first();
        RepositoryStatsResult result = new RepositoryStatsResult();
        result.setResourceCount(Long.valueOf(results.getLong(1)));
        return result;
    }

    public RepositoryStatsByMimeTypeResults getByMimeTypes(RepositoryStatsParameters statsParams) {
        RepositoryStatsByMimeTypeResults results = new RepositoryStatsByMimeTypeResults();
        List mimeTypes = statsParams.getMimeTypes();
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        String mimeTypesQuery = this.formatMimetypeQuery(mimeTypes, parameterSource);
        SqlRowSet mimetypeResults = this.jdbcTemplate.queryForRowSet(mimeTypesQuery, (SqlParameterSource)parameterSource);
        this.marshallMimeTypeResults(results, mimetypeResults);
        return results;
    }

    public RepositoryStatsByRdfTypeResults getByRdfType(RepositoryStatsParameters statsParams) {
        RepositoryStatsByRdfTypeResults results = new RepositoryStatsByRdfTypeResults();
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        String query = this.formatRdfTypeQuery(statsParams.getRdfTypes(), parameterSource);
        SqlRowSet rdfTypeResults = this.jdbcTemplate.queryForRowSet(query, (SqlParameterSource)parameterSource);
        this.marshallRdfTypeResults(results, rdfTypeResults);
        return results;
    }

    private void marshallMimeTypeResults(RepositoryStatsByMimeTypeResults results, SqlRowSet mimeTypeResults) {
        if (mimeTypeResults.first()) {
            ArrayList<MimeTypeStatsResult> mimeTypesResultList = new ArrayList<MimeTypeStatsResult>();
            do {
                MimeTypeStatsResult mimeTypeResult = new MimeTypeStatsResult();
                mimeTypeResult.setMimeType(mimeTypeResults.getString(1));
                mimeTypeResult.setResourceCount(Long.valueOf(mimeTypeResults.getLong(2)));
                mimeTypeResult.setByteCount(Long.valueOf(mimeTypeResults.getLong(3)));
                mimeTypesResultList.add(mimeTypeResult);
            } while (mimeTypeResults.next());
            results.setMimeTypes(mimeTypesResultList);
        }
    }

    private String formatMimetypeQuery(List<String> mimeTypes, MapSqlParameterSource parameterSource) {
        StringBuilder mimeTypesQuery = new StringBuilder("select a.mime_type, count(a.id), sum(a.content_size) ");
        mimeTypesQuery.append("from simple_search a, search_resource_rdf_type b,  search_rdf_type c ");
        mimeTypesQuery.append("where a.id = b.resource_id and b.rdf_type_id = c.id and c.rdf_type_uri = '");
        mimeTypesQuery.append(RdfLexicon.NON_RDF_SOURCE.getURI());
        mimeTypesQuery.append("' ");
        if (!CollectionUtils.isEmpty(mimeTypes)) {
            mimeTypesQuery.append("and a.mime_type in (:mime_types) ");
            parameterSource.addValue("mime_types", mimeTypes);
        }
        mimeTypesQuery.append("group by a.mime_type order by a.mime_type");
        return mimeTypesQuery.toString();
    }

    private void marshallRdfTypeResults(RepositoryStatsByRdfTypeResults results, SqlRowSet rdfTypeResults) {
        if (rdfTypeResults.first()) {
            ArrayList<RdfTypeStatsResult> resourceTypeStatsResults = new ArrayList<RdfTypeStatsResult>();
            do {
                RdfTypeStatsResult resourceTypeResult = new RdfTypeStatsResult();
                resourceTypeResult.setResourceType(rdfTypeResults.getString(1));
                resourceTypeResult.setResourceCount(Long.valueOf(rdfTypeResults.getLong(2)));
                resourceTypeResult.setByteCount(Long.valueOf(rdfTypeResults.getLong(3)));
                resourceTypeStatsResults.add(resourceTypeResult);
            } while (rdfTypeResults.next());
            results.setRdfTypes(resourceTypeStatsResults);
        }
    }

    private String formatRdfTypeQuery(List<String> rdfTypes, MapSqlParameterSource parameterSource) {
        StringBuilder rdfTypesQuery = new StringBuilder("select c.rdf_type_uri, count(b.resource_id), sum(a.content_size) ");
        rdfTypesQuery.append("from simple_search a, search_resource_rdf_type b,  search_rdf_type c ");
        rdfTypesQuery.append("where a.id = b.resource_id and b.rdf_type_id = c.id ");
        if (!CollectionUtils.isEmpty(rdfTypes)) {
            rdfTypesQuery.append("and c.rdf_type_uri in (:rdf_types) ");
            parameterSource.addValue("rdf_types", rdfTypes);
        }
        rdfTypesQuery.append("group by c.rdf_type_uri");
        return rdfTypesQuery.toString();
    }
}

