/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.storage.ocfl.validation;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.fcrepo.storage.ocfl.exception.ChecksumMismatchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DigestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DigestUtil.class);
    private static final Map<String, String> ALGO_MAP = Map.of("sha1", "SHA-1", "sha256", "SHA-256", "sha512", "SHA-512", "sha512/256", "SHA-512/256", "md5", "MD5");

    private DigestUtil() {
    }

    public static void checkFixity(InputStream stream, Collection<URI> expectedDigests) {
        Map<String, String> expectedMap = DigestUtil.parseDigests(expectedDigests);
        if (expectedMap.isEmpty()) {
            return;
        }
        HashMap<String, DigestInputStream> streamMap = new HashMap<String, DigestInputStream>();
        InputStream wrappedStream = stream;
        for (String algorithm2 : expectedMap.keySet()) {
            DigestInputStream digestStream2 = DigestUtil.digestInputStream(wrappedStream, algorithm2);
            streamMap.put(algorithm2, digestStream2);
            wrappedStream = digestStream2;
        }
        try {
            while (wrappedStream.read() != -1) {
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to calculate stream digests", e);
        }
        ArrayList<String> failures = new ArrayList<String>();
        streamMap.forEach((algorithm, digestStream) -> {
            String actual;
            String expected = (String)expectedMap.get(algorithm);
            if (!expected.equalsIgnoreCase(actual = Hex.encodeHexString((byte[])digestStream.getMessageDigest().digest()))) {
                failures.add(String.format("%s fixity check failed. Expected: %s; Actual: %s", algorithm, expected, actual));
            }
        });
        if (!failures.isEmpty()) {
            throw new ChecksumMismatchException(failures);
        }
    }

    private static Map<String, String> parseDigests(Collection<URI> digests) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (URI digest : digests) {
            String[] parts = digest.toString().split(":");
            if (parts.length != 3) {
                LOG.debug("Skipping invalid digest: {}", (Object)digest);
                continue;
            }
            String algorithm = ALGO_MAP.get(parts[1].toLowerCase().replaceAll("-", ""));
            if (algorithm == null) {
                LOG.debug("Skipping invalid digest algorithm: {}", (Object)digest);
                continue;
            }
            map.put(algorithm, parts[2]);
        }
        return map;
    }

    private static DigestInputStream digestInputStream(InputStream stream, String algorithm) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            return new DigestInputStream(stream, messageDigest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to create message digest for " + algorithm, e);
        }
    }
}

