/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.storage.ocfl.validation;

import com.fasterxml.jackson.databind.ObjectReader;
import edu.wisc.library.ocfl.api.MutableOcflRepository;
import edu.wisc.library.ocfl.api.exception.FixityCheckException;
import edu.wisc.library.ocfl.api.io.FixityCheckInputStream;
import edu.wisc.library.ocfl.api.model.FileDetails;
import edu.wisc.library.ocfl.api.model.ObjectDetails;
import edu.wisc.library.ocfl.api.model.ObjectVersionId;
import edu.wisc.library.ocfl.api.model.OcflObjectVersion;
import edu.wisc.library.ocfl.api.model.OcflObjectVersionFile;
import edu.wisc.library.ocfl.api.model.VersionDetails;
import edu.wisc.library.ocfl.api.model.VersionNum;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.fcrepo.storage.ocfl.InteractionModel;
import org.fcrepo.storage.ocfl.PersistencePaths;
import org.fcrepo.storage.ocfl.ResourceHeaders;
import org.fcrepo.storage.ocfl.exception.ChecksumMismatchException;
import org.fcrepo.storage.ocfl.exception.ValidationException;
import org.fcrepo.storage.ocfl.validation.Context;
import org.fcrepo.storage.ocfl.validation.DefaultHeadersValidator;
import org.fcrepo.storage.ocfl.validation.DigestUtil;
import org.fcrepo.storage.ocfl.validation.ValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectValidator.class);
    private final MutableOcflRepository ocflRepo;
    private final ObjectReader headerReader;
    private final DefaultHeadersValidator headersValidator;

    public ObjectValidator(MutableOcflRepository ocflRepo, ObjectReader headerReader) {
        this.ocflRepo = Objects.requireNonNull(ocflRepo, "ocflRepo cannot be null");
        this.headerReader = Objects.requireNonNull(headerReader, "headerReader cannot be null");
        this.headersValidator = new DefaultHeadersValidator();
    }

    public void validate(String ocflObjectId, boolean checkFixity) {
        Objects.requireNonNull(ocflObjectId, "ocflObjectId cannot be null");
        LOG.debug("Validating object {} with fixity check {}", (Object)ocflObjectId, (Object)checkFixity);
        new ObjectValidatorInner(ocflObjectId, checkFixity).validate();
    }

    private static class ContinueException
    extends RuntimeException {
        private ContinueException() {
        }
    }

    private class ObjectValidatorInner {
        private final String ocflObjectId;
        private final boolean checkFixity;
        private final Context context;
        private final Map<String, String> resourceModelMap;

        private ObjectValidatorInner(String ocflObjectId, boolean checkFixity) {
            this.ocflObjectId = ocflObjectId;
            this.checkFixity = checkFixity;
            this.context = new Context(ocflObjectId);
            this.resourceModelMap = new HashMap<String, String>();
        }

        private void validate() {
            this.objectExists();
            ObjectDetails objDetails = this.readInventory();
            objDetails.getVersionMap().forEach((versionNum, versionDetails) -> {
                try {
                    this.validateVersion((VersionNum)versionNum, (VersionDetails)versionDetails);
                }
                catch (ContinueException continueException) {
                }
                catch (RuntimeException e) {
                    this.context.problem("Unexpected failure validating version %s: %s", versionNum, e.getMessage());
                    LOG.warn("Unexpected failure validating version {}", versionNum, (Object)e);
                }
            });
            this.context.throwValidationException();
        }

        private void validateVersion(VersionNum versionNum, VersionDetails versionDetails) {
            LOG.debug("Validating object {} version {}", (Object)this.ocflObjectId, (Object)versionNum);
            HashMap<String, String> resourceParentMap = new HashMap<String, String>();
            HashSet<String> deletedResources = new HashSet<String>();
            HashSet<String> nonRdfDescriptions = new HashSet<String>();
            HashSet<String> nonRdfResources = new HashSet<String>();
            HashSet<String> headerFiles = new HashSet<String>();
            HashSet<String> contentFiles = new HashSet<String>();
            for (FileDetails file : versionDetails.getFiles()) {
                String path = file.getPath();
                if (PersistencePaths.isHeaderFile(path)) {
                    headerFiles.add(path);
                    continue;
                }
                contentFiles.add(path);
            }
            HashSet unseenContentFiles = new HashSet(contentFiles);
            ResourceHeaders rootHeaders = this.validateRootHeaders(versionNum, headerFiles);
            headerFiles.forEach(headerFile -> {
                LOG.trace("Validating object {} version {} header file {}", new Object[]{this.ocflObjectId, versionNum, headerFile});
                try {
                    PersistencePaths persistencePaths;
                    ResourceHeaders headers;
                    boolean isRoot = ".fcrepo/fcr-root.json".equals(headerFile);
                    ResourceHeaders resourceHeaders = headers = isRoot ? rootHeaders : this.parseHeaders(versionNum, (String)headerFile);
                    if (headers.getId() != null) {
                        if (headers.isDeleted()) {
                            deletedResources.add(headers.getId());
                        }
                        if (headers.getInteractionModel() != null) {
                            String previousModel = this.resourceModelMap.get(headers.getId());
                            if (previousModel != null) {
                                if (!previousModel.equals(headers.getInteractionModel())) {
                                    this.context.problem("[Version %s header file %s] Interaction model declared as %s but a previous version declares the model as %s.", versionNum, headerFile, headers.getInteractionModel(), previousModel);
                                }
                            } else {
                                this.resourceModelMap.put(headers.getId(), headers.getInteractionModel());
                            }
                        }
                        if (headers.getParent() != null) {
                            resourceParentMap.put(headers.getId(), headers.getParent());
                        }
                        if (ValidationUtil.isModel(InteractionModel.NON_RDF_DESCRIPTION, headers.getInteractionModel())) {
                            nonRdfDescriptions.add(headers.getId());
                        } else if (ValidationUtil.isModel(InteractionModel.NON_RDF, headers.getInteractionModel())) {
                            nonRdfResources.add(headers.getId());
                        }
                    }
                    if ((persistencePaths = this.resolvePersistencePaths(versionNum, (String)headerFile, headers, rootHeaders)) != null) {
                        unseenContentFiles.remove(persistencePaths.getContentFilePath());
                        if (!headerFile.equals(persistencePaths.getHeaderFilePath())) {
                            this.context.problem("[Version %s header file %s] Header file should be located at %s", versionNum, headerFile, persistencePaths.getHeaderFilePath());
                        }
                    }
                    try {
                        ObjectValidator.this.headersValidator.validate(persistencePaths, headers, rootHeaders);
                    }
                    catch (ValidationException e) {
                        e.getProblems().forEach(problem -> this.context.problem("[Version %s header file %s] %s", versionNum, headerFile, problem));
                    }
                    this.fixityCheck(versionNum, (String)headerFile, persistencePaths, headers);
                }
                catch (ContinueException isRoot) {
                }
                catch (RuntimeException e) {
                    this.context.problem("[Version %s header file %s] Unexpected failure: %s", versionNum, headerFile, e.getMessage());
                    LOG.warn("Unexpected failure validating version {} header file {}", new Object[]{versionNum, headerFile, e});
                }
            });
            this.validateNonRdfDescriptionsHaveNonRdfParent(versionNum, nonRdfDescriptions);
            this.validateNonRdfResourcesHaveDescription(versionNum, nonRdfResources);
            this.validateArchivalGroupParentage(versionNum, resourceParentMap, deletedResources, rootHeaders);
            unseenContentFiles.forEach(unseenFile -> this.context.problem("[Version %s] Unexpected file: %s", versionNum, unseenFile));
        }

        private ResourceHeaders validateRootHeaders(VersionNum versionNum, Set<String> headerFiles) {
            String headerFile = ".fcrepo/fcr-root.json";
            if (!headerFiles.contains(".fcrepo/fcr-root.json")) {
                this.context.problem("[Version %s] Missing root header file at %s", versionNum, ".fcrepo/fcr-root.json");
                throw new ContinueException();
            }
            ResourceHeaders headers = this.parseHeaders(versionNum, ".fcrepo/fcr-root.json");
            Context idContext = new Context();
            ValidationUtil.validateId(idContext, "id", headers.getId());
            String problem = idContext.getProblems().stream().findFirst().orElse(null);
            if (problem != null) {
                this.context.problem("[Version %s header file %s] %s", versionNum, ".fcrepo/fcr-root.json", problem);
                throw new ContinueException();
            }
            if (!Objects.equals(this.ocflObjectId, headers.getId())) {
                this.context.problem("[Version %s header file %s] Must define property 'id' as '%s' but was '%s'", versionNum, ".fcrepo/fcr-root.json", this.ocflObjectId, headers.getId());
            }
            return headers;
        }

        private void validateNonRdfDescriptionsHaveNonRdfParent(VersionNum versionNum, Set<String> nonRdfDescriptions) {
            nonRdfDescriptions.forEach(id -> {
                String parent = StringUtils.substringBeforeLast((String)id, (String)"/");
                String parentModel = this.resourceModelMap.get(parent);
                if (parentModel == null) {
                    this.context.problem("[Version %s resource %s] Non-RDF resource description without a corresponding non-RDF resource.", versionNum, id);
                } else if (!InteractionModel.NON_RDF.getUri().equals(parentModel)) {
                    this.context.problem("[Version %s resource %s] Must be the child of a non-RDF resource.", versionNum, id);
                }
            });
        }

        private void validateNonRdfResourcesHaveDescription(VersionNum versionNum, Set<String> nonRdfResources) {
            nonRdfResources.forEach(id -> {
                String desc = id + "/fcr:metadata";
                String descModel = this.resourceModelMap.get(desc);
                if (descModel == null) {
                    this.context.problem("[Version %s resource %s] Non-RDF resource without a non-RDF description", versionNum, id);
                } else if (!ValidationUtil.isModel(InteractionModel.NON_RDF_DESCRIPTION, descModel)) {
                    this.context.problem("[Version %s resource %s] Must have interaction model %s", versionNum, desc, descModel, InteractionModel.NON_RDF_DESCRIPTION.getUri());
                }
            });
        }

        private void validateArchivalGroupParentage(VersionNum versionNum, Map<String, String> resourceParentMap, Set<String> deletedResources, ResourceHeaders rootHeaders) {
            if (rootHeaders.isArchivalGroup()) {
                resourceParentMap.forEach((id, parent) -> {
                    if (!rootHeaders.getId().equals(id)) {
                        String model;
                        boolean childDeleted = deletedResources.contains(id);
                        boolean parentDeleted = deletedResources.contains(parent);
                        if (parentDeleted && !childDeleted) {
                            this.context.problem("[Version %s resource %s] Must be marked as deleted because parent %s is marked as deleted.", versionNum, id, parent);
                        }
                        if ((model = this.resourceModelMap.get(id)) != null && !ValidationUtil.isModel(InteractionModel.ACL, model) && !ValidationUtil.isModel(InteractionModel.NON_RDF_DESCRIPTION, model)) {
                            if (resourceParentMap.containsKey(parent)) {
                                String parentModel = this.resourceModelMap.get(parent);
                                if (parentModel != null && !ValidationUtil.isContainer(parentModel)) {
                                    this.context.problem("[Version %s resource %s] Parent %s has interaction model %s, which cannot have children.", versionNum, id, parent, parentModel);
                                }
                            } else {
                                this.context.problem("[Version %s resource %s] Parent %s does not exist.", versionNum, id, parent);
                            }
                        }
                    }
                });
            }
        }

        private void fixityCheck(VersionNum versionNum, String headerFile, PersistencePaths persistencePaths, ResourceHeaders headers) {
            if (this.checkFixity) {
                OcflObjectVersion object = this.getObjectVersion(versionNum);
                this.fixityCheck(object, headerFile, null);
                if (persistencePaths != null && ValidationUtil.contentExpected(headers)) {
                    this.fixityCheck(object, persistencePaths.getContentFilePath(), headers.getDigests());
                }
            }
        }

        private void fixityCheck(OcflObjectVersion object, String path, Collection<URI> expectedDigests) {
            LOG.debug("Fixity check object {} file {}", (Object)object.getObjectVersionId(), (Object)path);
            VersionNum versionNum = object.getVersionNum();
            OcflObjectVersionFile file = object.getFile(path);
            if (file != null) {
                try (FixityCheckInputStream stream = file.getStream();){
                    if (expectedDigests != null) {
                        DigestUtil.checkFixity((InputStream)stream, expectedDigests);
                    }
                    while (stream.read() != -1) {
                    }
                    stream.checkFixity();
                }
                catch (FixityCheckException e) {
                    this.context.problem("[Version %s file %s] Failed fixity check: %s", versionNum, path, e.getMessage());
                }
                catch (ChecksumMismatchException e) {
                    e.getProblems().forEach(problem -> this.context.problem("[Version %s file %s] Failed fixity check: %s", versionNum, path, problem));
                }
                catch (IOException | RuntimeException e) {
                    this.context.problem("[Version %s file %s] Failed to check fixity: %s", versionNum, path, e.getMessage());
                }
            } else {
                this.context.problem("[Version %s file %s] Does not exist.", versionNum, path);
            }
        }

        private ResourceHeaders parseHeaders(VersionNum versionNum, String headerFile) {
            ResourceHeaders resourceHeaders;
            block8: {
                OcflObjectVersion object = this.getObjectVersion(versionNum);
                OcflObjectVersionFile file = object.getFile(headerFile);
                FixityCheckInputStream stream = file.getStream();
                try {
                    resourceHeaders = (ResourceHeaders)ObjectValidator.this.headerReader.readValue((InputStream)stream);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.context.problem("[Version %s header file %s] Failed to parse: %s", versionNum, headerFile, e.getMessage());
                        throw new ContinueException();
                    }
                }
                stream.close();
            }
            return resourceHeaders;
        }

        private OcflObjectVersion getObjectVersion(VersionNum versionNum) {
            try {
                return ObjectValidator.this.ocflRepo.getObject(ObjectVersionId.version((String)this.ocflObjectId, (VersionNum)versionNum));
            }
            catch (RuntimeException e) {
                this.context.problem("OCFL object version %s could not be read: %s", versionNum, e.getMessage());
                throw new ContinueException();
            }
        }

        private PersistencePaths resolvePersistencePaths(VersionNum versionNum, String headerFile, ResourceHeaders headers, ResourceHeaders rootHeaders) {
            PersistencePaths paths = null;
            String resourceId = headers.getId();
            String rootId = rootHeaders.getId();
            if (resourceId != null) {
                try {
                    if (ValidationUtil.isModel(InteractionModel.ACL, headers.getInteractionModel()) && headers.getParent() != null) {
                        String parentHeadersPath = PersistencePaths.headerPath(rootId, headers.getParent());
                        ResourceHeaders parentHeaders = this.parseHeaders(versionNum, parentHeadersPath);
                        boolean describesRdf = !ValidationUtil.isModel(InteractionModel.NON_RDF, parentHeaders.getInteractionModel());
                        paths = PersistencePaths.aclResource(describesRdf, rootId, resourceId);
                    } else if (ValidationUtil.isModel(InteractionModel.NON_RDF, headers.getInteractionModel())) {
                        paths = PersistencePaths.nonRdfResource(rootId, resourceId);
                    } else if (headers.getInteractionModel() != null) {
                        paths = PersistencePaths.rdfResource(rootId, resourceId);
                    }
                }
                catch (RuntimeException e) {
                    this.context.problem("[Version %s header file %s] Unexpected problem identifying persistence paths: %s", versionNum, headerFile, e.getMessage());
                }
            }
            return paths;
        }

        private void objectExists() {
            if (!ObjectValidator.this.ocflRepo.containsObject(this.ocflObjectId)) {
                this.context.problem("OCFL object does not exist in the repository");
                this.context.throwValidationException();
            }
        }

        private ObjectDetails readInventory() {
            try {
                return ObjectValidator.this.ocflRepo.describeObject(this.ocflObjectId);
            }
            catch (RuntimeException e) {
                this.context.problem("The OCFL object cannot be read: %s", e.getMessage());
                this.context.throwValidationException();
                throw new IllegalStateException();
            }
        }
    }
}

