/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.storage.policy;

import com.codahale.metrics.annotation.Timed;
import com.sun.jersey.api.Responses;
import java.net.URI;
import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.fcrepo.http.commons.AbstractResource;
import org.fcrepo.http.commons.session.InjectedSession;
import org.fcrepo.kernel.impl.FedoraResourceImpl;
import org.fcrepo.kernel.services.policy.StoragePolicy;
import org.fcrepo.kernel.services.policy.StoragePolicyDecisionPoint;
import org.fcrepo.storage.policy.MimeTypeStoragePolicy;
import org.fcrepo.storage.policy.StoragePolicyTypeException;
import org.modeshape.jcr.api.JcrTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Path(value="/{path: .*}/fcr:storagepolicy")
public class FedoraStoragePolicy
extends AbstractResource {
    public static final String FEDORA_STORAGE_POLICY_PATH = "/fedora:system/fedora:storage_policy";
    @InjectedSession
    protected Session session;
    @Context
    protected HttpServletRequest request;
    @Autowired(required=true)
    protected StoragePolicyDecisionPoint storagePolicyDecisionPoint;
    private JcrTools jcrTools;
    public static final String POLICY_RESOURCE = "policies";
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraStoragePolicy.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void setUpRepositoryConfiguration() throws RepositoryException {
        Session internalSession = null;
        try {
            internalSession = this.sessions.getInternalSession();
            new FedoraResourceImpl(internalSession, FEDORA_STORAGE_POLICY_PATH, "nt:folder");
            internalSession.save();
            LOGGER.debug("Created configuration node");
        }
        finally {
            if (internalSession != null) {
                internalSession.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Timed
    public Response post(@PathParam(value="path") String path, String request) throws RepositoryException {
        Response.ResponseBuilder response;
        block6: {
            LOGGER.debug("POST Received request param: {}", (Object)request);
            if (!path.equalsIgnoreCase(POLICY_RESOURCE)) {
                return Responses.methodNotAllowed().entity((Object)("POST method not allowed on " + this.getUriInfo().getAbsolutePath() + ", try /policies/fcr:storagepolicy")).build();
            }
            String[] str = StringUtils.split((String)request);
            this.validateArgs(str.length);
            try {
                Node node = this.getJcrTools().findOrCreateNode(this.session, FEDORA_STORAGE_POLICY_PATH, "test");
                if (this.isValidNodeTypeProperty(this.session, str[0]) || this.isValidConfigurationProperty(str[0])) {
                    node.setProperty(str[0], new String[]{str[1] + ":" + str[2]});
                    StoragePolicy policy = this.newPolicyInstance(str[0], str[1], str[2]);
                    if (this.storagePolicyDecisionPoint.contains(policy)) {
                        throw new StoragePolicyTypeException("Property already exists!");
                    }
                    this.storagePolicyDecisionPoint.addPolicy(policy);
                    this.session.save();
                    LOGGER.debug("Saved PDS hint {}", (Object)request);
                    response = Response.created((URI)this.getUriInfo().getBaseUriBuilder().path(FedoraStoragePolicy.class).buildFromMap(Collections.singletonMap("path", str[0])));
                    break block6;
                }
                throw new StoragePolicyTypeException("Invalid property type specified: " + str[0]);
            }
            finally {
                this.session.logout();
            }
        }
        return response.build();
    }

    protected StoragePolicy newPolicyInstance(String propertyType, String itemType, String value) {
        switch (propertyType) {
            case "{http://www.jcp.org/jcr/mix/1.0}mimeType": 
            case "mix:mimeType": {
                return new MimeTypeStoragePolicy(itemType, value);
            }
        }
        throw new StoragePolicyTypeException("Mapping not found");
    }

    @DELETE
    @Timed
    public Response deleteNodeType(@PathParam(value="path") String nodeType) throws RepositoryException {
        try {
            LOGGER.debug("Deleting node property{}", (Object)nodeType);
            Node node = this.getJcrTools().findOrCreateNode(this.session, FEDORA_STORAGE_POLICY_PATH, "test");
            if (this.isValidNodeTypeProperty(this.session, nodeType)) {
                node.getProperty(nodeType).remove();
                this.session.save();
                this.storagePolicyDecisionPoint.removeAll();
                Response response = Response.noContent().build();
                return response;
            }
            throw new RepositoryException("Invalid property type specified.");
        }
        finally {
            this.session.logout();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Timed
    public Response get(@PathParam(value="path") String path) throws RepositoryException {
        if (POLICY_RESOURCE.equalsIgnoreCase(path)) {
            return this.getAllStoragePolicies();
        }
        return this.getStoragePolicy(path);
    }

    private Response getAllStoragePolicies() {
        if (this.storagePolicyDecisionPoint == null || this.storagePolicyDecisionPoint.isEmpty()) {
            return Response.ok((Object)"No Policies Found").build();
        }
        return Response.ok((Object)this.storagePolicyDecisionPoint.toString()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response getStoragePolicy(String nodeType) throws RepositoryException {
        Response.ResponseBuilder response;
        block5: {
            LOGGER.debug("Get storage policy for: {}", (Object)nodeType);
            try {
                Node node = this.getJcrTools().findOrCreateNode(this.session, FEDORA_STORAGE_POLICY_PATH, "test");
                Property prop = node.getProperty(nodeType);
                if (null == prop) {
                    throw new PathNotFoundException("StoragePolicy not found: " + nodeType);
                }
                Value[] values = prop.getValues();
                if (values != null && values.length > 0) {
                    response = Response.ok((Object)values[0].getString());
                    break block5;
                }
                throw new PathNotFoundException("StoragePolicy not found: " + nodeType);
            }
            finally {
                this.session.logout();
            }
        }
        return response.build();
    }

    private boolean isValidNodeTypeProperty(Session session, String type) throws RepositoryException {
        try {
            return session.getWorkspace().getNodeTypeManager().getNodeType(type).getName().equals(type);
        }
        catch (NoSuchNodeTypeException e) {
            LOGGER.debug("No corresponding Node type found for: {}", (Object)type, (Object)e);
            return false;
        }
    }

    private boolean isValidConfigurationProperty(String property) {
        return false;
    }

    private void validateArgs(int inputSize) {
        if (inputSize != InputPattern.valueOf(this.request.getMethod()).requiredLength) {
            throw new IllegalArgumentException("Invalid Arg");
        }
    }

    private JcrTools getJcrTools() {
        if (null == this.jcrTools) {
            this.jcrTools = new JcrTools(true);
        }
        return this.jcrTools;
    }

    public void setJcrTools(JcrTools jcrTools) {
        this.jcrTools = jcrTools;
    }

    private UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    private static enum InputPattern {
        POST(3),
        DELETE(3);

        private final int requiredLength;

        private InputPattern(int l) {
            this.requiredLength = l;
        }
    }
}

