/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.storage.policy;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.services.policy.StoragePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeTypeStoragePolicy
implements StoragePolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimeTypeStoragePolicy.class);
    private final String mimeType;
    private final String hint;

    public MimeTypeStoragePolicy(String mimeType, String hint) {
        this.mimeType = mimeType;
        this.hint = hint;
    }

    public String toString() {
        return "MimeTypeStoragePolicy [mimeType=" + this.mimeType + ", hint=" + this.hint + "]";
    }

    public String evaluatePolicy(Node n) {
        LOGGER.debug("Evaluating MimeTypeStoragePolicy ({} -> {}) for {} ", new Object[]{this.mimeType, this.hint, n});
        try {
            String nodeMimeType = n.getNode("jcr:content").getProperty("jcr:mimeType").getString();
            LOGGER.trace("Found mime type {}", (Object)nodeMimeType);
            if (nodeMimeType.equals(this.mimeType)) {
                LOGGER.trace("{} matched this mime type.Returning hint {} ", (Object)this.mimeType, (Object)this.hint);
                return this.hint;
            }
        }
        catch (RepositoryException e) {
            LOGGER.info("Got Exception evaluating policy: {}", (Object)e.getMessage());
            return null;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hint == null ? 0 : this.hint.hashCode());
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MimeTypeStoragePolicy other = (MimeTypeStoragePolicy)obj;
        if (this.hint == null ? other.hint != null : !this.hint.equals(other.hint)) {
            return false;
        }
        return !(this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType));
    }
}

