/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.storage.policy;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.fcrepo.kernel.services.policy.StoragePolicy;
import org.fcrepo.kernel.services.policy.StoragePolicyDecisionPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoragePolicyDecisionPointImpl
implements StoragePolicyDecisionPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoragePolicyDecisionPointImpl.class);
    private List<StoragePolicy> policies;

    public StoragePolicyDecisionPointImpl() {
        LOGGER.debug("Initializing binary StoragePolicyDecisionPointImpl");
        this.policies = new ArrayList<StoragePolicy>();
    }

    public void addPolicy(StoragePolicy p) {
        this.policies.add(p);
    }

    public String evaluatePolicies(Node n) {
        for (StoragePolicy p : this.policies) {
            String h = p.evaluatePolicy(n);
            if (h == null) continue;
            return h;
        }
        return null;
    }

    public void removePolicy(StoragePolicy p) {
        this.policies.remove(p);
    }

    public void removeAll() {
        this.policies.clear();
    }

    public boolean contains(StoragePolicy p) {
        return this.policies.contains(p);
    }

    public void setPolicies(List<StoragePolicy> policies) {
        this.policies = policies;
    }

    public String toString() {
        return "policies=" + this.policies;
    }

    public int size() {
        return this.policies.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

