/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.transform;

import com.google.common.base.Throwables;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.fcrepo.transform.Transformation;
import org.fcrepo.transform.transformations.LDPathTransform;
import org.fcrepo.transform.transformations.SparqlQueryTransform;

public class TransformationFactory {
    private Map<String, Class<?>> mimeToTransform;

    public TransformationFactory() {
        this.mimeToTransform = new HashMap();
        this.mimeToTransform.put("application/sparql-query", SparqlQueryTransform.class);
        this.mimeToTransform.put("application/rdf+ldpath", LDPathTransform.class);
    }

    public TransformationFactory(Map<String, Class<?>> mimeToTransform) {
        this.mimeToTransform = mimeToTransform;
    }

    public Transformation getTransform(MediaType contentType, InputStream inputStream) {
        Class<?> transform;
        if (this.mimeToTransform.containsKey(contentType.toString()) && Transformation.class.isAssignableFrom(transform = this.mimeToTransform.get(contentType.toString()))) {
            try {
                return (Transformation)transform.getConstructor(InputStream.class).newInstance(inputStream);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return null;
    }
}

