/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.transform.http;

import com.codahale.metrics.annotation.Timed;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.hp.hpl.jena.query.ResultSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.fcrepo.http.api.FedoraNodes;
import org.fcrepo.http.commons.AbstractResource;
import org.fcrepo.http.commons.api.rdf.HttpGraphSubjects;
import org.fcrepo.http.commons.domain.RDFMediaType;
import org.fcrepo.http.commons.responses.ViewHelpers;
import org.fcrepo.http.commons.session.InjectedSession;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.rdf.impl.NamespaceRdfContext;
import org.fcrepo.kernel.utils.LogoutCallback;
import org.fcrepo.transform.http.responses.ResultSetStreamingOutput;
import org.fcrepo.transform.sparql.JQLConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Path(value="/fcr:sparql")
public class FedoraSparql
extends AbstractResource {
    @InjectedSession
    protected Session session;
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraSparql.class);

    @GET
    @Timed
    @Produces(value={"text/html"})
    public Response sparqlQueryForm() throws IOException, RepositoryException {
        Properties properties = new Properties();
        URL propertiesUrl = ((Object)((Object)this)).getClass().getResource("/velocity.properties");
        VelocityEngine velocity = new VelocityEngine();
        LOGGER.debug("Using Velocity configuration from {}", (Object)propertiesUrl);
        try (InputStream propertiesStream = propertiesUrl.openStream();){
            properties.load(propertiesStream);
        }
        velocity.init(properties);
        final Template template = velocity.getTemplate("/views/search-sparql.vsl");
        VelocityContext context = new VelocityContext();
        context.put("uriInfo", (Object)this.uriInfo);
        context.put("model", (Object)new NamespaceRdfContext(this.session).asModel());
        context.put("helpers", (Object)ViewHelpers.getInstance());
        StreamingOutput stream = new StreamingOutput((org.apache.velocity.context.Context)context){
            final /* synthetic */ org.apache.velocity.context.Context val$context;
            {
                this.val$context = context;
            }

            public void write(OutputStream output) throws IOException {
                OutputStreamWriter outWriter = new OutputStreamWriter(output);
                template.merge(this.val$context, (Writer)outWriter);
                ((Writer)outWriter).flush();
            }
        };
        return Response.ok((Object)stream).build();
    }

    @POST
    @Consumes(value={"application/sparql-query"})
    @Produces(value={"text/tab-separated-values", "text/csv", "text/sse", "text/plain", "application/sparql-results+json", "application/sparql-results+xml", "application/sparql-results+bio", "text/turtle", "text/rdf+n3", "application/n-triples", "application/rdf+xml"})
    public Response runSparqlQuery(InputStream requestBodyStream, @Context Request request, @Context UriInfo uriInfo) throws IOException, RepositoryException {
        HttpGraphSubjects graphSubjects = new HttpGraphSubjects(this.session, FedoraNodes.class, uriInfo);
        Variant bestPossibleResponse = request.selectVariant(RDFMediaType.POSSIBLE_SPARQL_RDF_VARIANTS);
        String sparqlQuery = IOUtils.toString((InputStream)requestBodyStream);
        LOGGER.trace("Running SPARQL query: {}", (Object)sparqlQuery);
        JQLConverter jqlConverter = new JQLConverter(this.session, (GraphSubjects)graphSubjects, sparqlQuery);
        LOGGER.trace("Converted to JQL query: {}", (Object)jqlConverter.getStatement());
        ResultSet resultSet = jqlConverter.execute();
        ResultSetStreamingOutput streamingOutput = new ResultSetStreamingOutput(resultSet, bestPossibleResponse.getMediaType());
        Futures.addCallback((ListenableFuture)streamingOutput, (FutureCallback)new LogoutCallback(this.session));
        return Response.ok((Object)((Object)streamingOutput)).build();
    }
}

