/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.transform.http;

import com.codahale.metrics.annotation.Timed;
import com.hp.hpl.jena.query.Dataset;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.PathSegment;
import org.apache.marmotta.ldpath.exception.LDPathParseException;
import org.fcrepo.http.api.FedoraNodes;
import org.fcrepo.http.commons.AbstractResource;
import org.fcrepo.http.commons.api.rdf.HttpGraphSubjects;
import org.fcrepo.http.commons.session.InjectedSession;
import org.fcrepo.kernel.FedoraResource;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.transform.Transformation;
import org.fcrepo.transform.TransformationFactory;
import org.fcrepo.transform.transformations.LDPathTransform;
import org.modeshape.jcr.api.JcrTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Path(value="/{path: .*}/fcr:transform")
public class FedoraTransform
extends AbstractResource {
    @InjectedSession
    protected Session session;
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraTransform.class);
    @Autowired(required=false)
    private TransformationFactory transformationFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void setUpRepositoryConfiguration() throws RepositoryException, IOException {
        if (this.transformationFactory == null) {
            this.transformationFactory = new TransformationFactory();
        }
        Session internalSession = this.sessions.getInternalSession();
        try {
            JcrTools jcrTools = new JcrTools(true);
            jcrTools.registerNodeTypes(internalSession, "ldpath.cnd");
            jcrTools.findOrCreateNode(internalSession, "/fedora:system/fedora:transform", "fedora:configuration", "fedora:node_type_configuration");
            Node node = jcrTools.findOrCreateNode(internalSession, "/fedora:system/fedora:transform/fedora:ldpath/default", "{http://www.jcp.org/jcr/nt/1.0}folder", "{http://www.jcp.org/jcr/nt/1.0}folder");
            LOGGER.debug("Transforming node: {}", (Object)node.getPath());
            if (!node.hasNode("{http://www.jcp.org/jcr/nt/1.0}base")) {
                Node baseConfig = node.addNode("{http://www.jcp.org/jcr/nt/1.0}base", "{http://www.jcp.org/jcr/nt/1.0}file");
                jcrTools.uploadFile(internalSession, baseConfig.getPath(), ((Object)((Object)this)).getClass().getResourceAsStream("/ldpath/default/nt_base_ldpath_program.txt"));
            }
            internalSession.save();
        }
        finally {
            internalSession.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{program}")
    @Produces(value={"application/json"})
    @Timed
    public Object evaluateLdpathProgram(@PathParam(value="path") List<PathSegment> pathList, @PathParam(value="program") String program) throws RepositoryException, LDPathParseException {
        try {
            String path = FedoraTransform.toPath(pathList);
            FedoraResource object = this.nodeService.getObject(this.session, path);
            LDPathTransform t = LDPathTransform.getNodeTypeTransform(object.getNode(), program);
            Dataset propertiesDataset = object.getPropertiesDataset((GraphSubjects)new HttpGraphSubjects(this.session, FedoraNodes.class, this.uriInfo));
            Object object2 = t.apply(propertiesDataset);
            return object2;
        }
        finally {
            this.session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/rdf+ldpath", "application/sparql-query"})
    @Produces(value={"application/json", "text/tab-separated-values", "text/csv", "text/sse", "text/plain", "application/sparql-results+json", "application/sparql-results+xml", "application/sparql-results+bio", "text/turtle", "text/rdf+n3", "application/n-triples", "application/rdf+xml"})
    @Timed
    public Object evaluateTransform(@PathParam(value="path") List<PathSegment> pathList, @HeaderParam(value="Content-Type") MediaType contentType, InputStream requestBodyStream) throws RepositoryException, LDPathParseException {
        try {
            String path = FedoraTransform.toPath(pathList);
            FedoraResource object = this.nodeService.getObject(this.session, path);
            Dataset propertiesDataset = object.getPropertiesDataset((GraphSubjects)new HttpGraphSubjects(this.session, FedoraNodes.class, this.uriInfo));
            Transformation t = this.transformationFactory.getTransform(contentType, requestBodyStream);
            Object object2 = t.apply(propertiesDataset);
            return object2;
        }
        finally {
            this.session.logout();
        }
    }
}

