/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.transform.sparql;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryVisitor;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.core.TriplePath;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprAggregator;
import com.hp.hpl.jena.sparql.expr.ExprFunction0;
import com.hp.hpl.jena.sparql.expr.ExprFunction1;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.ExprFunction3;
import com.hp.hpl.jena.sparql.expr.ExprFunctionN;
import com.hp.hpl.jena.sparql.expr.ExprFunctionOp;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.FunctionLabel;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementAssign;
import com.hp.hpl.jena.sparql.syntax.ElementBind;
import com.hp.hpl.jena.sparql.syntax.ElementData;
import com.hp.hpl.jena.sparql.syntax.ElementDataset;
import com.hp.hpl.jena.sparql.syntax.ElementExists;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementMinus;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementNotExists;
import com.hp.hpl.jena.sparql.syntax.ElementOptional;
import com.hp.hpl.jena.sparql.syntax.ElementPathBlock;
import com.hp.hpl.jena.sparql.syntax.ElementService;
import com.hp.hpl.jena.sparql.syntax.ElementSubQuery;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementUnion;
import com.hp.hpl.jena.sparql.syntax.ElementVisitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.QueryManager;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.JoinCondition;
import javax.jcr.query.qom.Literal;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import org.apache.commons.lang.NotImplementedException;
import org.fcrepo.kernel.rdf.JcrRdfTools;
import org.fcrepo.kernel.utils.NodePropertiesTools;
import org.fcrepo.transform.exception.JQLParsingException;
import org.modeshape.common.collection.Collections;
import org.modeshape.jcr.api.query.qom.Limit;
import org.modeshape.jcr.api.query.qom.SelectQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JQLQueryVisitor
implements QueryVisitor,
ElementVisitor,
ExprVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JQLQueryVisitor.class);
    private QueryObjectModelFactory queryFactory;
    private Source source;
    private ImmutableSet.Builder<Column> columns;
    private ImmutableList.Builder<Ordering> orderings;
    private Constraint constraint;
    private boolean hasLimit = false;
    private long offset;
    private long limit;
    private Session session;
    private JcrRdfTools jcrTools;
    private Set<String> resultsVars;
    private Map<String, Column> variables;
    private boolean distinct;
    private boolean inOptional;
    private Map<String, Source> joins;
    private Map<String, String> joinTypes;
    private Map<String, JoinCondition> joinConditions;
    private NodePropertiesTools propertiesTools = new NodePropertiesTools();

    public JQLQueryVisitor(Session session, JcrRdfTools jcrTools, QueryManager queryManager) throws RepositoryException {
        this.session = session;
        this.jcrTools = jcrTools;
        this.queryFactory = queryManager.getQOMFactory();
        this.constraint = null;
        this.variables = new HashMap<String, Column>();
        this.joins = new HashMap<String, Source>();
        this.joinTypes = new HashMap<String, String>();
        this.joinConditions = new HashMap<String, JoinCondition>();
    }

    public JQLQueryVisitor(JQLQueryVisitor jqlQueryVisitor) {
        this.session = jqlQueryVisitor.session;
        this.jcrTools = jqlQueryVisitor.jcrTools;
        this.queryFactory = jqlQueryVisitor.queryFactory;
        this.constraint = null;
        this.variables = jqlQueryVisitor.variables;
        this.joins = jqlQueryVisitor.joins;
        this.joinConditions = jqlQueryVisitor.joinConditions;
    }

    public QueryObjectModel getQuery() throws RepositoryException {
        org.modeshape.jcr.api.query.qom.QueryObjectModelFactory modeQueryFactory = (org.modeshape.jcr.api.query.qom.QueryObjectModelFactory)this.queryFactory;
        int actualLimit = this.hasLimit ? Ints.checkedCast((long)this.limit) : Integer.MAX_VALUE;
        Limit selectLimit = modeQueryFactory.limit(actualLimit, Ints.checkedCast((long)this.offset));
        SelectQuery query = modeQueryFactory.select(this.getSource(), this.getConstraint(), this.getOrderings(), this.getColumns(), selectLimit, this.distinct);
        return modeQueryFactory.createQuery(query);
    }

    private Source getSource() {
        Source parentSource;
        Sets.SetView difference = Sets.difference(this.joins.keySet(), this.joinConditions.keySet());
        Iterator unmatchedJoins = difference.iterator();
        if (!unmatchedJoins.hasNext()) {
            throw new JQLParsingException("No primary source column found in query");
        }
        this.source = parentSource = this.joins.get(unmatchedJoins.next());
        try {
            for (Map.Entry<String, Source> entry : this.joins.entrySet()) {
                if (entry.getValue() == parentSource) continue;
                String joinType = this.joinTypes.containsKey(entry.getKey()) ? "jcr.join.type.inner" : "jcr.join.type.left.outer";
                this.source = this.queryFactory.join(this.source, entry.getValue(), joinType, this.joinConditions.get(entry.getKey()));
            }
        }
        catch (RepositoryException e) {
            LOGGER.info("Repository exception building query source", (Throwable)e);
        }
        return this.source;
    }

    private Column[] getColumns() {
        ImmutableSet build = this.columns.build();
        return (Column[])build.toArray((Object[])new Column[build.size()]);
    }

    private Ordering[] getOrderings() {
        ImmutableList build = this.orderings.build();
        return (Ordering[])build.toArray((Object[])new Ordering[build.size()]);
    }

    private Constraint getConstraint() {
        return this.constraint;
    }

    public void startVisit(Query query) {
        LOGGER.trace("START VISIT: {}", (Object)query);
        this.columns = new ImmutableSet.Builder();
        this.orderings = new ImmutableList.Builder();
    }

    public void visitPrologue(Prologue prologue) {
        LOGGER.trace("VISIT PROLOGUE: {}", (Object)prologue);
    }

    public void visitResultForm(Query query) {
        LOGGER.trace("VISIT RESULT FORM: {}", (Object)query);
    }

    public void visitSelectResultForm(Query query) {
        LOGGER.trace("VISIT SELECT RESULT FORM: {}", (Object)query.getResultVars());
        this.resultsVars = Collections.unmodifiableSet((Collection)query.getResultVars());
        this.distinct = query.isDistinct();
    }

    public void visitConstructResultForm(Query query) {
        LOGGER.trace("VISIT CONSTRUCT RESULT FORM: {}", (Object)query);
    }

    public void visitDescribeResultForm(Query query) {
        LOGGER.trace("VISIT DESCRIBE RESULT FORM: {}", (Object)query);
    }

    public void visitAskResultForm(Query query) {
        LOGGER.trace("VISIT ASK RESULT FORM: {}", (Object)query);
    }

    public void visitDatasetDecl(Query query) {
        if (query.hasDatasetDescription()) {
            LOGGER.trace("VISIT DATASET DESC FORM: {}", (Object)query.getDatasetDescription());
        }
    }

    public void visitQueryPattern(Query query) {
        LOGGER.trace("VISIT QUERY PATTERN: {}", (Object)query.getQueryPattern());
        Element queryPattern = query.getQueryPattern();
        queryPattern.visit((ElementVisitor)this);
    }

    public void visitGroupBy(Query query) {
        if (query.hasGroupBy()) {
            LOGGER.trace("VISIT GROUP BY: {}", (Object)query.getGroupBy());
            throw new NotImplementedException("GROUP BY");
        }
    }

    public void visitHaving(Query query) {
        if (query.hasHaving()) {
            LOGGER.trace("VISIT HAVING: {}", (Object)query.getHavingExprs());
            throw new NotImplementedException("HAVING");
        }
    }

    public void visitOrderBy(Query query) {
        if (query.hasOrderBy()) {
            LOGGER.trace("VISIT ORDER BY: {}", (Object)query.getOrderBy());
            try {
                for (SortCondition sortCondition : query.getOrderBy()) {
                    PropertyValue property;
                    Expr expression = sortCondition.getExpression();
                    if (expression.isConstant()) {
                        property = this.queryFactory.propertyValue("fedora:resource", expression.getConstant().asString());
                    } else if (expression.isVariable()) {
                        Column c = this.variables.get(expression.getVarName());
                        property = this.queryFactory.propertyValue(c.getSelectorName(), c.getPropertyName());
                    } else {
                        property = null;
                    }
                    if (property != null) {
                        Ordering ordering = sortCondition.getDirection() == -1 ? this.queryFactory.descending((DynamicOperand)property) : this.queryFactory.ascending((DynamicOperand)property);
                        this.orderings.add((Object)ordering);
                        continue;
                    }
                    LOGGER.debug("IGNORING UNKNOWN ORDER CONDITION {}", (Object)sortCondition);
                }
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public void visitLimit(Query query) {
        if (query.hasLimit()) {
            LOGGER.trace("VISIT LIMIT: {}", (Object)query.getLimit());
            this.hasLimit = true;
            this.limit = query.getLimit();
        }
    }

    public void visitOffset(Query query) {
        if (query.hasOffset()) {
            LOGGER.trace("VISIT OFFSET: {}", (Object)query.getOffset());
            this.offset = query.getOffset();
        }
    }

    public void visitValues(Query query) {
        if (query.hasValues()) {
            LOGGER.trace("VISIT VALUES: {}", (Object)query.getValuesData());
            throw new NotImplementedException("VALUES");
        }
    }

    public void finishVisit(Query query) {
        LOGGER.trace("FINISH VISIT: {}", (Object)query);
    }

    public void visit(ElementTriplesBlock el) {
        LOGGER.trace("VISIT TRIPLES: {}", (Object)el);
        Iterator tripleIterator = el.patternElts();
        while (tripleIterator.hasNext()) {
            Triple next = (Triple)tripleIterator.next();
            next.getObject();
        }
    }

    public void visit(ElementPathBlock el) {
        LOGGER.trace("VISIT PATH BLOCK: {}", (Object)el);
        Iterator triplePathIterator = el.patternElts();
        try {
            Node subject;
            TriplePath next;
            while (triplePathIterator.hasNext()) {
                next = (TriplePath)triplePathIterator.next();
                subject = next.getSubject();
                if (!subject.isVariable()) continue;
                String selectorName = "fedoraResource_" + subject.getName();
                this.joins.put(subject.getName(), (Source)this.queryFactory.selector("fedora:resource", selectorName));
                Column c = this.queryFactory.column(selectorName, "jcr:path", subject.getName());
                this.variables.put(subject.getName(), c);
            }
            triplePathIterator = el.patternElts();
            while (triplePathIterator.hasNext()) {
                next = (TriplePath)triplePathIterator.next();
                LOGGER.trace(" - TRIPLE PATH: {}", (Object)next);
                subject = next.getSubject();
                Node predicate = next.getPredicate();
                Node object = next.getObject();
                Model defaultModel = ModelFactory.createDefaultModel();
                if (subject.isVariable()) {
                    Column c = this.variables.get(subject.getName());
                    if (this.resultsVars.contains(subject.getName())) {
                        this.columns.add((Object)c);
                    }
                    if (predicate.isVariable()) {
                        throw new NotImplementedException("Element path may not contain a variable predicate");
                    }
                    String propertyName = this.jcrTools.getPropertyNameFromPredicate(defaultModel.createProperty(predicate.getURI()));
                    if (propertyName.equals("rdf:type") && object.isURI()) {
                        String mixinName = this.jcrTools.getPropertyNameFromPredicate(defaultModel.createProperty(object.getURI()));
                        if (this.session.getWorkspace().getNodeTypeManager().hasNodeType(mixinName)) {
                            String selectorName = "ref_type_" + mixinName.replace(":", "_");
                            this.joins.put(selectorName, (Source)this.queryFactory.selector(mixinName, selectorName));
                            this.joinTypes.put(selectorName, "jcr.join.type.inner");
                            this.joinConditions.put(selectorName, (JoinCondition)this.queryFactory.sameNodeJoinCondition(c.getSelectorName(), selectorName, "."));
                            continue;
                        }
                    }
                    int propertyType = this.jcrTools.getPropertyType("fedora:resource", propertyName);
                    if (object.isVariable()) {
                        Column objectColumn;
                        if ((propertyType == 9 || propertyType == 10 || propertyType == 11) && this.variables.containsKey(object.getName())) {
                            objectColumn = this.variables.get(object.getName());
                            String joinPropertyName = propertyType == 11 ? this.propertiesTools.getReferencePropertyName(propertyName) : propertyName;
                            this.joinConditions.put(object.getName(), (JoinCondition)this.queryFactory.equiJoinCondition(c.getSelectorName(), joinPropertyName, objectColumn.getSelectorName(), "jcr:uuid"));
                        } else {
                            objectColumn = this.queryFactory.column(c.getSelectorName(), propertyName, object.getName());
                            this.variables.put(object.getName(), objectColumn);
                            if (this.resultsVars.contains(object.getName())) {
                                this.columns.add((Object)objectColumn);
                            }
                        }
                        if (this.inOptional) continue;
                        this.appendConstraint((Constraint)this.queryFactory.propertyExistence(c.getSelectorName(), propertyName));
                        continue;
                    }
                    if (this.inOptional) continue;
                    PropertyValue field = this.queryFactory.propertyValue(c.getSelectorName(), propertyName);
                    Value jcrValue = this.jcrTools.createValue(defaultModel.asRDFNode(object), propertyType);
                    Literal literal = this.queryFactory.literal(jcrValue);
                    this.appendConstraint((Constraint)this.queryFactory.comparison((DynamicOperand)field, "jcr.operator.equal.to", (StaticOperand)literal));
                    continue;
                }
                if (predicate.isVariable()) {
                    throw new NotImplementedException("Element path with constant subject and variable predicate");
                }
                if (object.isVariable()) {
                    throw new NotImplementedException("Element path with constant subject and predicate, and a variable object");
                }
                throw new NotImplementedException("Element path with constant subject/predicate/object");
            }
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void visit(ElementFilter el) {
        LOGGER.trace("VISIT FILTER: {}", (Object)el);
        el.getExpr().visit((ExprVisitor)this);
    }

    public void visit(ElementAssign el) {
        LOGGER.trace("VISIT ASSIGN: {}", (Object)el);
        throw new NotImplementedException("ASSIGN");
    }

    public void visit(ElementBind el) {
        LOGGER.trace("VISIT BIND: {}", (Object)el);
        throw new NotImplementedException("BIND");
    }

    public void visit(ElementData el) {
        LOGGER.trace("VISIT DATA: {}", (Object)el);
        throw new NotImplementedException("DATA");
    }

    public void visit(ElementUnion el) {
        LOGGER.trace("VISIT UNION: {}", (Object)el);
        throw new NotImplementedException("UNION");
    }

    public void visit(ElementOptional el) {
        LOGGER.trace("VISIT OPTIONAL: {}", (Object)el);
        this.inOptional = true;
        el.getOptionalElement().visit((ElementVisitor)this);
        this.inOptional = false;
    }

    public void visit(ElementGroup el) {
        LOGGER.trace("VISIT GROUP: {}", (Object)el);
        for (Element element : el.getElements()) {
            element.visit((ElementVisitor)this);
        }
    }

    public void visit(ElementDataset el) {
        LOGGER.trace("VISIT DATASET: {}", (Object)el);
        throw new NotImplementedException("DATASET");
    }

    public void visit(ElementNamedGraph el) {
        LOGGER.trace("VISIT NAMED GRAPH: {}", (Object)el);
        throw new NotImplementedException("NAMED GRAPH");
    }

    public void visit(ElementExists el) {
        LOGGER.trace("VISIT EXISTS: {}", (Object)el);
        throw new NotImplementedException("EXISTS");
    }

    public void visit(ElementNotExists el) {
        LOGGER.trace("VISIT NOT EXISTS: {}", (Object)el);
        throw new NotImplementedException("NOT EXISTS");
    }

    public void visit(ElementMinus el) {
        LOGGER.trace("VISIT MINUS: {}", (Object)el);
        throw new NotImplementedException("MINUS");
    }

    public void visit(ElementService el) {
        LOGGER.trace("VISIT SERVICE: {}", (Object)el);
        throw new NotImplementedException("SERVICE");
    }

    public void visit(ElementSubQuery el) {
        LOGGER.trace("VISIT SUBQUERY: {}", (Object)el);
        throw new NotImplementedException("SUB QUERY");
    }

    public void startVisit() {
    }

    public void visit(ExprFunction0 func) {
        LOGGER.trace("VISIT EXPRFUNCTION0: {}", (Object)func);
    }

    public void visit(ExprFunction1 func) {
        LOGGER.trace("VISIT EXPRFUNCTION1: {}", (Object)func);
        String funcName = func.getFunctionSymbol().getSymbol().toLowerCase();
        try {
            switch (funcName) {
                case "not": {
                    JQLQueryVisitor subVisitor1 = new JQLQueryVisitor(this);
                    func.getArg().visit((ExprVisitor)subVisitor1);
                    this.appendConstraint((Constraint)this.queryFactory.not(subVisitor1.getConstraint()));
                    break;
                }
                case "bound": {
                    Column column = this.variables.get(func.getArg().getVarName());
                    this.appendConstraint((Constraint)this.queryFactory.propertyExistence(column.getSelectorName(), column.getPropertyName()));
                    break;
                }
                default: {
                    throw new NotImplementedException(funcName);
                }
            }
        }
        catch (RepositoryException e) {
            LOGGER.info("Got exception visiting ExprFunction1 method {}", (Object)funcName, (Object)e);
        }
    }

    public void visit(ExprFunction2 func) {
        LOGGER.trace("VISIT EXPRFUNCTION2: {}", (Object)func);
        String funcName = func.getFunctionSymbol().getSymbol().toLowerCase();
        try {
            if (funcName.equals("and") || funcName.equals("or")) {
                JQLQueryVisitor subVisitor1 = new JQLQueryVisitor(this);
                func.getArg1().visit((ExprVisitor)subVisitor1);
                JQLQueryVisitor subVisitor2 = new JQLQueryVisitor(this);
                func.getArg2().visit((ExprVisitor)subVisitor2);
                switch (funcName) {
                    case "and": {
                        this.appendConstraint((Constraint)this.queryFactory.and(subVisitor1.getConstraint(), subVisitor2.getConstraint()));
                        break;
                    }
                    case "or": {
                        this.appendConstraint((Constraint)this.queryFactory.or(subVisitor1.getConstraint(), subVisitor2.getConstraint()));
                        break;
                    }
                    default: {
                        throw new NotImplementedException(funcName);
                    }
                }
            } else {
                String op;
                if (!func.getArg2().isConstant()) {
                    throw new NotImplementedException("EXPRFUNCTION2 2nd argument must be a constant: " + func.getArg1() + "; " + func.getArg2());
                }
                String value = func.getArg2().getConstant().getString();
                switch (funcName) {
                    case "eq": {
                        op = "jcr.operator.equal.to";
                        break;
                    }
                    case "ge": {
                        op = "jcr.operator.greater.than.or.equal.to";
                        break;
                    }
                    case "le": {
                        op = "jcr.operator.less.than.or.equal.to";
                        break;
                    }
                    case "lt": {
                        op = "jcr.operator.less.than";
                        break;
                    }
                    case "gt": {
                        op = "jcr.operator.greater.than";
                        break;
                    }
                    case "ne": {
                        op = "jcr.operator.not.equal.to";
                        break;
                    }
                    case "contains": {
                        op = "jcr.operator.like";
                        value = "%" + value + "%";
                        break;
                    }
                    case "strstarts": {
                        op = "jcr.operator.like";
                        value = value + "%";
                        break;
                    }
                    case "strends": {
                        op = "jcr.operator.like";
                        value = "%" + value;
                        break;
                    }
                    default: {
                        throw new NotImplementedException(funcName);
                    }
                }
                this.appendConstraint((Constraint)this.queryFactory.comparison((DynamicOperand)this.getPropertyValue(func.getArg1()), op, (StaticOperand)this.queryFactory.literal(this.getValue(value))));
            }
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void visit(ExprFunction3 func) {
        LOGGER.trace("VISIT EXPRFUNCTION3: {}", (Object)func);
    }

    public void visit(ExprFunctionN func) {
        LOGGER.trace("VISIT EXPRFUNCTIONN: {}", (Object)func);
        try {
            Expr expr;
            FunctionLabel functionSymbol = func.getFunctionSymbol();
            List args = func.getArgs();
            String symbol = functionSymbol.getSymbol().toLowerCase();
            if (symbol.equals("regex")) {
                expr = (Expr)args.get(0);
                if (!expr.isVariable()) {
                    throw new NotImplementedException("ExprFunctionN " + symbol);
                }
            } else {
                throw new NotImplementedException("ExprFunctionN " + symbol);
            }
            this.appendConstraint((Constraint)this.queryFactory.comparison((DynamicOperand)this.getPropertyValue(expr), "jcr.operator.like", (StaticOperand)this.queryFactory.literal(this.getValue((Expr)args.get(1)))));
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void visit(ExprFunctionOp funcOp) {
        LOGGER.trace("VISIT EXPRFUNCTIONOp: {}", (Object)funcOp);
    }

    public void visit(NodeValue nv) {
        LOGGER.trace("VISIT NODEVALUE: {}", (Object)nv);
    }

    public void visit(ExprVar nv) {
        LOGGER.trace("VISIT EXPRVAR: {}", (Object)nv);
    }

    public void visit(ExprAggregator eAgg) {
        LOGGER.trace("VISIT EXPRAGGREGATOR: {}", (Object)eAgg);
    }

    public void finishVisit() {
    }

    private PropertyValue getPropertyValue(Column column) {
        try {
            return this.queryFactory.propertyValue(column.getSelectorName(), column.getPropertyName());
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private PropertyValue getPropertyValue(Expr expr) {
        return this.getPropertyValue(this.variables.get(expr.getVarName()));
    }

    private Value getValue(Expr e) throws RepositoryException {
        return this.getValue(e.getConstant().asString());
    }

    private Value getValue(String e) throws RepositoryException {
        return this.session.getValueFactory().createValue(e);
    }

    private void appendConstraint(Constraint c) throws RepositoryException {
        this.constraint = this.constraint == null ? c : this.queryFactory.and(this.constraint, c);
    }
}

