/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.transform.http.responses;

import com.google.common.util.concurrent.AbstractFuture;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.resultset.ResultsFormat;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.StreamingOutput;
import org.fcrepo.http.commons.responses.GraphStoreStreamingOutput;

public class ResultSetStreamingOutput
extends AbstractFuture<Void>
implements StreamingOutput {
    private final ResultSet results;
    private final MediaType mediaType;
    private static final Void finishedMarker = null;

    public ResultSetStreamingOutput(ResultSet results, MediaType mediaType) {
        this.mediaType = mediaType;
        this.results = results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream entityStream) throws IOException {
        ResultsFormat resultsFormat = ResultSetStreamingOutput.getResultsFormat(this.mediaType);
        try {
            if (resultsFormat == ResultsFormat.FMT_UNKNOWN) {
                new GraphStoreStreamingOutput(DatasetFactory.create((Model)ResultSetFormatter.toModel((ResultSet)this.results)), this.mediaType).write(entityStream);
            } else {
                ResultSetFormatter.output((OutputStream)entityStream, (ResultSet)this.results, (ResultsFormat)resultsFormat);
            }
        }
        finally {
            this.set(finishedMarker);
        }
    }

    public static ResultsFormat getResultsFormat(MediaType mediaType) {
        switch (mediaType.toString()) {
            case "text/tab-separated-values": {
                return ResultsFormat.FMT_RS_TSV;
            }
            case "text/csv": {
                return ResultsFormat.FMT_RS_CSV;
            }
            case "text/sse": {
                return ResultsFormat.FMT_RS_SSE;
            }
            case "text/plain": {
                return ResultsFormat.FMT_TEXT;
            }
            case "application/sparql-results+json": {
                return ResultsFormat.FMT_RS_JSON;
            }
            case "application/sparql-results+xml": {
                return ResultsFormat.FMT_RS_XML;
            }
            case "application/sparql-results+bio": {
                return ResultsFormat.FMT_RS_BIO;
            }
            case "text/turtle": 
            case "application/turtle": 
            case "application/x-turtle": {
                return ResultsFormat.FMT_RDF_TTL;
            }
            case "text/rdf+n3": 
            case "application/n3": 
            case "text/n3": {
                return ResultsFormat.FMT_RDF_N3;
            }
            case "application/n-triples": {
                return ResultsFormat.FMT_RDF_NT;
            }
            case "application/rdf+xml": {
                return ResultsFormat.FMT_RDF_XML;
            }
        }
        return ResultsFormat.FMT_UNKNOWN;
    }
}

