/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.transform;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.fcrepo.transform.Transformation;
import org.fcrepo.transform.transformations.LDPathTransform;
import org.fcrepo.transform.transformations.SparqlQueryTransform;

public class TransformationFactory {
    private Map<String, Transformation<?>> mimeToTransform = new HashMap();

    public TransformationFactory() {
        this.mimeToTransform.put("application/sparql-query", new SparqlQueryTransform(null));
        this.mimeToTransform.put("application/rdf+ldpath", new LDPathTransform(null));
    }

    public <T> Transformation<T> getTransform(MediaType contentType, InputStream inputStream) {
        String mimeType = contentType.toString();
        if (this.mimeToTransform.containsKey(mimeType)) {
            return this.mimeToTransform.get(contentType.toString()).newTransform(inputStream);
        }
        throw new UnsupportedOperationException("No transform type exists for media type " + mimeType + "!");
    }
}

