/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.transform.http;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.hp.hpl.jena.query.ResultSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.apache.commons.io.IOUtils;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.fcrepo.http.api.FedoraNodes;
import org.fcrepo.http.commons.AbstractResource;
import org.fcrepo.http.commons.api.rdf.HttpIdentifierTranslator;
import org.fcrepo.http.commons.domain.RDFMediaType;
import org.fcrepo.http.commons.responses.ViewHelpers;
import org.fcrepo.http.commons.session.InjectedSession;
import org.fcrepo.kernel.impl.rdf.impl.NamespaceRdfContext;
import org.fcrepo.kernel.impl.utils.LogoutCallback;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.transform.http.responses.ResultSetStreamingOutput;
import org.fcrepo.transform.sparql.JQLConverter;
import org.fcrepo.transform.sparql.SparqlServiceDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Path(value="/fcr:sparql")
public class FedoraSparql
extends AbstractResource {
    @InjectedSession
    protected Session session;
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraSparql.class);

    @GET
    @Timed
    @Produces(value={"application/rdf+xml", "text/turtle", "text/rdf+n3", "text/n3", "application/n-triples", "text/plain", "application/xml", "application/x-turtle", "application/ld+json"})
    public Response sparqlServiceDescription(@Context Request request, @Context UriInfo uriInfo) throws IOException {
        Lang tmpLang;
        final SparqlServiceDescription sd = new SparqlServiceDescription(this.session, uriInfo);
        Variant bestPossibleResponse = request.selectVariant(RDFMediaType.POSSIBLE_RDF_VARIANTS);
        LOGGER.debug("Getting sparql service description with media type {} ...", (Object)bestPossibleResponse);
        if (bestPossibleResponse == null || (tmpLang = RDFLanguages.contentTypeToLang((String)bestPossibleResponse.getMediaType().toString())) == null) {
            tmpLang = RDFLanguages.RDFXML;
        }
        final Lang rdfLang = tmpLang;
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream output) throws IOException {
                LOGGER.debug("Writting sparql service description with jena RdfLanguages name {}.", (Object)rdfLang.getName());
                OutputStreamWriter outWriter = new OutputStreamWriter(output);
                sd.createServiceDescription().asModel().write((Writer)outWriter, rdfLang.getName());
            }
        };
        return Response.ok((Object)stream).header("Content-Type", (Object)rdfLang.getContentType().getContentType()).build();
    }

    @GET
    @Timed
    @Produces(value={"text/html"})
    public Response sparqlQueryForm() throws IOException, RepositoryException {
        Properties properties = new Properties();
        URL propertiesUrl = ((Object)((Object)this)).getClass().getResource("/velocity.properties");
        VelocityEngine velocity = new VelocityEngine();
        LOGGER.debug("Using Velocity configuration from {}", (Object)propertiesUrl);
        try (InputStream propertiesStream = propertiesUrl.openStream();){
            properties.load(propertiesStream);
        }
        velocity.init(properties);
        final Template template = velocity.getTemplate("/views/search-sparql.vsl");
        VelocityContext context = new VelocityContext();
        context.put("uriInfo", (Object)this.uriInfo);
        context.put("model", (Object)new NamespaceRdfContext(this.session).asModel());
        context.put("helpers", (Object)ViewHelpers.getInstance());
        StreamingOutput stream = new StreamingOutput((org.apache.velocity.context.Context)context){
            final /* synthetic */ org.apache.velocity.context.Context val$context;
            {
                this.val$context = context;
            }

            public void write(OutputStream output) throws IOException {
                OutputStreamWriter outWriter = new OutputStreamWriter(output);
                template.merge(this.val$context, (Writer)outWriter);
                ((Writer)outWriter).flush();
            }
        };
        return Response.ok((Object)stream).build();
    }

    @POST
    @Produces(value={"text/tab-separated-values", "text/csv", "text/sse", "text/plain", "application/sparql-results+json", "application/sparql-results+xml", "application/sparql-results+bio", "text/turtle", "text/rdf+n3", "application/n-triples", "application/rdf+xml"})
    public Response runSparqlQuery(InputStream requestBodyStream, @Context Request request, @Context UriInfo uriInfo) throws IOException, RepositoryException {
        HttpIdentifierTranslator graphSubjects = new HttpIdentifierTranslator(this.session, FedoraNodes.class, uriInfo);
        Variant bestPossibleResponse = request.selectVariant(RDFMediaType.POSSIBLE_SPARQL_RDF_VARIANTS);
        String sparqlQuery = IOUtils.toString((InputStream)requestBodyStream);
        return this.rexecSparql(sparqlQuery, bestPossibleResponse, (IdentifierTranslator)graphSubjects);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/tab-separated-values", "text/csv", "text/sse", "text/plain", "application/sparql-results+json", "application/sparql-results+xml", "application/sparql-results+bio", "text/turtle", "text/rdf+n3", "application/n-triples", "application/rdf+xml"})
    public Response runSparqlQuery(@FormParam(value="query") String query, @Context Request request, @Context UriInfo uriInfo) throws IOException, RepositoryException {
        LOGGER.trace("POST SPARQL query with {}: {}", (Object)"application/x-www-form-urlencoded", (Object)query);
        if (Strings.isNullOrEmpty((String)query)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"SPARQL must not be null. Please submit a query with parameter 'query'.").build();
        }
        return this.rexecSparql(query, request.selectVariant(RDFMediaType.POSSIBLE_SPARQL_RDF_VARIANTS), (IdentifierTranslator)new HttpIdentifierTranslator(this.session, FedoraNodes.class, uriInfo));
    }

    private Response rexecSparql(String sparql, Variant bestPossibleResponse, IdentifierTranslator graphSubjects) throws RepositoryException {
        LOGGER.trace("Running SPARQL query: {}", (Object)sparql);
        JQLConverter jqlConverter = new JQLConverter(this.session, graphSubjects, sparql);
        LOGGER.trace("Converted to JQL query: {}", (Object)jqlConverter.getStatement());
        ResultSet resultSet = jqlConverter.execute();
        ResultSetStreamingOutput streamingOutput = new ResultSetStreamingOutput(resultSet, bestPossibleResponse.getMediaType());
        Futures.addCallback((ListenableFuture)streamingOutput, (FutureCallback)new LogoutCallback(this.session));
        return Response.ok((Object)((Object)streamingOutput)).build();
    }
}

