/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.transform.sparql;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryVisitor;
import com.hp.hpl.jena.query.ResultSet;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.QueryObjectModel;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.fcrepo.transform.sparql.JQLQueryVisitor;
import org.fcrepo.transform.sparql.JQLResultSet;

public class JQLConverter {
    private final JcrRdfTools jcrTools;
    private Session session;
    private IdentifierTranslator subjects;
    private Query query;

    public JQLConverter(Session session, IdentifierTranslator subjects, String sparqlQuery) {
        this(session, subjects, QueryFactory.create((String)sparqlQuery));
    }

    public JQLConverter(Session session, IdentifierTranslator subjects, Query query) {
        this.session = session;
        this.subjects = subjects;
        this.query = query;
        this.jcrTools = new JcrRdfTools(subjects, session);
    }

    public ResultSet execute() throws RepositoryException {
        QueryResult queryResult = this.getQuery().execute();
        return new JQLResultSet(this.session, this.subjects, queryResult);
    }

    public String getStatement() throws RepositoryException {
        return this.getQuery().getStatement();
    }

    private QueryObjectModel getQuery() throws RepositoryException {
        QueryManager queryManager = this.session.getWorkspace().getQueryManager();
        JQLQueryVisitor jqlVisitor = new JQLQueryVisitor(this.session, this.jcrTools, queryManager, this.subjects);
        this.query.visit((QueryVisitor)jqlVisitor);
        return jqlVisitor.getQuery();
    }
}

