/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.transform.sparql;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import java.util.Iterator;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.fcrepo.kernel.rdf.IdentifierTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JQLResultSet
implements ResultSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(JQLResultSet.class);
    private final RowIterator iterator;
    private Session session;
    private IdentifierTranslator subjects;
    private QueryResult queryResult;
    private int rowNumber = 0;

    public JQLResultSet(Session session, IdentifierTranslator subjects, QueryResult queryResult) throws RepositoryException {
        this.session = session;
        this.subjects = subjects;
        this.queryResult = queryResult;
        this.iterator = queryResult.getRows();
    }

    public QueryResult getQueryResult() {
        return this.queryResult;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public QuerySolution next() {
        ++this.rowNumber;
        JQLQuerySolution jqlQuerySolution = new JQLQuerySolution(this.subjects, this.iterator.nextRow(), this.getResultVars());
        LOGGER.trace("Getting QuerySolution (#{}): {}", (Object)this.rowNumber, (Object)jqlQuerySolution);
        return jqlQuerySolution;
    }

    public QuerySolution nextSolution() {
        return this.next();
    }

    public Binding nextBinding() {
        return (Binding)this.next();
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public List<String> getResultVars() {
        try {
            return ImmutableList.copyOf((Object[])this.queryResult.getColumnNames());
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Model getResourceModel() {
        return null;
    }

    private class JQLQuerySolution
    implements QuerySolution,
    Binding {
        private IdentifierTranslator subjects;
        private Row row;
        private List<String> columns;

        public JQLQuerySolution(IdentifierTranslator subjects, Row row, List<String> columns) {
            this.subjects = subjects;
            this.row = row;
            this.columns = columns;
        }

        public RDFNode get(String varName) {
            try {
                return this.getRDFNode(this.row.getValue(varName));
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public Resource getResource(String varName) {
            return this.get(varName).asResource();
        }

        public Literal getLiteral(String varName) {
            return this.get(varName).asLiteral();
        }

        public boolean contains(String varName) {
            try {
                Value value = this.row.getValue(varName);
                return value != null;
            }
            catch (ItemNotFoundException e) {
                LOGGER.trace("Unabel to find var {} in result set", (Object)varName, (Object)e);
                return false;
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public Iterator<String> varNames() {
            return this.columns.iterator();
        }

        public Iterator<Var> vars() {
            return Iterators.transform(this.columns.iterator(), (Function)new Function<String, Var>(){

                public Var apply(String s) {
                    return Var.alloc((String)s);
                }
            });
        }

        public boolean contains(Var var) {
            return this.contains(var.getName());
        }

        public Node get(Var var) {
            return this.get(var.getName()).asNode();
        }

        public int size() {
            return this.columns.size();
        }

        public boolean isEmpty() {
            return this.columns.isEmpty();
        }

        private RDFNode getRDFNode(Value v) {
            try {
                switch (v.getType()) {
                    case 6: {
                        return ResourceFactory.createTypedLiteral((Object)v.getString());
                    }
                    case 5: {
                        return ResourceFactory.createTypedLiteral((Object)v.getDate());
                    }
                    case 12: {
                        return ResourceFactory.createTypedLiteral((Object)v.getDecimal());
                    }
                    case 4: {
                        return ResourceFactory.createTypedLiteral((Object)v.getDouble());
                    }
                    case 3: {
                        return ResourceFactory.createTypedLiteral((Object)v.getLong());
                    }
                    case 11: {
                        return ResourceFactory.createResource((String)v.getString());
                    }
                    case 8: {
                        return this.subjects.getSubject(v.getString());
                    }
                    case 9: 
                    case 10: {
                        return this.subjects.getSubject(JQLResultSet.this.session.getNodeByIdentifier(v.getString()).getPath());
                    }
                }
                return ResourceFactory.createTypedLiteral((Object)v.getString());
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

