/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.transform.sparql;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import javax.jcr.Session;
import javax.ws.rs.core.UriInfo;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.fcrepo.transform.http.FedoraSparql;

public class SparqlServiceDescription {
    private static final String SPARQL_FORMATS_NAMESPACE = "http://www.w3.org/ns/formats/";
    private Session session;
    private UriInfo uriInfo;

    public SparqlServiceDescription(Session session, UriInfo uriInfo) {
        this.session = session;
        this.uriInfo = uriInfo;
    }

    public RdfStream createServiceDescription() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        model.setNsPrefix("sd", "http://www.w3.org/ns/sparql-service-description#");
        Resource s = model.createResource();
        model.add(s, ResourceFactory.createProperty((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFNode)model.createResource("http://www.w3.org/ns/sparql-service-description#Service"));
        model.add(s, RdfLexicon.HAS_SPARQL_ENDPOINT, (RDFNode)model.createResource(this.uriInfo.getBaseUriBuilder().path(FedoraSparql.class).build(new Object[0]).toASCIIString()));
        model.add(s, ResourceFactory.createProperty((String)"http://www.w3.org/ns/sparql-service-description#supportedLanguage"), (RDFNode)model.createResource("http://www.w3.org/ns/sparql-service-description#SPARQL11Query"));
        model.add(s, ResourceFactory.createProperty((String)"http://www.w3.org/ns/sparql-service-description#resultFormat"), (RDFNode)model.createResource("http://www.w3.org/ns/formats/SPARQL_Results_TSV"));
        model.add(s, ResourceFactory.createProperty((String)"http://www.w3.org/ns/sparql-service-description#resultFormat"), (RDFNode)model.createResource("http://www.w3.org/ns/formats/SPARQL_Results_CSV"));
        model.add(s, ResourceFactory.createProperty((String)"http://www.w3.org/ns/sparql-service-description#resultFormat"), (RDFNode)model.createResource("http://www.w3.org/ns/formats/SPARQL_Results_JSON"));
        model.add(s, ResourceFactory.createProperty((String)"http://www.w3.org/ns/sparql-service-description#resultFormat"), (RDFNode)model.createResource("http://www.w3.org/ns/formats/SPARQL_Results_XML"));
        model.add(s, ResourceFactory.createProperty((String)"http://www.w3.org/ns/sparql-service-description#resultFormat"), (RDFNode)model.createResource("http://www.w3.org/ns/formats/Turtle"));
        model.add(s, ResourceFactory.createProperty((String)"http://www.w3.org/ns/sparql-service-description#resultFormat"), (RDFNode)model.createResource("http://www.w3.org/ns/formats/N3"));
        model.add(s, ResourceFactory.createProperty((String)"http://www.w3.org/ns/sparql-service-description#resultFormat"), (RDFNode)model.createResource("http://www.w3.org/ns/formats/N-Triples"));
        model.add(s, ResourceFactory.createProperty((String)"http://www.w3.org/ns/sparql-service-description#resultFormat"), (RDFNode)model.createResource("http://www.w3.org/ns/formats/RDF_XML"));
        model.add(s, ResourceFactory.createProperty((String)"http://www.w3.org/ns/sparql-service-description#feature"), (RDFNode)model.createResource("http://www.w3.org/ns/sparql-service-description#DereferencesURIs"));
        RdfStream rdfStream = RdfStream.fromModel((Model)model);
        rdfStream.session(this.session);
        return rdfStream;
    }
}

