/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.transform.http.responses;

import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.resultset.ResultsFormat;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;

@Provider
@Produces(value={"text/tab-separated-values", "text/csv", "text/sse", "text/plain", "application/sparql-results+json", "application/sparql-results+xml", "application/sparql-results+bio", "text/turtle", "text/rdf+n3", "application/n-triples", "application/rdf+xml"})
public class ResultSetStreamingOutput
implements MessageBodyWriter<ResultSet> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        ResultsFormat resultsFormat = ResultSetStreamingOutput.getResultsFormat(mediaType);
        if (resultsFormat == ResultsFormat.FMT_UNKNOWN) {
            Lang format = RDFLanguages.contentTypeToLang((String)mediaType.toString());
            return format != null;
        }
        return true;
    }

    public long getSize(ResultSet resultSet, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(ResultSet resultSet, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws WebApplicationException {
        ResultsFormat resultsFormat = ResultSetStreamingOutput.getResultsFormat(mediaType);
        if (resultsFormat == ResultsFormat.FMT_UNKNOWN) {
            String format = RDFLanguages.contentTypeToLang((String)mediaType.toString()).getName().toUpperCase();
            Model model = ResultSetFormatter.toModel((ResultSet)resultSet);
            model.write(entityStream, format);
        } else {
            ResultSetFormatter.output((OutputStream)entityStream, (ResultSet)resultSet, (ResultsFormat)resultsFormat);
        }
    }

    public static ResultsFormat getResultsFormat(MediaType mediaType) {
        switch (mediaType.toString()) {
            case "text/tab-separated-values": {
                return ResultsFormat.FMT_RS_TSV;
            }
            case "text/csv": {
                return ResultsFormat.FMT_RS_CSV;
            }
            case "text/sse": {
                return ResultsFormat.FMT_RS_SSE;
            }
            case "text/plain": {
                return ResultsFormat.FMT_TEXT;
            }
            case "application/sparql-results+json": {
                return ResultsFormat.FMT_RS_JSON;
            }
            case "application/sparql-results+xml": {
                return ResultsFormat.FMT_RS_XML;
            }
            case "application/sparql-results+bio": {
                return ResultsFormat.FMT_RS_BIO;
            }
            case "text/turtle": 
            case "application/turtle": 
            case "application/x-turtle": {
                return ResultsFormat.FMT_RDF_TTL;
            }
            case "text/rdf+n3": 
            case "application/n3": 
            case "text/n3": {
                return ResultsFormat.FMT_RDF_N3;
            }
            case "application/n-triples": {
                return ResultsFormat.FMT_RDF_NT;
            }
            case "application/rdf+xml": {
                return ResultsFormat.FMT_RDF_XML;
            }
        }
        return ResultsFormat.FMT_UNKNOWN;
    }
}

