/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.transform.http;

import com.codahale.metrics.annotation.Timed;
import com.google.common.annotations.VisibleForTesting;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.fcrepo.http.api.ContentExposingResource;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.fcrepo.transform.TransformationFactory;
import org.fcrepo.transform.transformations.LDPathTransform;
import org.jvnet.hk2.annotations.Optional;
import org.modeshape.jcr.api.JcrTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;

@Scope(value="request")
@Path(value="/{path: .*}/fcr:transform")
public class FedoraTransform
extends ContentExposingResource {
    @Inject
    protected Session session;
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraTransform.class);
    @Inject
    @Optional
    private TransformationFactory transformationFactory;
    @PathParam(value="path")
    protected String externalPath;

    public FedoraTransform() {
    }

    @VisibleForTesting
    public FedoraTransform(String externalPath) {
        this.externalPath = externalPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void setUpRepositoryConfiguration() throws RepositoryException, IOException {
        JcrTools jcrTools = new JcrTools(true);
        Session internalSession = this.sessions.getInternalSession();
        try {
            jcrTools.registerNodeTypes(internalSession, "ldpath.cnd");
            jcrTools.findOrCreateNode(internalSession, "/fedora:system/fedora:transform", "fedora:Configuration", "fedora:NodeTypeConfiguration");
            Node node = jcrTools.findOrCreateNode(internalSession, "/fedora:system/fedora:transform/fedora:ldpath/default", "{http://www.jcp.org/jcr/nt/1.0}folder", "{http://www.jcp.org/jcr/nt/1.0}folder");
            LOGGER.debug("Transforming node: {}", (Object)node.getPath());
            if (!node.hasNode("{http://www.jcp.org/jcr/nt/1.0}base")) {
                Node baseConfig = node.addNode("{http://www.jcp.org/jcr/nt/1.0}base", "{http://www.jcp.org/jcr/nt/1.0}file");
                jcrTools.uploadFile(internalSession, baseConfig.getPath(), ((Object)((Object)this)).getClass().getResourceAsStream("/ldpath/default/nt_base_ldpath_program.txt"));
            }
            internalSession.save();
        }
        finally {
            internalSession.logout();
        }
    }

    @GET
    @Path(value="{program}")
    @Produces(value={"application/json"})
    @Timed
    public Object evaluateLdpathProgram(@PathParam(value="program") String program) throws RepositoryException {
        LOGGER.info("GET transform, '{}', for '{}'", (Object)program, (Object)this.externalPath);
        RdfStream rdfStream = this.getResourceTriples().session(this.session).topic(((Resource)this.translator().reverse().convert((Object)this.resource())).asNode());
        return LDPathTransform.getNodeTypeTransform(this.resource().getNode(), program).apply(rdfStream);
    }

    @POST
    @Consumes(value={"application/rdf+ldpath", "application/sparql-query"})
    @Produces(value={"application/json", "text/tab-separated-values", "text/csv", "text/sse", "text/plain", "application/sparql-results+json", "application/sparql-results+xml", "application/sparql-results+bio", "text/turtle", "text/rdf+n3", "application/n-triples", "application/rdf+xml"})
    @Timed
    public Object evaluateTransform(@HeaderParam(value="Content-Type") MediaType contentType, InputStream requestBodyStream) {
        if (this.transformationFactory == null) {
            this.transformationFactory = new TransformationFactory();
        }
        LOGGER.info("POST transform for '{}'", (Object)this.externalPath);
        RdfStream rdfStream = this.getResourceTriples().session(this.session).topic(((Resource)this.translator().reverse().convert((Object)this.resource())).asNode());
        return this.transformationFactory.getTransform(contentType, requestBodyStream).apply(rdfStream);
    }

    protected Session session() {
        return this.session;
    }

    protected String externalPath() {
        return this.externalPath;
    }

    protected void addResourceHttpHeaders(FedoraResource resource) {
    }
}

