/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.transform.transformations;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.ws.rs.WebApplicationException;
import org.apache.marmotta.ldpath.LDPath;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.backend.jena.GenericJenaBackend;
import org.apache.marmotta.ldpath.exception.LDPathParseException;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.fcrepo.transform.Transformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDPathTransform
implements Transformation<List<Map<String, Collection<Object>>>> {
    public static final String CONFIGURATION_FOLDER = "/fedora:system/fedora:transform/fedora:ldpath/";
    public static final String APPLICATION_RDF_LDPATH = "application/rdf+ldpath";
    private final InputStream query;
    private static final Logger LOGGER = LoggerFactory.getLogger(LDPathTransform.class);
    private static final Comparator<NodeType> nodeTypeComp = new Comparator<NodeType>(){

        @Override
        public int compare(NodeType o1, NodeType o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Function<Collection<?>, Collection<Object>> WILDCARD_COLLECTION_TO_OBJECT_COLLECTION = new Function<Collection<?>, Collection<Object>>(){

        public Collection<Object> apply(Collection<?> input) {
            return Collections2.transform(input, (Function)ANYTHING_TO_OBJECT_FUNCTION);
        }
    };
    private static final Function<Object, Object> ANYTHING_TO_OBJECT_FUNCTION = new Function<Object, Object>(){

        public Object apply(Object input) {
            return input;
        }
    };

    public LDPathTransform(InputStream query) {
        this.query = query;
    }

    public static LDPathTransform getNodeTypeTransform(Node node, String key) throws RepositoryException {
        Node programNode = node.getSession().getNode(CONFIGURATION_FOLDER + key);
        LOGGER.debug("Found program node: {}", (Object)programNode.getPath());
        NodeType primaryNodeType = node.getPrimaryNodeType();
        ImmutableSortedSet supertypes = ImmutableSortedSet.orderedBy(nodeTypeComp).add((Object[])primaryNodeType.getSupertypes()).build();
        ImmutableSortedSet mixinTypes = ImmutableSortedSet.orderedBy(nodeTypeComp).add((Object[])node.getMixinNodeTypes()).build();
        ImmutableList.Builder nodeTypesB = new ImmutableList.Builder().addAll((Iterable)mixinTypes).add((Object)primaryNodeType).addAll((Iterable)supertypes);
        for (NodeType mixin : mixinTypes) {
            nodeTypesB.addAll((Iterable)ImmutableSortedSet.orderedBy(nodeTypeComp).add((Object[])mixin.getDeclaredSupertypes()).build());
        }
        ImmutableList nodeTypes = nodeTypesB.build();
        LOGGER.debug("Discovered node types: {}", (Object)nodeTypes);
        for (NodeType nodeType : nodeTypes) {
            if (!programNode.hasNode(nodeType.toString())) continue;
            return new LDPathTransform(programNode.getNode(nodeType.toString()).getNode("jcr:content").getProperty("jcr:data").getBinary().getStream());
        }
        throw new WebApplicationException((Throwable)new Exception("Couldn't find transformation for " + node.getPath() + " and transformation key " + key), 400);
    }

    @Override
    public List<Map<String, Collection<Object>>> apply(RdfStream stream) {
        try {
            LDPath<RDFNode> ldpathForResource = LDPathTransform.getLdpathResource(stream);
            Resource context = ResourceFactory.createResource((String)stream.topic().getURI());
            Map wildcardCollection = ldpathForResource.programQuery((Object)context, (Reader)new InputStreamReader(this.query));
            return ImmutableList.of(LDPathTransform.transformLdpathOutputToSomethingSerializable(wildcardCollection));
        }
        catch (LDPathParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream getQuery() {
        return this.query;
    }

    public boolean equals(Object other) {
        return other instanceof LDPathTransform && this.query.equals(((LDPathTransform)other).getQuery());
    }

    public int hashCode() {
        return Objects.hashCode(this.getQuery());
    }

    private static LDPath<RDFNode> getLdpathResource(RdfStream rdfStream) {
        return new LDPath((RDFBackend)new GenericJenaBackend(rdfStream.asModel()));
    }

    private static Map<String, Collection<Object>> transformLdpathOutputToSomethingSerializable(Map<String, Collection<?>> collectionMap) {
        return Maps.transformValues(collectionMap, WILDCARD_COLLECTION_TO_OBJECT_COLLECTION);
    }

    public LDPathTransform newTransform(InputStream query) {
        return new LDPathTransform(query);
    }
}

