/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.transform.transformations;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.fcrepo.transform.Transformation;

public class SparqlQueryTransform
implements Transformation<QueryExecution> {
    private final InputStream query;

    public SparqlQueryTransform(InputStream query) {
        this.query = query;
    }

    @Override
    public QueryExecution apply(RdfStream rdfStream) {
        try {
            Model model = rdfStream.asModel();
            Query sparqlQuery = QueryFactory.create((String)IOUtils.toString((InputStream)this.query));
            return QueryExecutionFactory.create((Query)sparqlQuery, (Model)model);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public InputStream getQuery() {
        return this.query;
    }

    public boolean equals(Object other) {
        return other instanceof SparqlQueryTransform && this.query.equals(((SparqlQueryTransform)other).getQuery());
    }

    public int hashCode() {
        return Objects.hashCode(this.getQuery());
    }

    public SparqlQueryTransform newTransform(InputStream query) {
        return new SparqlQueryTransform(query);
    }
}

