/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.transform;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.ws.rs.core.MediaType;
import org.fcrepo.transform.Transformation;
import org.fcrepo.transform.transformations.LDPathTransform;
import org.fcrepo.transform.transformations.SparqlQueryTransform;

public class TransformationFactory {
    private final Map<String, Function<InputStream, Transformation>> mimeToTransform = new HashMap<String, Function<InputStream, Transformation>>();

    public TransformationFactory() {
        this.mimeToTransform.put("application/sparql-query", SparqlQueryTransform::new);
        this.mimeToTransform.put("application/rdf+ldpath", LDPathTransform::new);
    }

    public <T> Transformation<T> getTransform(MediaType contentType, InputStream inputStream) {
        String mimeType = contentType.toString();
        if (this.mimeToTransform.containsKey(mimeType)) {
            return this.mimeToTransform.get(contentType.toString()).apply(inputStream);
        }
        throw new UnsupportedOperationException("No transform type exists for media type " + mimeType + "!");
    }
}

