/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.localservices.imagemanip;

import com.sun.media.jai.codec.BMPEncodeParam;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.MemoryCacheSeekableStream;
import com.sun.media.jai.codec.PNGEncodeParam;
import com.sun.media.jai.codec.TIFFEncodeParam;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.GifEncoder;
import ij.process.ImageProcessor;
import ij.process.MedianCut;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;

public class ImageManipulation
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger("org.apache.catalina.core.ContainerBase.[Catalina].[localhost]");
    private String inputMimeType;
    private boolean alreadyConvertedToRGB = false;
    private final PoolingClientConnectionManager cManager = this.getConnectionManager();

    private PoolingClientConnectionManager getConnectionManager() {
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager();
        cm.getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        cm.getSchemeRegistry().register(new Scheme("https-tomcat", 8443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        cm.getSchemeRegistry().register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        cm.getSchemeRegistry().register(new Scheme("http-tomcat", 8080, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        return cm;
    }

    public void destroy() {
        this.cManager.shutdown();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        System.setProperty("java.awt.headless", "true");
        String url = req.getParameter("url");
        String op = req.getParameter("op");
        String newWidth = req.getParameter("newWidth");
        String brightAmt = req.getParameter("brightAmt");
        String zoomAmt = req.getParameter("zoomAmt");
        String wmText = req.getParameter("wmText");
        String cropX = req.getParameter("cropX");
        String cropY = req.getParameter("cropY");
        String cropWidth = req.getParameter("cropWidth");
        String cropHeight = req.getParameter("cropHeight");
        String convertTo = req.getParameter("convertTo");
        if (convertTo != null) {
            convertTo = convertTo.toLowerCase();
        }
        try {
            String outputMimeType;
            if (op == null) {
                throw new ServletException("op parameter not specified.");
            }
            BufferedImage img = this.getImage(url);
            if (op.equals("watermark")) {
                if (wmText == null) {
                    throw new ServletException("Must specify wmText.");
                }
                Graphics g = img.getGraphics();
                int fontSize = img.getWidth() * 3 / 100;
                if (fontSize < 10) {
                    fontSize = 10;
                }
                g.setFont(new Font("Lucida Sans", 1, fontSize));
                FontMetrics fm = g.getFontMetrics();
                int stringWidth = (int)fm.getStringBounds(wmText, g).getWidth();
                int x = img.getWidth() / 2 - stringWidth / 2;
                int y = img.getHeight() - fm.getHeight();
                g.setColor(new Color(180, 180, 180));
                g.fill3DRect(x - 10, y - fm.getHeight() - 4, stringWidth + 20, fm.getHeight() + 12, true);
                g.setColor(new Color(100, 100, 100));
                g.drawString(wmText, x + 2, y + 2);
                g.setColor(new Color(240, 240, 240));
                g.drawString(wmText, x, y);
            }
            ImageProcessor ip = new ImagePlus("temp", (Image)img).getProcessor();
            if (this.inputMimeType.equals("image/gif")) {
                ip = ip.convertToRGB();
                this.alreadyConvertedToRGB = true;
            }
            ip.setInterpolate(true);
            if (!op.equals("convert")) {
                if (op.equals("resize")) {
                    ip = this.resize(ip, newWidth);
                } else if (op.equals("zoom")) {
                    ip = this.zoom(ip, zoomAmt);
                } else if (op.equals("brightness")) {
                    ip = this.brightness(ip, brightAmt);
                } else if (!op.equals("watermark")) {
                    if (op.equals("grayscale")) {
                        ip = this.grayscale(ip);
                    } else if (op.equals("crop")) {
                        ip = this.crop(ip, cropX, cropY, cropWidth, cropHeight);
                    } else {
                        throw new ServletException("Invalid operation: " + op);
                    }
                }
                outputMimeType = this.inputMimeType;
            } else {
                if (convertTo == null) {
                    throw new ServletException("Neither op nor convertTo was specified.");
                }
                if (convertTo.equals("jpg") || convertTo.equals("jpeg")) {
                    outputMimeType = "image/jpeg";
                } else if (convertTo.equals("gif")) {
                    outputMimeType = "image/gif";
                } else if (convertTo.equals("tiff")) {
                    outputMimeType = "image/tiff";
                } else if (convertTo.equals("bmp")) {
                    outputMimeType = "image/bmp";
                } else if (convertTo.equals("png")) {
                    outputMimeType = "image/png";
                } else {
                    throw new ServletException("Invalid format: " + convertTo);
                }
            }
            res.setContentType(outputMimeType);
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream());
            this.outputImage(ip, (OutputStream)out, outputMimeType);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            res.sendError(500, e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private BufferedImage getImage(String url) throws Exception {
        HttpGet get = null;
        LOGGER.info("ImageManipulation: GET " + url);
        try {
            DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)this.cManager);
            client.getParams().setIntParameter("http.connection.timeout", 20000);
            get = new HttpGet(url);
            client.getParams().setBooleanParameter("http.protocol.handle-redirects", true);
            HttpResponse response = client.execute((HttpUriRequest)get);
            int resultCode = response.getStatusLine().getStatusCode();
            if (resultCode != 200) {
                throw new ServletException("Could not load image: " + url + ".  Errorcode " + resultCode + " from remote server.");
            }
            LOGGER.info("ImageManipulation: STATUS " + resultCode);
            this.inputMimeType = response.getFirstHeader("Content-Type").getValue();
            LOGGER.info("ImageManipulation: Content-Type " + this.inputMimeType);
            if (this.inputMimeType.equals("image/gif") || this.inputMimeType.equals("image/jpeg") || this.inputMimeType.equals("image/tiff") || this.inputMimeType.equals("image/bmp") || this.inputMimeType.equals("image/x-ms-bmp") || this.inputMimeType.equals("image/x-bitmap") || this.inputMimeType.equals("image/png")) {
                if (this.inputMimeType.endsWith("p")) {
                    this.inputMimeType = "image/bmp";
                }
                BufferedImage bufferedImage = JAI.create((String)"stream", (Object)new MemoryCacheSeekableStream(response.getEntity().getContent())).getAsBufferedImage();
                return bufferedImage;
            }
            try {
                throw new ServletException("Source image was not a gif, png, bmp, tiff, or jpg.");
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                throw e;
            }
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
    }

    private void outputImage(ImageProcessor ip, OutputStream out, String outputMimeType) throws Exception {
        if (outputMimeType.equals("image/gif")) {
            if (!this.alreadyConvertedToRGB) {
                ip = ip.convertToRGB();
            }
            MedianCut mc = new MedianCut((int[])ip.getPixels(), ip.getWidth(), ip.getHeight());
            ip = mc.convertToByte(256);
            ImagePlus imp = new ImagePlus("temp", ip);
            FileInfo fi = imp.getFileInfo();
            byte[] pixels = (byte[])imp.getProcessor().getPixels();
            GifEncoder ge = new GifEncoder(fi.width, fi.height, pixels, fi.reds, fi.greens, fi.blues);
            ge.write(out);
        } else {
            JPEGEncodeParam param = null;
            String format = null;
            if (outputMimeType.equals("image/jpeg")) {
                param = new JPEGEncodeParam();
                format = "JPEG";
            } else if (outputMimeType.equals("image/tiff")) {
                param = new TIFFEncodeParam();
                format = "TIFF";
            } else if (outputMimeType.equals("image/bmp")) {
                param = new BMPEncodeParam();
                format = "BMP";
            } else if (outputMimeType.equals("image/png")) {
                param = new PNGEncodeParam.RGB();
                format = "PNG";
            }
            ImageCodec.createImageEncoder((String)format, (OutputStream)out, (ImageEncodeParam)param).encode((RenderedImage)JAI.create((String)"AWTImage", (Object)ip.createImage()));
        }
    }

    private ImageProcessor resize(ImageProcessor ip, String newWidth) {
        if (newWidth != null) {
            try {
                int width = Integer.parseInt(newWidth);
                if (width < 0) {
                    return ip;
                }
                int imgWidth = ip.getWidth();
                int imgHeight = ip.getHeight();
                ip = ip.resize(width, width * imgHeight / imgWidth);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ip;
    }

    private ImageProcessor zoom(ImageProcessor ip, String zoomAmt) {
        if (zoomAmt != null) {
            try {
                float zoom = Float.parseFloat(zoomAmt);
                if (zoom < 0.0f) {
                    return ip;
                }
                ip.scale((double)zoom, (double)zoom);
                if (zoom < 1.0f) {
                    int imgWidth = ip.getWidth();
                    int imgHeight = ip.getHeight();
                    ip.setRoi(Math.round((float)(imgWidth / 2) - (float)imgWidth * zoom / 2.0f), Math.round((float)(imgHeight / 2) - (float)imgHeight * zoom / 2.0f), Math.round((float)imgWidth * zoom), Math.round((float)imgHeight * zoom));
                    ip = ip.crop();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ip;
    }

    private ImageProcessor brightness(ImageProcessor ip, String brightAmt) {
        if (brightAmt != null) {
            try {
                float bright = Float.parseFloat(brightAmt);
                if (bright < 0.0f) {
                    return ip;
                }
                ip.multiply((double)bright);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ip;
    }

    private ImageProcessor grayscale(ImageProcessor ip) {
        ip = ip.convertToByte(true);
        return ip;
    }

    public ImageProcessor crop(ImageProcessor ip, String cropX, String cropY, String cropWidth, String cropHeight) {
        if (cropX != null && cropY != null) {
            try {
                int x = Integer.parseInt(cropX);
                int y = Integer.parseInt(cropY);
                int width = cropWidth != null ? Integer.parseInt(cropWidth) : ip.getWidth();
                int height = cropHeight != null ? Integer.parseInt(cropHeight) : ip.getHeight();
                if (x < 0 || y < 0 || width < 0 || height < 0) {
                    return ip;
                }
                ip.setRoi(x, y, width, height);
                ip = ip.crop();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ip;
    }
}

