/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.jettyconsole;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyConsoleBootstrapMainClass
implements Runnable {
    private static JettyConsoleBootstrapMainClass instance;
    private ClassLoader cl;
    private Runnable shutdown;
    public static String OPTION_NAME;
    public static String SAMPLE;
    public static String DESCRIPTION;
    public static String SECTION;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(String[] arguments) throws Exception {
        System.out.println("JettyConsole Windows Service starting");
        instance = new JettyConsoleBootstrapMainClass();
        instance.setupWindowsService();
        instance.run(arguments);
        JettyConsoleBootstrapMainClass jettyConsoleBootstrapMainClass = instance;
        synchronized (jettyConsoleBootstrapMainClass) {
            instance.wait();
        }
        JettyConsoleBootstrapMainClass.instance.shutdown.run();
        System.out.println("JettyConsole Windows Service main thread exiting");
    }

    private void setupWindowsService() {
        File tempDirectory = new File(".", "temp");
        System.setProperty("java.io.tmpdir", tempDirectory.getAbsolutePath());
        tempDirectory.mkdirs();
        for (File child : tempDirectory.listFiles()) {
            this.delete(child);
        }
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.delete(child);
            }
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(String[] args) {
        System.out.println("JettyConsole Windows Service stopping");
        JettyConsoleBootstrapMainClass jettyConsoleBootstrapMainClass = instance;
        synchronized (jettyConsoleBootstrapMainClass) {
            instance.notifyAll();
        }
    }

    public static void main(String[] arguments) throws Exception {
        new JettyConsoleBootstrapMainClass().run(arguments);
    }

    private void run(String[] arguments) throws Exception {
        if (this.isHelpRequested(arguments)) {
            JettyConsoleBootstrapMainClass.usage();
        }
        this.validateArguments(arguments);
        this.checkTemporaryDirectory(arguments);
        this.addShutdownHook();
        File war = JettyConsoleBootstrapMainClass.getWarLocation();
        File tempDirectory = this.createTempDirectory(war.getName(), this.getPort(arguments));
        this.cl = this.createClassLoader(war, tempDirectory);
        Thread.currentThread().setContextClassLoader(this.cl);
        this.startJettyConsole(this.cl, arguments, tempDirectory);
    }

    private void validateArguments(String[] args) {
        Map<String, Option> optionsByName = JettyConsoleBootstrapMainClass.getOptionsByName();
        for (int i = 0; i < args.length; ++i) {
            Option option;
            String arg = args[i].trim();
            if (!arg.startsWith("--")) {
                JettyConsoleBootstrapMainClass.usage("Options must start with '--': " + args);
            }
            if ((option = optionsByName.get((arg = arg.substring(2)).toLowerCase())) == null) {
                JettyConsoleBootstrapMainClass.usage("Unknown option: '" + arg + "'");
                continue;
            }
            if (option.getSample() == null) continue;
            if (i == args.length - 1) {
                JettyConsoleBootstrapMainClass.usage("--" + arg + " option requires a value");
            }
            ++i;
        }
    }

    public static Map<String, Option> getOptionsByName() {
        HashMap<String, Option> optionsByName = new HashMap<String, Option>();
        for (Option option : JettyConsoleBootstrapMainClass.readOptions()) {
            optionsByName.put(option.getName().toLowerCase(), option);
        }
        return optionsByName;
    }

    private File createTempDirectory(String name, int port) {
        File javaTemp = new File(System.getProperty("java.io.tmpdir"));
        File temp = new File(javaTemp, name + "_" + port);
        temp.deleteOnExit();
        temp.mkdirs();
        return temp;
    }

    private int getPort(String[] arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            String argument = arguments[i];
            if (!"--port".equals(argument)) continue;
            if (i + 1 == arguments.length) {
                this.err("--port option requires a value");
            }
            try {
                return Integer.parseInt(arguments[i + 1]);
            }
            catch (NumberFormatException e) {
                this.err("--port value must be an integer");
                i += 2;
            }
        }
        return 8080;
    }

    private void checkTemporaryDirectory(String[] arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            String argument = arguments[i];
            if (!"--tmpDir".equals(argument)) continue;
            if (i == arguments.length - 1) {
                this.err("--tmpDir must take a path as an argument");
                continue;
            }
            File tmpDir = new File(arguments[i + 1]);
            if (!tmpDir.exists()) {
                this.err("tmpDir does not exist: " + tmpDir);
                continue;
            }
            if (!tmpDir.isDirectory()) {
                this.err("tmpDir is not a directory: " + tmpDir);
                continue;
            }
            System.setProperty("java.io.tmpdir", tmpDir.getAbsolutePath());
        }
    }

    private void err(String msg) {
        System.err.println();
        System.err.println("ERROR: " + msg);
        System.exit(0);
    }

    private void startJettyConsole(ClassLoader cl, String[] arguments, File tempDirectory) {
        try {
            Class<?> starterClass = cl.loadClass("org.simplericity.jettyconsole.JettyConsoleStarter");
            starterClass.getField("jettyWorkDirectory").set(null, tempDirectory);
            Method main = starterClass.getMethod("main", arguments.getClass());
            main.invoke(null, new Object[]{arguments});
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private void stopJettyConsole(ClassLoader cl) {
        if (cl != null) {
            try {
                Class<?> starterClass = cl.loadClass("org.simplericity.jettyconsole.JettyConsoleStarter");
                Method main = starterClass.getMethod("stop", new Class[0]);
                main.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private ClassLoader createClassLoader(File warFile, File tempDirectory) {
        try {
            JarEntry entry;
            File condiLibDirectory = new File(tempDirectory, "condi");
            condiLibDirectory.mkdirs();
            File jettyWebappDirectory = new File(tempDirectory, "webapp");
            jettyWebappDirectory.mkdirs();
            ArrayList<URL> urls = new ArrayList<URL>();
            URL mainResource = this.getClass().getClassLoader().getResource(this.getClass().getName().replace('.', '/') + ".class");
            JarInputStream in = new JarInputStream(new FileInputStream(warFile));
            while ((entry = in.getNextJarEntry()) != null) {
                String name = entry.getName();
                String prefix = "META-INF/jettyconsole/lib/";
                if (entry.isDirectory()) continue;
                if (name.startsWith(prefix)) {
                    String simpleName = name.substring(name.lastIndexOf("/") + 1);
                    File file = new File(condiLibDirectory, simpleName);
                    JettyConsoleBootstrapMainClass.unpackFile(in, file);
                    urls.add(file.toURI().toURL());
                    continue;
                }
                if (name.startsWith("META-INF/jettyconsole") || name.contains("JettyConsoleBootstrapMainClass")) continue;
                File file = new File(jettyWebappDirectory, name);
                file.getParentFile().mkdirs();
                JettyConsoleBootstrapMainClass.unpackFile(in, file);
            }
            in.close();
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), JettyConsoleBootstrapMainClass.class.getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addShutdownHook() {
        this.shutdown = this;
        Runtime.getRuntime().addShutdownHook(new Thread(this.shutdown));
    }

    @Override
    public void run() {
        this.stopJettyConsole(this.cl);
    }

    public static File getWarLocation() {
        URL resource = JettyConsoleBootstrapMainClass.class.getResource("/WEB-INF/web.xml");
        String file = resource.getFile();
        file = file.substring("file:".length(), file.indexOf("!"));
        try {
            file = URLDecoder.decode(file, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return new File(file);
    }

    private static void unpackFile(InputStream in, File file) {
        byte[] buffer = new byte[4096];
        try {
            int read;
            FileOutputStream out = new FileOutputStream(file);
            while ((read = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isHelpRequested(String[] args) {
        for (String arg : args) {
            if (!"--help".equalsIgnoreCase(arg)) continue;
            return true;
        }
        return false;
    }

    public static void usage() {
        JettyConsoleBootstrapMainClass.usage(null);
    }

    public static void usage(String args) {
        PrintStream err = System.err;
        if (args != null) {
            err.println("ERROR: " + args);
            err.println();
        }
        err.println("Usage: java -jar " + JettyConsoleBootstrapMainClass.getWarLocation().getName() + " [--option value] [--option2 value2] [--option3]");
        err.println();
        Map<String, List<Option>> options = JettyConsoleBootstrapMainClass.createOptionsBySectionMap();
        TreeSet<String> sortedSections = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String s, String s1) {
                if (s.equals("Options")) {
                    return -1;
                }
                if (s1.equals("Options")) {
                    return 1;
                }
                return s.compareTo(s1);
            }
        });
        sortedSections.addAll(options.keySet());
        for (String section : sortedSections) {
            err.println(section + ":");
            for (Option option : options.get(section)) {
                StringBuilder line = new StringBuilder(" --" + option.getName() + " ");
                if (option.getSample() != null) {
                    line.append(option.getSample()).append(" ");
                }
                while (line.length() < 21) {
                    line.append(" ");
                }
                line.append("- ").append(option.getDescription());
                err.println(line);
            }
            err.println();
        }
        System.exit(1);
    }

    private static Map<String, List<Option>> createOptionsBySectionMap() {
        TreeMap<String, List<Option>> map = new TreeMap<String, List<Option>>();
        for (Option option : JettyConsoleBootstrapMainClass.readOptions()) {
            if (!map.containsKey(option.getSection())) {
                map.put(option.getSection(), new ArrayList());
            }
            ((List)map.get(option.getSection())).add(option);
        }
        return map;
    }

    private static List<Option> readOptions() {
        return JettyConsoleBootstrapMainClass.parseOptions(JettyConsoleBootstrapMainClass.readOptionLines(JettyConsoleBootstrapMainClass.class.getClassLoader().getResource("META-INF/jettyconsole/options.txt")));
    }

    static List<String> readOptionLines(URL resource) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), "utf-8"));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            return lines;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static List<Option> parseOptions(List<String> lines) {
        ArrayList<Option> options = new ArrayList<Option>();
        Option current = null;
        for (String line : lines) {
            if ((line = line.trim()).startsWith(OPTION_NAME)) {
                String name = line.substring(OPTION_NAME.length()).trim();
                current = new Option(name);
                options.add(current);
                continue;
            }
            if (line.startsWith(SAMPLE)) {
                String sample = line.substring(SAMPLE.length()).trim();
                current.setSample(sample);
                continue;
            }
            if (line.startsWith(DESCRIPTION)) {
                String description = line.substring(DESCRIPTION.length()).trim();
                current.setDescription(description);
                continue;
            }
            if (!line.startsWith(SECTION)) continue;
            String section = line.substring(SECTION.length()).trim();
            current.setSection(section);
        }
        return options;
    }

    static {
        OPTION_NAME = "option:";
        SAMPLE = "sample:";
        DESCRIPTION = "desc:";
        SECTION = "section:";
    }

    public static class Option {
        private final String name;
        private String sample;
        private String description;
        private String section;

        public Option(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getSample() {
            return this.sample;
        }

        public String getDescription() {
            return this.description;
        }

        public void setSample(String sample) {
            this.sample = sample;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getSection() {
            return this.section;
        }

        public void setSection(String section) {
            this.section = section;
        }
    }
}

