/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.webapp;

import java.util.HashSet;
import java.util.List;
import javax.servlet.Filter;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.spring.LifecycleBeanPostProcessor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.filter.InvalidRequestFilter;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.fcrepo.auth.common.ContainerRolesPrincipalProvider;
import org.fcrepo.auth.common.DelegateHeaderPrincipalProvider;
import org.fcrepo.auth.common.HttpHeaderPrincipalProvider;
import org.fcrepo.auth.common.PrincipalProvider;
import org.fcrepo.auth.common.ServletContainerAuthFilter;
import org.fcrepo.auth.common.ServletContainerAuthenticatingRealm;
import org.fcrepo.auth.webac.WebACAuthorizingRealm;
import org.fcrepo.auth.webac.WebACFilter;
import org.fcrepo.config.AuthPropsConfig;
import org.fcrepo.config.ConditionOnPropertyTrue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@Conditional(value={AuthorizationEnabled.class})
public class AuthConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthConfig.class);

    @Bean
    @Order(value=3)
    @Conditional(value={HeaderPrincipalEnabled.class})
    public PrincipalProvider headerProvider(AuthPropsConfig propsConfig) {
        LOGGER.info("Auth header principal provider enabled");
        HttpHeaderPrincipalProvider provider = new HttpHeaderPrincipalProvider();
        provider.setHeaderName(propsConfig.getAuthPrincipalHeaderName());
        provider.setSeparator(propsConfig.getAuthPrincipalHeaderSeparator());
        return provider;
    }

    @Bean
    @Order(value=4)
    @Conditional(value={RolesPrincipalEnabled.class})
    public PrincipalProvider containerRolesProvider(AuthPropsConfig propsConfig) {
        LOGGER.info("Auth roles principal provider enabled");
        ContainerRolesPrincipalProvider provider = new ContainerRolesPrincipalProvider();
        provider.setRoleNames(new HashSet(propsConfig.getAuthPrincipalRolesList()));
        return provider;
    }

    @Bean
    @Order(value=5)
    @Conditional(value={DelegatePrincipalEnabled.class})
    public PrincipalProvider delegatedPrincipalProvider() {
        LOGGER.info("Auth delegate principal provider enabled");
        return new DelegateHeaderPrincipalProvider();
    }

    @Bean
    public AuthorizingRealm webACAuthorizingRealm() {
        return new WebACAuthorizingRealm();
    }

    @Bean
    public AuthenticatingRealm servletContainerAuthenticatingRealm() {
        return new ServletContainerAuthenticatingRealm();
    }

    @Bean
    public WebSecurityManager securityManager() {
        DefaultWebSecurityManager manager = new DefaultWebSecurityManager();
        manager.setRealms(List.of(this.webACAuthorizingRealm(), this.servletContainerAuthenticatingRealm()));
        return manager;
    }

    @Bean
    public LifecycleBeanPostProcessor lifecycleBeanPostProcessor() {
        return new LifecycleBeanPostProcessor();
    }

    @Bean
    @Order(value=1)
    public Filter servletContainerAuthFilter() {
        return new ServletContainerAuthFilter();
    }

    @Bean
    @Order(value=2)
    public Filter webACFilter() {
        return new WebACFilter();
    }

    @Bean
    @Order(value=6)
    public Filter invalidRequest() {
        InvalidRequestFilter filter = new InvalidRequestFilter();
        filter.setBlockNonAscii(false);
        filter.setBlockBackslash(false);
        filter.setBlockSemicolon(false);
        return filter;
    }

    @Bean
    @Order(value=100)
    public ShiroFilterFactoryBean shiroFilter(AuthPropsConfig propsConfig) {
        ShiroFilterFactoryBean filter = new ShiroFilterFactoryBean();
        filter.setSecurityManager((SecurityManager)this.securityManager());
        filter.setFilterChainDefinitions("/** = servletContainerAuthFilter," + this.principalProviderChain(propsConfig) + "webACFilter");
        return filter;
    }

    private String principalProviderChain(AuthPropsConfig propsConfig) {
        StringBuilder builder = new StringBuilder();
        if (propsConfig.isAuthPrincipalHeaderEnabled()) {
            builder.append("headerProvider,");
        }
        if (propsConfig.isAuthPrincipalRolesEnabled()) {
            builder.append("containerRolesProvider,");
        }
        if (propsConfig.isAuthPrincipalDelegateEnabled()) {
            builder.append("delegatedPrincipalProvider,");
        }
        return builder.toString();
    }

    static class DelegatePrincipalEnabled
    extends ConditionOnPropertyTrue {
        DelegatePrincipalEnabled() {
            super("fcrepo.auth.principal.delegate.enabled", true);
        }
    }

    static class RolesPrincipalEnabled
    extends ConditionOnPropertyTrue {
        RolesPrincipalEnabled() {
            super("fcrepo.auth.principal.roles.enabled", false);
        }
    }

    static class HeaderPrincipalEnabled
    extends ConditionOnPropertyTrue {
        HeaderPrincipalEnabled() {
            super("fcrepo.auth.principal.header.enabled", false);
        }
    }

    static class AuthorizationEnabled
    extends ConditionOnPropertyTrue {
        AuthorizationEnabled() {
            super("fcrepo.auth.enabled", true);
        }
    }
}

