/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.webapp;

import javax.annotation.PostConstruct;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.fcrepo.config.ConditionOnPropertyTrue;
import org.fcrepo.config.FedoraPropsConfig;
import org.fcrepo.config.JmsDestination;
import org.fcrepo.jms.AbstractJMSPublisher;
import org.fcrepo.jms.DefaultMessageFactory;
import org.fcrepo.jms.JMSEventMessageFactory;
import org.fcrepo.jms.JMSQueuePublisher;
import org.fcrepo.jms.JMSTopicPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@Conditional(value={JmsEnabled.class})
public class JmsConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsConfig.class);

    @PostConstruct
    public void postConstruct() {
        LOGGER.info("JMS messaging enabled");
    }

    @Bean
    public AbstractJMSPublisher jmsPublisher(FedoraPropsConfig propsConfig) {
        if (propsConfig.getJmsDestinationType() == JmsDestination.QUEUE) {
            return new JMSQueuePublisher(propsConfig.getJmsDestinationName());
        }
        return new JMSTopicPublisher(propsConfig.getJmsDestinationName());
    }

    @Bean
    public JMSEventMessageFactory messageFactory() {
        return new DefaultMessageFactory();
    }

    @Bean
    public BrokerFactoryBean jmsBroker(FedoraPropsConfig propsConfig) {
        BrokerFactoryBean factory = new BrokerFactoryBean();
        factory.setConfig(propsConfig.getActiveMQConfiguration());
        factory.setStart(true);
        return factory;
    }

    @Bean
    @DependsOn(value={"jmsBroker"})
    public ActiveMQConnectionFactory connectionFactory(FedoraPropsConfig propsConfig) {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        factory.setBrokerURL(String.format("vm://%s:%s?create=false", propsConfig.getJmsHost(), propsConfig.getJmsPort()));
        return factory;
    }

    static class JmsEnabled
    extends ConditionOnPropertyTrue {
        JmsEnabled() {
            super("fcrepo.jms.enabled", true);
        }
    }
}

