/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.webapp;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fcrepo.config.ConditionOnPropertyFalse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.OncePerRequestFilter;

@Configuration
@Conditional(value={AuthorizationDisabled.class})
public class NoAuthConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoAuthConfig.class);

    @Bean
    public Filter shiroFilter() {
        LOGGER.info("Authorization is disabled");
        return new OncePerRequestFilter(){

            protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        };
    }

    static class AuthorizationDisabled
    extends ConditionOnPropertyFalse {
        AuthorizationDisabled() {
            super("fcrepo.auth.enabled", true);
        }
    }
}

