/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.webapp;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.servlet.Filter;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.fcrepo.config.FedoraPropsConfig;
import org.fcrepo.http.api.ExternalContentHandlerFactory;
import org.fcrepo.http.api.ExternalContentPathValidator;
import org.fcrepo.kernel.api.auth.ACLHandle;
import org.fcrepo.kernel.api.rdf.RdfNamespaceRegistry;
import org.fcrepo.persistence.ocfl.RepositoryInitializationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@EnableAsync
@EnableScheduling
public class WebappConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebappConfig.class);
    @Inject
    private FedoraPropsConfig fedoraPropsConfig;

    @Bean
    public ThreadPoolTaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(1);
        scheduler.setThreadNamePrefix("ScheduledTask");
        return scheduler;
    }

    @Bean
    public HttpClientConnectionManager connectionManager() {
        return new PoolingHttpClientConnectionManager();
    }

    @Bean
    public EventBus eventBus(FedoraPropsConfig propsConfig) {
        return new AsyncEventBus((Executor)this.eventBusExecutor(propsConfig));
    }

    @Bean
    public ExecutorService eventBusExecutor(FedoraPropsConfig propsConfig) {
        LOGGER.debug("Event bus threads: {}", (Object)propsConfig);
        return Executors.newFixedThreadPool(propsConfig.getEventBusThreads());
    }

    @Bean(initMethod="init", destroyMethod="shutdown")
    public RdfNamespaceRegistry rdfNamespaceRegistry(FedoraPropsConfig propsConfig) {
        RdfNamespaceRegistry registry = new RdfNamespaceRegistry();
        registry.setConfigPath(propsConfig.getNamespaceRegistry());
        registry.setMonitorForChanges(true);
        return registry;
    }

    @Bean(initMethod="init", destroyMethod="shutdown")
    public ExternalContentPathValidator externalContentPathValidator(FedoraPropsConfig propsConfig) {
        ExternalContentPathValidator validator = new ExternalContentPathValidator();
        validator.setConfigPath(propsConfig.getExternalContentAllowed());
        validator.setMonitorForChanges(true);
        return validator;
    }

    @Bean
    public ExternalContentHandlerFactory externalContentHandlerFactory(ExternalContentPathValidator validator) {
        ExternalContentHandlerFactory factory = new ExternalContentHandlerFactory();
        factory.setValidator(validator);
        return factory;
    }

    @Bean
    public Cache<String, Optional<ACLHandle>> authHandleCache() {
        return Caffeine.newBuilder().weakValues().expireAfterAccess(this.fedoraPropsConfig.getWebacCacheTimeout(), TimeUnit.MINUTES).maximumSize(this.fedoraPropsConfig.getWebacCacheSize()).build();
    }

    @Bean
    public Filter repositoryInitializationFilter() {
        return new RepositoryInitializationFilter();
    }
}

