/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.jettyconsole.jsp;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.jasper.EmbeddedServletOptions;
import org.eclipse.jetty.jsp.JettyJspServlet;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;

public class EmbeddedJspConfiguration
extends AbstractConfiguration {
    public void postConfigure(WebAppContext context) throws Exception {
        this.rewriteJasperSystemClasspath(context);
    }

    private void rewriteJasperSystemClasspath(WebAppContext context) throws NoSuchFieldException, IllegalAccessException {
        JettyJspServlet jspServlet = (JettyJspServlet)context.getServletHandler().getServlet("jsp").getServletInstance();
        Class<?> JspServletClass = jspServlet.getClass().getSuperclass();
        Field optionsField = JspServletClass.getDeclaredField("options");
        optionsField.setAccessible(true);
        EmbeddedServletOptions options = (EmbeddedServletOptions)optionsField.get(jspServlet);
        String sysClassPath = options.getProperty("com.sun.appserv.jsp.classpath");
        String filteredSysClassPath = this.filterSysClassPath(sysClassPath);
        options.setProperty("com.sun.appserv.jsp.classpath", filteredSysClassPath);
    }

    private String filterSysClassPath(String sysClassPath) {
        if (sysClassPath == null) {
            return sysClassPath;
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (String path : sysClassPath.split(File.pathSeparator)) {
            if (!this.isJspCompilePath(path)) continue;
            paths.add(path);
        }
        StringBuilder newPath = new StringBuilder();
        for (String path : paths) {
            if (newPath.length() != 0) {
                newPath.append(File.pathSeparator);
            }
            newPath.append(path);
        }
        return newPath.toString();
    }

    private boolean isJspCompilePath(String path) {
        String fileName = path.substring(path.lastIndexOf(File.separator) + 1);
        return !path.contains(File.separator + "condi" + File.separator) || fileName.startsWith("javax") || fileName.contains("apache-jsp") || fileName.contains("apache-el") || fileName.contains("jasper") || fileName.contains("taglibs-standard");
    }
}

