/*
 * Decompiled with CFR 0.152.
 */
package org.simplericity.jettyconsole.log4j;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.jetty.webapp.WebAppContext;
import org.simplericity.jettyconsole.api.DefaultStartOption;
import org.simplericity.jettyconsole.api.JettyConsolePluginBase;
import org.simplericity.jettyconsole.api.StartOption;

public class Log4jPlugin
extends JettyConsolePluginBase {
    private File logFile;
    private StartOption logFileOption = new DefaultStartOption("logConfig"){

        public String validate(String value) {
            Log4jPlugin.this.logFile = new File(value);
            if (!Log4jPlugin.this.logFile.exists()) {
                return "Could not read log4j configuration file. File does not exist: " + Log4jPlugin.this.logFile.getAbsolutePath();
            }
            return null;
        }
    };

    public Log4jPlugin() {
        super(Log4jPlugin.class);
        this.addStartOptions(new StartOption[]{this.logFileOption});
    }

    public void beforeStart(WebAppContext context) {
        ArrayList<String> systemClasses = new ArrayList<String>(Arrays.asList(context.getSystemClasses()));
        systemClasses.add("org.apache.log4j.");
        context.setSystemClasses(systemClasses.toArray(new String[systemClasses.size()]));
    }

    public void bootstrap() {
        if (this.logFile != null) {
            PropertyConfigurator.configureAndWatch((String)this.logFile.getAbsolutePath(), (long)10000L);
        } else {
            BasicConfigurator.configure();
            Logger.getRootLogger().setLevel(Level.INFO);
        }
    }
}

