/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.api.model;

import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.util.Enforce;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class FileDetails {
    private String path;
    private String storageRelativePath;
    private Map<DigestAlgorithm, String> fixity = new HashMap<DigestAlgorithm, String>();

    public String getPath() {
        return this.path;
    }

    public FileDetails setPath(String path) {
        this.path = path;
        return this;
    }

    public String getStorageRelativePath() {
        return this.storageRelativePath;
    }

    public FileDetails setStorageRelativePath(String storageRelativePath) {
        this.storageRelativePath = storageRelativePath;
        return this;
    }

    public Map<DigestAlgorithm, String> getFixity() {
        return this.fixity;
    }

    public FileDetails setFixity(Map<DigestAlgorithm, String> fixity) {
        this.fixity = fixity;
        return this;
    }

    public FileDetails addDigest(DigestAlgorithm algorithm, String value) {
        Enforce.notNull(algorithm, "algorithm cannot be null");
        Enforce.notBlank(value, "value cannot be null");
        this.fixity.put(algorithm, value);
        return this;
    }

    public String toString() {
        return "FileDetails{path='" + this.path + "'storageRelativePath='" + this.storageRelativePath + "', fixity=" + this.fixity + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileDetails that = (FileDetails)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.storageRelativePath, that.storageRelativePath) && Objects.equals(this.fixity, that.fixity);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.storageRelativePath, this.fixity);
    }
}

