/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.model;

import edu.wisc.library.ocfl.api.util.Enforce;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class PathBiMap {
    private final Map<String, Set<String>> fileIdToPaths = new TreeMap<String, Set<String>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, String> pathToFileId = new HashMap<String, String>();

    public static PathBiMap fromFileIdMap(Map<String, Set<String>> map) {
        Enforce.notNull(map, "map cannot be null");
        PathBiMap biMap = new PathBiMap();
        map.forEach((digest, paths) -> paths.forEach(path -> biMap.put((String)digest, (String)path)));
        return biMap;
    }

    public boolean containsFileId(String fileId) {
        return this.fileIdToPaths.containsKey(fileId);
    }

    public boolean containsPath(String path) {
        return this.pathToFileId.containsKey(path);
    }

    public void put(String fileId, String path) {
        this.fileIdToPaths.computeIfAbsent(fileId, k -> new TreeSet(Comparator.naturalOrder())).add(path);
        this.pathToFileId.put(path, fileId);
    }

    public Set<String> getPaths(String fileId) {
        return this.fileIdToPaths.getOrDefault(fileId, Collections.EMPTY_SET);
    }

    public String getFileId(String path) {
        return this.pathToFileId.get(path);
    }

    public String removePath(String path) {
        Set<String> paths;
        String fileId = this.pathToFileId.remove(path);
        if (fileId != null && (paths = this.fileIdToPaths.get(fileId)) != null) {
            if (paths.size() == 1 && paths.contains(path)) {
                this.fileIdToPaths.remove(fileId);
            } else {
                paths.remove(path);
            }
        }
        return fileId;
    }

    public Set<String> removeFileId(String fileId) {
        Set<String> paths = this.fileIdToPaths.remove(fileId);
        if (paths == null) {
            return Collections.emptySet();
        }
        paths.forEach(this.pathToFileId::remove);
        return paths;
    }

    public Map<String, Set<String>> getFileIdToPaths() {
        return Collections.unmodifiableMap(this.fileIdToPaths);
    }

    public Map<String, String> getPathToFileId() {
        return Collections.unmodifiableMap(this.pathToFileId);
    }

    public String toString() {
        return "PathBiMap{fileIdToPaths=" + this.fileIdToPaths + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathBiMap pathBiMap = (PathBiMap)o;
        return this.pathToFileId.equals(pathBiMap.pathToFileId);
    }

    public int hashCode() {
        return Objects.hash(this.pathToFileId);
    }
}

