/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.path.constraint;

import edu.wisc.library.ocfl.core.path.constraint.BitSetPathCharConstraint;
import edu.wisc.library.ocfl.core.path.constraint.ContentPathConstraintProcessor;
import edu.wisc.library.ocfl.core.path.constraint.DefaultContentPathConstraintProcessor;
import edu.wisc.library.ocfl.core.path.constraint.FileNameConstraint;
import edu.wisc.library.ocfl.core.path.constraint.PathCharConstraint;
import edu.wisc.library.ocfl.core.path.constraint.PathConstraintProcessor;
import edu.wisc.library.ocfl.core.path.constraint.PathLengthConstraint;
import edu.wisc.library.ocfl.core.path.constraint.RegexPathConstraint;
import java.util.regex.Pattern;

public final class ContentPathConstraints {
    private static final char NUL = '\u0000';
    private static final char ASCII_CTRL_START = '\u0000';
    private static final char ASCII_CTRL_END = '\u001f';
    private static final char ASCII_CTRL_EXT_START = '\u007f';
    private static final char ASCII_CTRL_EXT_END = '\u00a0';
    private static final FileNameConstraint NO_SPACE_OR_PERIOD_AT_END = RegexPathConstraint.mustNotContain(Pattern.compile("^.*[ .]$"));
    private static final FileNameConstraint NO_WINDOWS_RESERVED_WORDS = RegexPathConstraint.mustNotContain(Pattern.compile("^(?:CON|PRN|AUX|NUL|COM1|COM2|COM3|COM4|COM5|COM6|COM7|COM8|COM9|LPT1|LPT2|LPT3|LPT4|LPT5|LPT6|LPT7|LPT8|LPT9)(?:\\.[^.]+)?$", 2));
    private static final PathCharConstraint NO_ASCII_CTRL = BitSetPathCharConstraint.blockListRange('\u0000', '\u001f');
    private static final PathCharConstraint NO_ASCII_EXT_CTRL = BitSetPathCharConstraint.blockListRange('\u007f', '\u00a0');

    private ContentPathConstraints() {
    }

    public static ContentPathConstraintProcessor unix() {
        return DefaultContentPathConstraintProcessor.builder().contentPathConstraintProcessor(PathConstraintProcessor.builder().fileNameConstraint(PathLengthConstraint.maxBytes(255)).charConstraint(BitSetPathCharConstraint.blockList('\u0000')).build()).build();
    }

    public static ContentPathConstraintProcessor windows() {
        return DefaultContentPathConstraintProcessor.builder().contentPathConstraintProcessor(PathConstraintProcessor.builder().fileNameConstraint(PathLengthConstraint.maxChars(255)).fileNameConstraint(NO_WINDOWS_RESERVED_WORDS).fileNameConstraint(NO_SPACE_OR_PERIOD_AT_END).charConstraint(NO_ASCII_CTRL).charConstraint(BitSetPathCharConstraint.blockList('<', '>', ':', '\"', '\\', '|', '?', '*')).build()).build();
    }

    public static ContentPathConstraintProcessor cloud() {
        return DefaultContentPathConstraintProcessor.builder().storagePathConstraintProcessor(PathConstraintProcessor.builder().pathConstraint(PathLengthConstraint.maxBytes(1024)).build()).contentPathConstraintProcessor(PathConstraintProcessor.builder().fileNameConstraint(PathLengthConstraint.maxChars(254)).fileNameConstraint(NO_SPACE_OR_PERIOD_AT_END).charConstraint(NO_ASCII_CTRL).charConstraint(NO_ASCII_EXT_CTRL).charConstraint(BitSetPathCharConstraint.blockList('\\', '#', '[', ']', '*', '?')).build()).build();
    }

    public static ContentPathConstraintProcessor all() {
        return DefaultContentPathConstraintProcessor.builder().storagePathConstraintProcessor(PathConstraintProcessor.builder().pathConstraint(PathLengthConstraint.maxBytes(1024)).build()).contentPathConstraintProcessor(PathConstraintProcessor.builder().fileNameConstraint(PathLengthConstraint.maxBytes(255)).fileNameConstraint(PathLengthConstraint.maxChars(254)).fileNameConstraint(NO_WINDOWS_RESERVED_WORDS).fileNameConstraint(NO_SPACE_OR_PERIOD_AT_END).charConstraint(NO_ASCII_CTRL).charConstraint(NO_ASCII_EXT_CTRL).charConstraint(BitSetPathCharConstraint.blockList('<', '>', ':', '\"', '\\', '|', '?', '*', '#', '[', ']')).build()).build();
    }

    public static ContentPathConstraintProcessor none() {
        return DefaultContentPathConstraintProcessor.builder().build();
    }
}

