/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.storage.cloud;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.storage.cloud.CloudClient;
import edu.wisc.library.ocfl.core.storage.cloud.CloudOcflStorage;
import edu.wisc.library.ocfl.core.storage.cloud.CloudOcflStorageInitializer;
import edu.wisc.library.ocfl.core.util.ObjectMappers;

public class CloudOcflStorageBuilder {
    private ObjectMapper objectMapper = ObjectMappers.prettyPrintMapper();
    private CloudClient cloudClient;
    private CloudOcflStorageInitializer initializer;

    public CloudOcflStorageBuilder cloudClient(CloudClient cloudClient) {
        this.cloudClient = cloudClient;
        return this;
    }

    public CloudOcflStorageBuilder objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = Enforce.notNull(objectMapper, "objectMapper cannot be null");
        return this;
    }

    public CloudOcflStorageBuilder initializer(CloudOcflStorageInitializer initializer) {
        this.initializer = initializer;
        return this;
    }

    public CloudOcflStorage build() {
        CloudOcflStorageInitializer init = this.initializer;
        if (init == null) {
            init = new CloudOcflStorageInitializer(this.cloudClient, this.objectMapper);
        }
        return new CloudOcflStorage(this.cloudClient, init);
    }
}

