/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.validation;

import at.favre.lib.bytes.Bytes;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.util.Enforce;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class MultiDigestInputStream
extends FilterInputStream {
    private final Map<DigestAlgorithm, DigestInputStream> streamMap;

    public static MultiDigestInputStream create(InputStream inputStream, Collection<DigestAlgorithm> digestAlgorithms) {
        Enforce.notNull(inputStream, "inputStream cannot be null");
        Enforce.notNull(digestAlgorithms, "digestAlgorithms cannot be null");
        HashMap<DigestAlgorithm, DigestInputStream> streamMap = new HashMap<DigestAlgorithm, DigestInputStream>();
        InputStream wrapped = inputStream;
        for (DigestAlgorithm algorithm : digestAlgorithms) {
            DigestInputStream digestStream = new DigestInputStream(wrapped, algorithm.getMessageDigest());
            wrapped = digestStream;
            streamMap.put(algorithm, digestStream);
        }
        return new MultiDigestInputStream(wrapped, streamMap);
    }

    private MultiDigestInputStream(InputStream stream, Map<DigestAlgorithm, DigestInputStream> streamMap) {
        super(stream);
        this.streamMap = streamMap;
    }

    public Map<DigestAlgorithm, String> getResults() {
        HashMap<DigestAlgorithm, String> results = new HashMap<DigestAlgorithm, String>();
        this.streamMap.forEach((algorithm, stream) -> results.put((DigestAlgorithm)algorithm, Bytes.wrap(stream.getMessageDigest().digest()).encodeHex()));
        return results;
    }
}

