/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.library.ocfl.core.validation.storage;

import edu.wisc.library.ocfl.api.exception.NotFoundException;
import edu.wisc.library.ocfl.api.util.Enforce;
import edu.wisc.library.ocfl.core.storage.cloud.CloudClient;
import edu.wisc.library.ocfl.core.storage.cloud.KeyNotFoundException;
import edu.wisc.library.ocfl.core.storage.cloud.ListResult;
import edu.wisc.library.ocfl.core.validation.storage.Listing;
import edu.wisc.library.ocfl.core.validation.storage.Storage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class CloudStorage
implements Storage {
    private final CloudClient client;

    public CloudStorage(CloudClient client) {
        this.client = Enforce.notNull(client, "client cannot be null");
    }

    @Override
    public List<Listing> listDirectory(String directoryPath, boolean recursive) {
        ListResult result;
        ArrayList<Listing> listings = new ArrayList<Listing>();
        if (recursive) {
            Object prefix = directoryPath.endsWith("/") ? directoryPath : directoryPath + "/";
            result = this.client.list((String)prefix);
        } else {
            result = this.client.listDirectory(directoryPath);
        }
        result.getObjects().forEach(object -> listings.add(Listing.file(object.getKeySuffix())));
        result.getDirectories().forEach(dir -> listings.add(Listing.directory(dir.getName())));
        return listings;
    }

    @Override
    public boolean fileExists(String filePath) {
        try {
            this.client.head(filePath);
            return true;
        }
        catch (KeyNotFoundException e2) {
            return false;
        }
    }

    @Override
    public InputStream readFile(String filePath) {
        try {
            return this.client.downloadStream(filePath);
        }
        catch (KeyNotFoundException e2) {
            throw new NotFoundException(String.format("%s was not found", filePath), e2);
        }
    }
}

